/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.core;

import com.sagacloud.util.compute_engine.core.AnnotationDescription;
import com.sagacloud.util.compute_engine.core.ICustomFunction;
import com.sagacloud.util.compute_engine.util.Constant;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class CustomFunctionManager {
    private static CustomFunctionManager instance = new CustomFunctionManager();
    Map<String, ICustomFunction> functionMap = new HashMap<String, ICustomFunction>();

    public static CustomFunctionManager Instance() {
        return instance;
    }

    private CustomFunctionManager() {
        this.LoadClassByReflections();
        this.LoadClassByJar();
    }

    private void LoadClassByReflections() {
        try {
            Reflections reflections = new Reflections("com.sagacloud.extend.customfunction", new Scanner[0]);
            Set annotated = reflections.getTypesAnnotatedWith(AnnotationDescription.class);
            for (Class clazz : annotated) {
                Class<?>[] interfaces = clazz.getInterfaces();
                boolean flag = false;
                for (int ii = 0; ii < interfaces.length; ++ii) {
                    Class<?> inter = interfaces[ii];
                    if (!inter.getName().equals("com.sagacloud.util.compute_engine.core.ICustomFunction")) continue;
                    flag = true;
                }
                if (!flag) continue;
                this.add((ICustomFunction)clazz.newInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void LoadClassByJar() {
        try {
            String dirPath = Constant.GetPath() + "/custom/";
            File dir = new File(dirPath);
            String[] files = new String[]{};
            if (!dir.exists()) {
                dirPath = Constant.GetPath() + "/../lib/custom/";
                dir = new File(dirPath);
                if (dir.exists()) {
                    files = dir.list();
                }
            } else {
                files = dir.list();
            }
            URL[] urls = new URL[files.length];
            for (int i = 0; i < files.length; ++i) {
                urls[i] = new URL("file:" + dirPath + files[i]);
            }
            URLClassLoader loader = new URLClassLoader(urls);
            for (int i = 0; i < files.length; ++i) {
                File file = new File(dirPath + files[i]);
                if (!file.isFile()) continue;
                JarFile jar = new JarFile(file);
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".class")) continue;
                    String name = entry.getName();
                    name = name.substring(0, name.length() - 6);
                    name = name.replaceAll("/", ".");
                    Class<?> clazz = loader.loadClass(name);
                    Class<?>[] interfaces = clazz.getInterfaces();
                    boolean flag = false;
                    for (int ii = 0; ii < interfaces.length; ++ii) {
                        Class<?> inter = interfaces[ii];
                        if (!inter.getName().equals("com.sagacloud.util.compute_engine.core.ICustomFunction")) continue;
                        flag = true;
                    }
                    if (!flag) continue;
                    this.add((ICustomFunction)clazz.newInstance());
                }
                jar.close();
            }
            loader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void add(ICustomFunction function) {
        this.functionMap.put(function.GetName(), function);
    }

    public ICustomFunction Get(String name) {
        return this.functionMap.get(name);
    }

    public double Compute(String custom_function_name, Map<String, String> custom_paramsMap, Map<String, Double> dataMap) throws Exception {
        HashMap<String, Double> inputMap = new HashMap<String, Double>();
        for (String custom_param : custom_paramsMap.keySet()) {
            String var_original = custom_paramsMap.get(custom_param);
            try {
                double const_value = Double.parseDouble(var_original);
                inputMap.put(custom_param, const_value);
            }
            catch (NumberFormatException e) {
                inputMap.put(custom_param, dataMap.get(var_original));
            }
        }
        ICustomFunction function = this.Get(custom_function_name);
        return function.Compute(inputMap);
    }
}

