/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class H2Tree
extends BPlusTree<SearchRow, GridH2Row> {
    private final H2RowFactory rowStore;
    private final int inlineSize;
    private final List<InlineIndexHelper> inlineIdxs;
    private final IndexColumn[] cols;
    private final int[] columnIds;
    private final Comparator<Value> comp = new Comparator<Value>(){

        @Override
        public int compare(Value o1, Value o2) {
            return H2Tree.this.compareValues(o1, o2);
        }
    };
    private final H2RowCache rowCache;

    protected H2Tree(String name, ReuseList reuseList, int grpId, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, H2RowFactory rowStore, long metaPageId, boolean initNew, IndexColumn[] cols, List<InlineIndexHelper> inlineIdxs, int inlineSize, @Nullable H2RowCache rowCache) throws IgniteCheckedException {
        super(name, grpId, pageMem, wal, globalRmvId, metaPageId, reuseList);
        if (!initNew) {
            inlineSize = this.getMetaInlineSize();
        }
        this.inlineSize = inlineSize;
        assert (rowStore != null);
        this.rowStore = rowStore;
        this.inlineIdxs = inlineIdxs;
        this.cols = cols;
        this.columnIds = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            this.columnIds[i] = cols[i].column.getColumnId();
        }
        this.rowCache = rowCache;
        this.setIos(H2ExtrasInnerIO.getVersions(inlineSize), H2ExtrasLeafIO.getVersions(inlineSize));
        this.initTree(initNew, inlineSize);
    }

    public GridH2Row createRowFromLink(long link) throws IgniteCheckedException {
        if (this.rowCache != null) {
            GridH2Row row = this.rowCache.get(link);
            if (row == null && (row = this.rowStore.getRow(link)) instanceof GridH2KeyValueRowOnheap) {
                this.rowCache.put((GridH2KeyValueRowOnheap)row);
            }
            return row;
        }
        return this.rowStore.getRow(link);
    }

    protected GridH2Row getRow(BPlusIO<SearchRow> io, long pageAddr, int idx, Object filter) throws IgniteCheckedException {
        long link;
        int part;
        IndexingQueryCacheFilter filter0;
        if (filter != null && !(filter0 = (IndexingQueryCacheFilter)filter).applyPartition(part = PageIdUtils.partId((long)PageIdUtils.pageId((long)(link = ((H2RowLinkIO)io).getLink(pageAddr, idx)))))) {
            return null;
        }
        return (GridH2Row)io.getLookupRow((BPlusTree)this, pageAddr, idx);
    }

    private int inlineSize() {
        return this.inlineSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMetaInlineSize() throws IgniteCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            int n;
            long pageAddr = this.readLock(this.metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong((long)this.metaPageId) + ']';
            try {
                BPlusMetaIO io = (BPlusMetaIO)BPlusMetaIO.VERSIONS.forPage(pageAddr);
                n = io.getInlineSize(pageAddr);
            }
            catch (Throwable throwable) {
                this.readUnlock(this.metaPageId, metaPage, pageAddr);
                throw throwable;
            }
            this.readUnlock(this.metaPageId, metaPage, pageAddr);
            return n;
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    protected int compare(BPlusIO<SearchRow> io, long pageAddr, int idx, SearchRow row) throws IgniteCheckedException {
        if (this.inlineSize() == 0) {
            return this.compareRows((SearchRow)this.getRow(io, pageAddr, idx), row);
        }
        int off = io.offset(idx);
        int fieldOff = 0;
        int lastIdxUsed = 0;
        for (int i = 0; i < this.inlineIdxs.size(); ++i) {
            InlineIndexHelper inlineIdx = this.inlineIdxs.get(i);
            Value v2 = row.getValue(inlineIdx.columnIndex());
            if (v2 == null) {
                return 0;
            }
            int c = inlineIdx.compare(pageAddr, off + fieldOff, this.inlineSize() - fieldOff, v2, this.comp);
            if (c == -2) break;
            ++lastIdxUsed;
            if (c != 0) {
                return c;
            }
            if ((fieldOff += inlineIdx.fullSize(pageAddr, off + fieldOff)) > this.inlineSize()) break;
        }
        if (lastIdxUsed == this.cols.length) {
            return 0;
        }
        SearchRow rowData = (SearchRow)this.getRow(io, pageAddr, idx);
        int len = this.cols.length;
        for (int i = lastIdxUsed; i < len; ++i) {
            IndexColumn col = this.cols[i];
            int idx0 = col.column.getColumnId();
            Value v2 = row.getValue(idx0);
            if (v2 == null) {
                return 0;
            }
            Value v1 = rowData.getValue(idx0);
            int c = this.compareValues(v1, v2);
            if (c == 0) continue;
            return InlineIndexHelper.fixSort(c, col.sortType);
        }
        return 0;
    }

    public int compareRows(SearchRow r1, SearchRow r2) {
        if (r1 == r2) {
            return 0;
        }
        int len = this.cols.length;
        for (int i = 0; i < len; ++i) {
            int idx = this.columnIds[i];
            Value v1 = r1.getValue(idx);
            Value v2 = r2.getValue(idx);
            if (v1 == null || v2 == null) {
                return 0;
            }
            int c = this.compareValues(v1, v2);
            if (c == 0) continue;
            return InlineIndexHelper.fixSort(c, this.cols[i].sortType);
        }
        return 0;
    }

    public abstract int compareValues(Value var1, Value var2);
}

