/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi;

import java.text.DateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiManagementMBean;

public class IgniteSpiMBeanAdapter
implements IgniteSpiManagementMBean {
    protected IgniteSpiAdapter spiAdapter;

    public IgniteSpiMBeanAdapter(IgniteSpiAdapter spiAdapter) {
        this.spiAdapter = spiAdapter;
    }

    @Override
    public final String getStartTimestampFormatted() {
        return DateFormat.getDateTimeInstance().format(new Date(this.spiAdapter.getStartTstamp()));
    }

    @Override
    public final String getUpTimeFormatted() {
        return X.timeSpan2HMSM(this.getUpTime());
    }

    @Override
    public final long getStartTimestamp() {
        return this.spiAdapter.getStartTstamp();
    }

    @Override
    public final long getUpTime() {
        long startTstamp = this.spiAdapter.getStartTstamp();
        return startTstamp == 0L ? 0L : U.currentTimeMillis() - startTstamp;
    }

    @Override
    public UUID getLocalNodeId() {
        return this.spiAdapter.ignite.cluster().localNode().id();
    }

    @Override
    public final String getIgniteHome() {
        return this.spiAdapter.ignite.configuration().getIgniteHome();
    }

    @Override
    public String getName() {
        return this.spiAdapter.getName();
    }
}

