/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.distributed.near.NearTxFinishFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.transactions.TransactionState;

public class GridNearTxFastFinishFuture
extends GridFutureAdapter<IgniteInternalTx>
implements NearTxFinishFuture {
    private final GridNearTxLocal tx;
    private final boolean commit;

    GridNearTxFastFinishFuture(GridNearTxLocal tx, boolean commit) {
        this.tx = tx;
        this.commit = commit;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    public void finish(boolean clearThreadMap) {
        try {
            if (this.commit) {
                this.tx.state(TransactionState.PREPARING);
                this.tx.state(TransactionState.PREPARED);
                this.tx.state(TransactionState.COMMITTING);
                this.tx.context().tm().fastFinishTx(this.tx, true, true);
                this.tx.state(TransactionState.COMMITTED);
            } else {
                this.tx.state(TransactionState.PREPARING);
                this.tx.state(TransactionState.PREPARED);
                this.tx.state(TransactionState.ROLLING_BACK);
                this.tx.context().tm().fastFinishTx(this.tx, false, clearThreadMap);
                this.tx.state(TransactionState.ROLLED_BACK);
            }
        }
        finally {
            this.onDone(this.tx);
        }
    }
}

