/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteInClosureX;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.spi.IgniteSpiException;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionDemander {
    private final GridCacheSharedContext<?, ?> ctx;
    private final CacheGroupContext grp;
    private final IgniteLogger log;
    private IgnitePredicate<GridCacheEntryInfo> preloadPred;
    @GridToStringInclude
    private final GridFutureAdapter syncFut = new GridFutureAdapter();
    @GridToStringInclude
    private volatile RebalanceFuture rebalanceFut;
    private AtomicReference<GridTimeoutObject> lastTimeoutObj = new AtomicReference();
    private volatile GridDhtPartitionsExchangeFuture lastExchangeFut;
    private final Map<Integer, Object> rebalanceTopics;

    public GridDhtPartitionDemander(CacheGroupContext grp) {
        assert (grp != null);
        this.grp = grp;
        this.ctx = grp.shared();
        this.log = this.ctx.logger(this.getClass());
        boolean enabled = grp.rebalanceEnabled() && !this.ctx.kernalContext().clientNode();
        this.rebalanceFut = new RebalanceFuture();
        if (!enabled) {
            this.rebalanceFut.onDone(true);
            this.syncFut.onDone();
        }
        HashMap<Integer, Object> tops = new HashMap<Integer, Object>();
        for (int idx = 0; idx < grp.shared().kernalContext().config().getRebalanceThreadPoolSize(); ++idx) {
            tops.put(idx, GridCachePartitionExchangeManager.rebalanceTopic(idx));
        }
        this.rebalanceTopics = tops;
    }

    void start() {
    }

    void stop() {
        try {
            this.rebalanceFut.cancel();
        }
        catch (Exception ignored) {
            this.rebalanceFut.onDone(false);
        }
        this.lastExchangeFut = null;
        this.lastTimeoutObj.set(null);
        this.syncFut.onDone();
    }

    IgniteInternalFuture<?> syncFuture() {
        return this.syncFut;
    }

    IgniteInternalFuture<Boolean> rebalanceFuture() {
        return this.rebalanceFut;
    }

    void preloadPredicate(IgnitePredicate<GridCacheEntryInfo> preloadPred) {
        this.preloadPred = preloadPred;
    }

    IgniteInternalFuture<Boolean> forceRebalance() {
        GridDhtPartitionsExchangeFuture exchFut;
        GridTimeoutObject obj = this.lastTimeoutObj.getAndSet(null);
        if (obj != null) {
            this.ctx.time().removeTimeoutObject(obj);
        }
        if ((exchFut = this.lastExchangeFut) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Forcing rebalance event for future: " + exchFut);
            }
            final GridFutureAdapter<Boolean> fut = new GridFutureAdapter<Boolean>();
            exchFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> t) {
                    IgniteInternalFuture<Boolean> fut0 = GridDhtPartitionDemander.this.ctx.exchange().forceRebalance(exchFut.exchangeId());
                    fut0.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                        @Override
                        public void apply(IgniteInternalFuture<Boolean> future) {
                            try {
                                fut.onDone(future.get());
                            }
                            catch (Exception e) {
                                fut.onDone(e);
                            }
                        }
                    });
                }
            });
            return fut;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring force rebalance request (no topology event happened yet).");
        }
        return new GridFinishedFuture<Boolean>(true);
    }

    private boolean topologyChanged(RebalanceFuture fut) {
        return !this.grp.affinity().lastVersion().equals(fut.topologyVersion()) || fut != this.rebalanceFut;
    }

    void onTopologyChanged(GridDhtPartitionsExchangeFuture lastFut) {
        this.lastExchangeFut = lastFut;
    }

    Runnable addAssignments(final GridDhtPreloaderAssignments assignments, boolean force, long rebalanceId, Runnable next, @Nullable GridCompoundFuture<Boolean, Boolean> forcedRebFut) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding partition assignments: " + assignments);
        }
        assert (force == (forcedRebFut != null));
        long delay = this.grp.config().getRebalanceDelay();
        if ((delay == 0L || force) && assignments != null) {
            RebalanceFuture oldFut = this.rebalanceFut;
            RebalanceFuture fut = new RebalanceFuture(this.grp, assignments, this.log, rebalanceId);
            if (!this.grp.localWalEnabled()) {
                fut.listen(new IgniteInClosureX<IgniteInternalFuture<Boolean>>(){

                    @Override
                    public void applyx(IgniteInternalFuture<Boolean> future) throws IgniteCheckedException {
                        if (future.get().booleanValue()) {
                            GridDhtPartitionDemander.this.ctx.walState().onGroupRebalanceFinished(GridDhtPartitionDemander.this.grp.groupId(), assignments.topologyVersion());
                        }
                    }
                });
            }
            if (!oldFut.isInitial()) {
                oldFut.cancel();
            } else {
                fut.listen(f -> oldFut.onDone(f.result()));
            }
            if (forcedRebFut != null) {
                forcedRebFut.add(fut);
            }
            this.rebalanceFut = fut;
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.clearRebalanceCounters();
                metrics.startRebalance(0L);
                this.rebalanceFut.listen(f -> metrics.clearRebalanceCounters());
            }
            fut.sendRebalanceStartedEvent();
            if (assignments.cancelled()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing skipped due to cancelled assignments.");
                }
                fut.onDone(false);
                fut.sendRebalanceFinishedEvent();
                return null;
            }
            if (assignments.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing skipped due to empty assignments.");
                }
                fut.onDone(true);
                ((GridFutureAdapter)this.grp.preloader().syncFuture()).onDone();
                fut.sendRebalanceFinishedEvent();
                return null;
            }
            return () -> {
                if (next != null) {
                    fut.listen(f -> {
                        block3: {
                            try {
                                if (((Boolean)f.get()).booleanValue()) {
                                    next.run();
                                }
                            }
                            catch (IgniteCheckedException e) {
                                if (!this.log.isDebugEnabled()) break block3;
                                this.log.debug(e.getMessage());
                            }
                        }
                    });
                }
                this.requestPartitions(fut, assignments);
            };
        }
        if (delay > 0L) {
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.startRebalance(delay);
            }
            GridTimeoutObject obj = this.lastTimeoutObj.get();
            if (obj != null) {
                this.ctx.time().removeTimeoutObject(obj);
            }
            final GridDhtPartitionsExchangeFuture exchFut = this.lastExchangeFut;
            assert (exchFut != null) : "Delaying rebalance process without topology event.";
            obj = new GridTimeoutObjectAdapter(delay){

                @Override
                public void onTimeout() {
                    exchFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                        @Override
                        public void apply(IgniteInternalFuture<AffinityTopologyVersion> f) {
                            GridDhtPartitionDemander.this.ctx.exchange().forceRebalance(exchFut.exchangeId());
                        }
                    });
                }
            };
            this.lastTimeoutObj.set(obj);
            this.ctx.time().addTimeoutObject(obj);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestPartitions(RebalanceFuture fut, GridDhtPreloaderAssignments assignments) {
        assert (fut != null);
        if (this.topologyChanged(fut)) {
            fut.cancel();
            return;
        }
        if (!this.ctx.kernalContext().grid().isRebalanceEnabled()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cancel partition demand because rebalance disabled on current node.");
            }
            fut.cancel();
            return;
        }
        RebalanceFuture rebalanceFuture = fut;
        synchronized (rebalanceFuture) {
            if (fut.isDone()) {
                return;
            }
            for (Map.Entry e : assignments.entrySet()) {
                UUID nodeId = ((ClusterNode)e.getKey()).id();
                IgniteDhtDemandedPartitionsMap parts = ((GridDhtPartitionDemandMessage)e.getValue()).partitions();
                assert (parts != null) : "Partitions are null [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + "]";
                fut.remaining.put(nodeId, new T2<Long, IgniteDhtDemandedPartitionsMap>(U.currentTimeMillis(), parts));
            }
        }
        CacheConfiguration cfg = this.grp.config();
        for (Map.Entry e : assignments.entrySet()) {
            int totalStripes;
            IgniteDhtDemandedPartitionsMap parts;
            ClusterNode node = (ClusterNode)e.getKey();
            GridDhtPartitionDemandMessage d = (GridDhtPartitionDemandMessage)e.getValue();
            RebalanceFuture rebalanceFuture2 = fut;
            synchronized (rebalanceFuture2) {
                if (fut.isDone()) {
                    break;
                }
                parts = (IgniteDhtDemandedPartitionsMap)((T2)fut.remaining.get(node.id())).get2();
                U.log(this.log, "Starting rebalancing [grp=" + this.grp.cacheOrGroupName() + ", mode=" + (Object)((Object)cfg.getRebalanceMode()) + ", fromNode=" + node.id() + ", partitionsCount=" + parts.size() + ", topology=" + fut.topologyVersion() + ", rebalanceId=" + fut.rebalanceId + "]");
            }
            int stripes = totalStripes = this.ctx.gridConfig().getRebalanceThreadPoolSize();
            ArrayList<IgniteDhtDemandedPartitionsMap> stripePartitions = new ArrayList<IgniteDhtDemandedPartitionsMap>(stripes);
            for (int i = 0; i < stripes; ++i) {
                stripePartitions.add(new IgniteDhtDemandedPartitionsMap());
            }
            if (parts.hasHistorical()) {
                stripePartitions.set(stripes - 1, new IgniteDhtDemandedPartitionsMap(parts.historicalMap(), null));
                if (stripes > 1) {
                    --stripes;
                }
            }
            Iterator<Integer> it = parts.fullSet().iterator();
            int i = 0;
            while (it.hasNext()) {
                ((IgniteDhtDemandedPartitionsMap)stripePartitions.get(i % stripes)).addFull(it.next());
                ++i;
            }
            for (int stripe = 0; stripe < totalStripes; ++stripe) {
                if (((IgniteDhtDemandedPartitionsMap)stripePartitions.get(stripe)).isEmpty()) continue;
                GridDhtPartitionDemandMessage demandMsg = d.withNewPartitionsMap((IgniteDhtDemandedPartitionsMap)stripePartitions.get(stripe));
                demandMsg.topic(this.rebalanceTopics.get(stripe));
                demandMsg.rebalanceId(fut.rebalanceId);
                demandMsg.timeout(cfg.getRebalanceTimeout());
                int topicId = stripe;
                IgniteInternalFuture<?> clearAllFuture = this.clearFullPartitions(fut, demandMsg.partitions().fullSet());
                clearAllFuture.listen(f -> this.ctx.kernalContext().closure().runLocalSafe(() -> {
                    if (fut.isDone()) {
                        return;
                    }
                    try {
                        this.ctx.io().sendOrderedMessage(node, this.rebalanceTopics.get(topicId), demandMsg.convertIfNeeded(node.version()), this.grp.ioPolicy(), demandMsg.timeout());
                        RebalanceFuture rebalanceFuture = fut;
                        synchronized (rebalanceFuture) {
                            if (fut.isDone()) {
                                fut.cleanupRemoteContexts(node.id());
                            }
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Requested rebalancing [from node=" + node.id() + ", listener index=" + topicId + " " + demandMsg.rebalanceId() + ", partitions count=" + ((IgniteDhtDemandedPartitionsMap)stripePartitions.get(topicId)).size() + " (" + ((IgniteDhtDemandedPartitionsMap)stripePartitions.get(topicId)).partitionsList() + ")]");
                        }
                    }
                    catch (IgniteCheckedException e1) {
                        ClusterTopologyCheckedException cause = e1.getCause(ClusterTopologyCheckedException.class);
                        if (cause != null) {
                            this.log.warning("Failed to send initial demand request to node. " + e1.getMessage());
                        } else {
                            this.log.error("Failed to send initial demand request to node.", e1);
                        }
                        fut.cancel();
                    }
                    catch (Throwable th) {
                        this.log.error("Runtime error caught during initial demand request sending.", th);
                        fut.cancel();
                    }
                }, true));
            }
        }
    }

    private IgniteInternalFuture<?> clearFullPartitions(RebalanceFuture fut, Set<Integer> fullPartitions) {
        GridFutureAdapter clearAllFuture = new GridFutureAdapter();
        if (fullPartitions.isEmpty()) {
            clearAllFuture.onDone();
            return clearAllFuture;
        }
        for (GridCacheContext cctx : this.grp.caches()) {
            if (!cctx.statisticsEnabled()) continue;
            CacheMetricsImpl metrics = cctx.cache().metrics0();
            metrics.rebalanceClearingPartitions(fullPartitions.size());
        }
        AtomicInteger clearingPartitions = new AtomicInteger(fullPartitions.size());
        for (int partId : fullPartitions) {
            if (fut.isDone()) {
                clearAllFuture.onDone();
                return clearAllFuture;
            }
            GridDhtLocalPartition part = this.grp.topology().localPartition(partId);
            if (part != null && part.state() == GridDhtPartitionState.MOVING) {
                part.onClearFinished(f -> {
                    if (!fut.isDone()) {
                        if (f.error() != null) {
                            for (GridCacheContext cctx : this.grp.caches()) {
                                if (!cctx.statisticsEnabled()) continue;
                                CacheMetricsImpl metrics = cctx.cache().metrics0();
                                metrics.rebalanceClearingPartitions(0);
                            }
                            this.log.error("Unable to await partition clearing " + part, f.error());
                            fut.cancel();
                            clearAllFuture.onDone(f.error());
                        } else {
                            int remaining = clearingPartitions.decrementAndGet();
                            for (GridCacheContext cctx : this.grp.caches()) {
                                if (!cctx.statisticsEnabled()) continue;
                                CacheMetricsImpl metrics = cctx.cache().metrics0();
                                metrics.rebalanceClearingPartitions(remaining);
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Remaining clearing partitions [grp=" + this.grp.cacheOrGroupName() + ", remaining=" + remaining + "]");
                            }
                            if (remaining == 0) {
                                clearAllFuture.onDone();
                            }
                        }
                    } else {
                        clearAllFuture.onDone();
                    }
                });
                continue;
            }
            int remaining = clearingPartitions.decrementAndGet();
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.rebalanceClearingPartitions(remaining);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Remaining clearing partitions [grp=" + this.grp.cacheOrGroupName() + ", remaining=" + remaining + "]");
            }
            if (remaining != 0) continue;
            clearAllFuture.onDone();
        }
        return clearAllFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void handleSupplyMessage(int topicId, UUID nodeId, GridDhtPartitionSupplyMessage supply) {
        AffinityTopologyVersion topVer = supply.topologyVersion();
        RebalanceFuture fut = this.rebalanceFut;
        ClusterNode node = this.ctx.node(nodeId);
        if (node == null) {
            return;
        }
        if (this.topologyChanged(fut)) {
            return;
        }
        if (!fut.isActual(supply.rebalanceId())) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received supply message [grp=" + this.grp.cacheOrGroupName() + ", msg=" + supply + ']');
        }
        if (supply.classError() != null) {
            U.warn(this.log, "Rebalancing from node cancelled [grp=" + this.grp.cacheOrGroupName() + ", node=" + nodeId + "]. Class got undeployed during preloading: " + supply.classError());
            fut.cancel(nodeId);
            return;
        }
        GridDhtPartitionTopology top = this.grp.topology();
        if (this.grp.sharedGroup()) {
            for (GridCacheContext gridCacheContext : this.grp.caches()) {
                if (!gridCacheContext.statisticsEnabled()) continue;
                long keysCnt = supply.keysForCache(gridCacheContext.cacheId());
                if (keysCnt != -1L) {
                    gridCacheContext.cache().metrics0().onRebalancingKeysCountEstimateReceived(keysCnt);
                }
                gridCacheContext.cache().metrics0().onRebalanceBatchReceived(supply.messageSize());
            }
        } else {
            GridCacheContext cctx = this.grp.singleCacheContext();
            if (cctx.statisticsEnabled()) {
                if (supply.estimatedKeysCount() != -1L) {
                    cctx.cache().metrics0().onRebalancingKeysCountEstimateReceived(supply.estimatedKeysCount());
                }
                cctx.cache().metrics0().onRebalanceBatchReceived(supply.messageSize());
            }
        }
        try {
            AffinityAssignment aff = this.grp.affinity().cachedAffinity(topVer);
            GridCacheContext gridCacheContext = this.grp.sharedGroup() ? null : this.grp.singleCacheContext();
            this.ctx.database().checkpointReadLock();
            try {
                for (Map.Entry<Integer, CacheEntryInfoCollection> e : supply.infos().entrySet()) {
                    int p = e.getKey();
                    if (aff.get(p).contains(this.ctx.localNode())) {
                        GridDhtLocalPartition part = top.localPartition(p, topVer, true);
                        assert (part != null);
                        boolean last = supply.last().containsKey(p);
                        if (part.state() == GridDhtPartitionState.MOVING) {
                            boolean reserved = part.reserve();
                            assert (reserved) : "Failed to reserve partition [igniteInstanceName=" + this.ctx.igniteInstanceName() + ", grp=" + this.grp.cacheOrGroupName() + ", part=" + part + ']';
                            part.lock();
                            try {
                                for (GridCacheEntryInfo entry : e.getValue().infos()) {
                                    void var9_12;
                                    if (!this.preloadEntry(node, p, entry, topVer)) {
                                        if (!this.log.isDebugEnabled()) break;
                                        this.log.debug("Got entries for invalid partition during preloading (will skip) [p=" + p + ", entry=" + entry + ']');
                                        break;
                                    }
                                    if (this.grp.sharedGroup() && (var9_12 == null || var9_12.cacheId() != entry.cacheId())) {
                                        GridCacheContext<?, ?> gridCacheContext2 = this.ctx.cacheContext(entry.cacheId());
                                    }
                                    if (var9_12 == null || !var9_12.statisticsEnabled()) continue;
                                    var9_12.cache().metrics0().onRebalanceKeyReceived();
                                }
                                if (!last) continue;
                                fut.partitionDone(nodeId, p, true);
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Finished rebalancing partition: " + part);
                                continue;
                            }
                            finally {
                                part.unlock();
                                part.release();
                                continue;
                            }
                        }
                        if (last) {
                            fut.partitionDone(nodeId, p, false);
                        }
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Skipping rebalancing partition (state is not MOVING): " + part);
                        continue;
                    }
                    fut.partitionDone(nodeId, p, false);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Skipping rebalancing partition (it does not belong on current node): " + p);
                }
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
            for (Integer miss : supply.missed()) {
                if (!aff.get(miss).contains(this.ctx.localNode())) continue;
                fut.partitionMissed(nodeId, miss);
            }
            for (Integer miss : supply.missed()) {
                fut.partitionDone(nodeId, miss, false);
            }
            GridDhtPartitionDemandMessage d = new GridDhtPartitionDemandMessage(supply.rebalanceId(), supply.topologyVersion(), this.grp.groupId());
            d.timeout(this.grp.config().getRebalanceTimeout());
            d.topic(this.rebalanceTopics.get(topicId));
            if (!this.topologyChanged(fut) && !fut.isDone()) {
                try {
                    this.ctx.io().sendOrderedMessage(node, this.rebalanceTopics.get(topicId), d.convertIfNeeded(node.version()), this.grp.ioPolicy(), this.grp.config().getRebalanceTimeout());
                }
                catch (ClusterTopologyCheckedException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Node left during rebalancing [grp=" + this.grp.cacheOrGroupName() + ", node=" + node.id() + ", msg=" + e.getMessage() + ']');
                    }
                }
            }
        }
        catch (IgniteCheckedException | IgniteSpiException e) {
            LT.error(this.log, e, "Error during rebalancing [grp=" + this.grp.cacheOrGroupName() + ", srcNode=" + node.id() + ", err=" + e + ']');
        }
    }

    private boolean preloadEntry(ClusterNode from, int p, GridCacheEntryInfo entry, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        try {
            GridCacheEntryEx cached = null;
            try {
                GridCacheContext<?, ?> cctx = this.grp.sharedGroup() ? this.ctx.cacheContext(entry.cacheId()) : this.grp.singleCacheContext();
                cached = cctx.dhtCache().entryEx(entry.key());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing key [key=" + entry.key() + ", part=" + p + ", node=" + from.id() + ']');
                }
                if (this.preloadPred == null || this.preloadPred.apply(entry)) {
                    if (cached.initialValue(entry.value(), entry.version(), entry.ttl(), entry.expireTime(), true, topVer, cctx.isDrEnabled() ? GridDrType.DR_PRELOAD : GridDrType.DR_NONE, false)) {
                        cctx.evicts().touch(cached, topVer);
                        if (cctx.events().isRecordable(84) && !cached.isInternal()) {
                            cctx.events().addEvent(cached.partition(), cached.key(), cctx.localNodeId(), (IgniteUuid)null, null, 84, entry.value(), true, null, false, null, null, null, true);
                        }
                    } else {
                        cctx.evicts().touch(cached, topVer);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Rebalancing entry is already in cache (will ignore) [key=" + cached.key() + ", part=" + p + ']');
                        }
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalance predicate evaluated to false for entry (will ignore): " + entry);
                }
            }
            catch (GridCacheEntryRemovedException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Entry has been concurrently removed while rebalancing (will ignore) [key=" + cached.key() + ", part=" + p + ']');
                }
            }
            catch (GridDhtInvalidPartitionException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition became invalid during rebalancing (will ignore): " + p);
                }
                return false;
            }
        }
        catch (IgniteInterruptedCheckedException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to cache rebalanced entry (will stop rebalancing) [local=" + this.ctx.localNode() + ", node=" + from.id() + ", key=" + entry.key() + ", part=" + p + ']', e);
        }
        return true;
    }

    public String toString() {
        return S.toString(GridDhtPartitionDemander.class, this);
    }

    public static class RebalanceFuture
    extends GridFutureAdapter<Boolean> {
        private final GridCacheSharedContext<?, ?> ctx;
        private final CacheGroupContext grp;
        private final IgniteLogger log;
        private final Map<UUID, T2<Long, IgniteDhtDemandedPartitionsMap>> remaining = new HashMap<UUID, T2<Long, IgniteDhtDemandedPartitionsMap>>();
        private final Map<UUID, Collection<Integer>> missed = new HashMap<UUID, Collection<Integer>>();
        @GridToStringExclude
        private final GridDhtPartitionExchangeId exchId;
        private final AffinityTopologyVersion topVer;
        private final long rebalanceId;

        RebalanceFuture(CacheGroupContext grp, GridDhtPreloaderAssignments assignments, IgniteLogger log, long rebalanceId) {
            assert (assignments != null);
            this.exchId = assignments.exchangeId();
            this.topVer = assignments.topologyVersion();
            this.grp = grp;
            this.log = log;
            this.rebalanceId = rebalanceId;
            this.ctx = grp.shared();
        }

        RebalanceFuture() {
            this.exchId = null;
            this.topVer = null;
            this.ctx = null;
            this.grp = null;
            this.log = null;
            this.rebalanceId = -1L;
        }

        public AffinityTopologyVersion topologyVersion() {
            return this.topVer;
        }

        private boolean isActual(long rebalanceId) {
            return this.rebalanceId == rebalanceId;
        }

        private boolean isInitial() {
            return this.topVer == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            RebalanceFuture rebalanceFuture = this;
            synchronized (rebalanceFuture) {
                if (this.isDone()) {
                    return true;
                }
                U.log(this.log, "Cancelled rebalancing from all nodes [topology=" + this.topologyVersion() + ']');
                if (!this.ctx.kernalContext().isStopping()) {
                    for (UUID nodeId : this.remaining.keySet()) {
                        this.cleanupRemoteContexts(nodeId);
                    }
                }
                this.remaining.clear();
                this.checkIsDone(true);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel(UUID nodeId) {
            RebalanceFuture rebalanceFuture = this;
            synchronized (rebalanceFuture) {
                if (this.isDone()) {
                    return;
                }
                U.log(this.log, "Cancelled rebalancing [cache=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", topology=" + this.topologyVersion() + ", time=" + (U.currentTimeMillis() - (Long)this.remaining.get(nodeId).get1()) + " ms]");
                this.cleanupRemoteContexts(nodeId);
                this.remaining.remove(nodeId);
                this.onDone(false);
                this.checkIsDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void partitionMissed(UUID nodeId, int p) {
            RebalanceFuture rebalanceFuture = this;
            synchronized (rebalanceFuture) {
                if (this.isDone()) {
                    return;
                }
                this.missed.computeIfAbsent(nodeId, k -> new HashSet());
                this.missed.get(nodeId).add(p);
            }
        }

        private void cleanupRemoteContexts(UUID nodeId) {
            block4: {
                ClusterNode node = this.ctx.discovery().node(nodeId);
                if (node == null) {
                    return;
                }
                GridDhtPartitionDemandMessage d = new GridDhtPartitionDemandMessage(-this.rebalanceId, this.topologyVersion(), this.grp.groupId());
                d.timeout(this.grp.config().getRebalanceTimeout());
                try {
                    for (int idx = 0; idx < this.ctx.gridConfig().getRebalanceThreadPoolSize(); ++idx) {
                        d.topic(GridCachePartitionExchangeManager.rebalanceTopic(idx));
                        this.ctx.io().sendOrderedMessage(node, GridCachePartitionExchangeManager.rebalanceTopic(idx), d.convertIfNeeded(node.version()), this.grp.ioPolicy(), this.grp.config().getRebalanceTimeout());
                    }
                }
                catch (IgniteCheckedException ignored) {
                    if (!this.log.isDebugEnabled()) break block4;
                    this.log.debug("Failed to send failover context cleanup request to node");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void partitionDone(UUID nodeId, int p, boolean updateState) {
            RebalanceFuture rebalanceFuture = this;
            synchronized (rebalanceFuture) {
                if (updateState && this.grp.localWalEnabled()) {
                    this.grp.topology().own(this.grp.topology().localPartition(p));
                }
                if (this.isDone()) {
                    return;
                }
                if (this.grp.eventRecordable(82)) {
                    this.rebalanceEvent(p, 82, this.exchId.discoveryEvent());
                }
                T2<Long, IgniteDhtDemandedPartitionsMap> t = this.remaining.get(nodeId);
                assert (t != null) : "Remaining not found [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + "]";
                IgniteDhtDemandedPartitionsMap parts = (IgniteDhtDemandedPartitionsMap)t.get2();
                boolean rmvd = parts.remove(p);
                assert (rmvd) : "Partition already done [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + ", left=" + parts + "]";
                if (parts.isEmpty()) {
                    U.log(this.log, "Completed " + (this.remaining.size() == 1 ? "(final) " : "") + "rebalancing [fromNode=" + nodeId + ", cacheOrGroup=" + this.grp.cacheOrGroupName() + ", topology=" + this.topologyVersion() + ", time=" + (U.currentTimeMillis() - (Long)t.get1()) + " ms]");
                    this.remaining.remove(nodeId);
                }
                this.checkIsDone();
            }
        }

        private void rebalanceEvent(int part, int type, DiscoveryEvent discoEvt) {
            assert (discoEvt != null);
            this.grp.addRebalanceEvent(part, type, discoEvt.eventNode(), discoEvt.type(), discoEvt.timestamp());
        }

        private void rebalanceEvent(int type, DiscoveryEvent discoEvt) {
            this.rebalanceEvent(-1, type, discoEvt);
        }

        private void checkIsDone() {
            this.checkIsDone(false);
        }

        private void checkIsDone(boolean cancelled) {
            if (this.remaining.isEmpty()) {
                this.sendRebalanceFinishedEvent();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Completed rebalance future: " + this);
                }
                this.ctx.exchange().scheduleResendPartitions();
                HashSet<Integer> m = new HashSet<Integer>();
                for (Map.Entry<UUID, Collection<Integer>> e : this.missed.entrySet()) {
                    if (e.getValue() == null || e.getValue().isEmpty()) continue;
                    m.addAll(e.getValue());
                }
                if (!m.isEmpty()) {
                    U.log(this.log, "Reassigning partitions that were missed: " + m);
                    this.onDone(false);
                    this.ctx.exchange().forceReassign(this.exchId);
                    return;
                }
                if (!cancelled && !this.grp.preloader().syncFuture().isDone()) {
                    ((GridFutureAdapter)this.grp.preloader().syncFuture()).onDone();
                }
                this.onDone(!cancelled);
            }
        }

        private void sendRebalanceStartedEvent() {
            if (this.grp.eventRecordable(80)) {
                this.rebalanceEvent(80, this.exchId.discoveryEvent());
            }
        }

        private void sendRebalanceFinishedEvent() {
            if (this.grp.eventRecordable(81)) {
                this.rebalanceEvent(81, this.exchId.discoveryEvent());
            }
        }

        @Override
        public String toString() {
            return S.toString(RebalanceFuture.class, this);
        }
    }
}

