/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.discovery;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public abstract class DiscoveryMessageResultsCollector<M, R> {
    private final Map<UUID, NodeMessage<M>> rcvd = new HashMap<UUID, NodeMessage<M>>();
    private int leftMsgs;
    protected DiscoCache discoCache;
    protected final GridKernalContext ctx;

    protected DiscoveryMessageResultsCollector(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    protected abstract R createResult(Map<UUID, NodeMessage<M>> var1);

    protected abstract void onResultsCollected(R var1);

    protected abstract boolean waitForNode(DiscoCache var1, ClusterNode var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(DiscoCache discoCache) {
        assert (discoCache != null);
        R res = null;
        DiscoveryMessageResultsCollector discoveryMessageResultsCollector = this;
        synchronized (discoveryMessageResultsCollector) {
            assert (this.discoCache == null);
            assert (this.leftMsgs == 0) : this.leftMsgs;
            this.discoCache = discoCache;
            for (ClusterNode node : discoCache.allNodes()) {
                if (!this.ctx.discovery().alive(node) || !this.waitForNode(discoCache, node) || this.rcvd.containsKey(node.id())) continue;
                this.rcvd.put(node.id(), new NodeMessage<Object>(null));
                ++this.leftMsgs;
            }
            if (this.leftMsgs == 0) {
                res = this.createResult(this.rcvd);
            }
        }
        if (res != null) {
            this.onResultsCollected(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onMessage(UUID nodeId, M msg) {
        R res = null;
        DiscoveryMessageResultsCollector discoveryMessageResultsCollector = this;
        synchronized (discoveryMessageResultsCollector) {
            if (this.allReceived()) {
                return;
            }
            NodeMessage<M> expMsg = this.rcvd.get(nodeId);
            if (expMsg == null) {
                this.rcvd.put(nodeId, new NodeMessage<M>(msg));
            } else if (expMsg.set(msg)) {
                assert (this.leftMsgs > 0);
                --this.leftMsgs;
                if (this.allReceived()) {
                    res = this.createResult(this.rcvd);
                }
            }
        }
        if (res != null) {
            this.onResultsCollected(res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNodeFail(UUID nodeId) {
        R res = null;
        DiscoveryMessageResultsCollector discoveryMessageResultsCollector = this;
        synchronized (discoveryMessageResultsCollector) {
            if (this.allReceived()) {
                return;
            }
            NodeMessage<M> expMsg = this.rcvd.get(nodeId);
            if (expMsg != null && expMsg.onNodeFailed()) {
                assert (this.leftMsgs > 0) : this.leftMsgs;
                --this.leftMsgs;
                if (this.allReceived()) {
                    res = this.createResult(this.rcvd);
                }
            }
        }
        if (res != null) {
            this.onResultsCollected(res);
        }
    }

    private boolean allReceived() {
        return this.discoCache != null && this.leftMsgs == 0;
    }

    public String toString() {
        return S.toString(DiscoveryMessageResultsCollector.class, this);
    }

    protected static class NodeMessage<M> {
        boolean nodeFailed;
        M msg;

        NodeMessage(M msg) {
            this.msg = msg;
        }

        @Nullable
        public M message() {
            return this.msg;
        }

        boolean onNodeFailed() {
            if (this.nodeFailed || this.msg != null) {
                return false;
            }
            this.nodeFailed = true;
            return true;
        }

        boolean set(M msg) {
            assert (msg != null);
            if (this.msg != null) {
                return false;
            }
            this.msg = msg;
            return !this.nodeFailed;
        }

        public String toString() {
            return S.toString(NodeMessage.class, this);
        }
    }
}

