/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.json;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.zillion.util.common.MyException;

public class FastJsonUtil {
    public static Set<Object> ValueArray2ValueSet(JSONArray valueArray) {
        HashSet<Object> valueSet = new HashSet<Object>();
        int index_va = 0;
        while (index_va < valueArray.size()) {
            Object valueItem = valueArray.get(index_va);
            valueSet.add(valueItem);
            ++index_va;
        }
        return valueSet;
    }

    public static JSONArray ValueSet2ValueArray(Set<Object> valueSet) {
        JSONArray valueArray = new JSONArray();
        for (Object valueItem : valueSet) {
            valueArray.add(valueItem);
        }
        return valueArray;
    }

    public static Set<Object> ValueSet_or(List<Set<Object>> valueSetList) {
        HashSet<Object> result = new HashSet<Object>();
        int i = 0;
        while (i < valueSetList.size()) {
            Set<Object> valueSet = valueSetList.get(i);
            result.addAll(valueSet);
            ++i;
        }
        return result;
    }

    public static Set<Object> ValueSet_and(List<Set<Object>> valueSetList) {
        HashSet<Object> result = new HashSet<Object>();
        Set<Object> first = valueSetList.get(0);
        for (Object valueItem : first) {
            boolean all_in = true;
            int i = 1;
            while (i < valueSetList.size()) {
                Set<Object> valueSet = valueSetList.get(i);
                if (!valueSet.contains(valueItem)) {
                    all_in = false;
                    break;
                }
                ++i;
            }
            if (!all_in) continue;
            result.add(valueItem);
        }
        return result;
    }

    public static Set<Object> ValueSet_sub(Set<Object> valueSet1, Set<Object> valueSet2) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object valueItem : valueSet1) {
            if (valueSet2.contains(valueItem)) continue;
            result.add(valueItem);
        }
        return result;
    }

    public static String toFormatString(Object value) {
        return FastJsonUtil.toStringInner(value, true);
    }

    public static String toString(Object value) {
        return FastJsonUtil.toStringInner(value, false);
    }

    private static String toStringInner(Object value, boolean has_enter) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            StringBuffer sb = new StringBuffer();
            FastJsonUtil.escape((String)value, sb);
            return "\"" + sb.toString() + "\"";
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            JSONObject valueJSON = (JSONObject)value;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            Iterator iter = valueJSON.keySet().iterator();
            sb.append('{');
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (has_enter) {
                    sb.append("\r\n\t");
                }
                sb.append('\"');
                FastJsonUtil.escape(key, sb);
                sb.append('\"').append(':');
                String valueString = FastJsonUtil.toStringInner(valueJSON.get((Object)key), has_enter);
                sb.append(valueString.replaceAll("\r\n", "\r\n\t"));
            }
            if (has_enter) {
                sb.append("\r\n");
            }
            sb.append('}');
            return sb.toString();
        }
        if (value instanceof JSONArray) {
            JSONArray valueJSON = (JSONArray)value;
            boolean first = true;
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            int i = 0;
            while (i < valueJSON.size()) {
                Object valueInner;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (has_enter) {
                    sb.append("\r\n\t");
                }
                if ((valueInner = valueJSON.get(i)) == null) {
                    sb.append("null");
                } else {
                    String valueString = FastJsonUtil.toStringInner(valueInner, has_enter);
                    sb.append(valueString.replaceAll("\r\n", "\r\n\t"));
                }
                ++i;
            }
            if (has_enter) {
                sb.append("\r\n");
            }
            sb.append(']');
            return sb.toString();
        }
        return value.toString();
    }

    public static void escape(String s, StringBuffer sb) {
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        int k = 0;
                        while (k < 4 - ss.length()) {
                            sb.append('0');
                            ++k;
                        }
                        sb.append(ss.toUpperCase());
                        break;
                    }
                    sb.append(ch);
                }
            }
            ++i;
        }
    }

    public static Long getLong(JSONObject json, String name) throws Exception {
        if (json.containsKey((Object)name)) {
            Object item = json.get((Object)name);
            if (item instanceof Integer) {
                return ((Integer)item).longValue();
            }
            if (item instanceof Long) {
                return (long)((Long)item);
            }
            if (item instanceof BigInteger) {
                return ((BigInteger)item).longValue();
            }
            throw new MyException("FastJsonUtil: JSON property " + name + " cant Cast to Long:" + FastJsonUtil.toFormatString(json));
        }
        return null;
    }

    public static Long getDouble(JSONObject json, String name) throws Exception {
        if (json.containsKey((Object)name)) {
            Object item = json.get((Object)name);
            if (item instanceof Integer) {
                return ((Integer)item).longValue();
            }
            if (item instanceof Long) {
                return (long)((Long)item);
            }
            if (item instanceof BigInteger) {
                return ((BigInteger)item).longValue();
            }
            if (item instanceof Float) {
                return ((Float)item).longValue();
            }
            if (item instanceof Double) {
                return ((Double)item).longValue();
            }
            if (item instanceof BigDecimal) {
                return ((BigDecimal)item).longValue();
            }
            throw new MyException("FastJsonUtil: JSON property " + name + " cant Cast to Double:" + FastJsonUtil.toFormatString(json));
        }
        return null;
    }

    public static void Set_JSON(Object entity, JSONObject json) throws Exception {
        Class<?> targetClass = entity.getClass();
        Method[] targetMethodArray = targetClass.getMethods();
        int i = 0;
        while (i < targetMethodArray.length) {
            Class<?>[] parameterTypes;
            Method method = targetMethodArray[i];
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            if (modifiers == 1 && methodName.startsWith("get") && (parameterTypes = method.getParameterTypes()).length == 0) {
                Object value;
                String fieldName = methodName.substring(3);
                if (json.containsKey((Object)(fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1)))) {
                    json.remove((Object)fieldName);
                }
                if ((value = method.invoke(entity, new Object[0])) != null) {
                    String valueClassName = value.getClass().getName();
                    Object put_value = null;
                    if (valueClassName.equals("java.lang.String")) {
                        put_value = value;
                    } else if (valueClassName.equals("java.util.Date")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                        put_value = sdf.format((Date)value);
                    } else {
                        put_value = valueClassName.equals("java.lang.Long") || valueClassName.equals("long") ? value : (valueClassName.equals("java.lang.Double") || valueClassName.equals("double") ? value : (valueClassName.equals("java.lang.Boolean") || valueClassName.equals("boolean") ? value : FastJsonUtil.To_JSON(value)));
                    }
                    json.put(fieldName, put_value);
                }
            }
            ++i;
        }
    }

    public static void Set_JavaObject(JSONObject json, Object entity) throws Exception {
        Class<?> targetClass = entity.getClass();
        if (json == null) {
            return;
        }
        Method[] targetMethodArray = targetClass.getMethods();
        int i = 0;
        while (i < targetMethodArray.length) {
            Class<?>[] parameterTypes;
            Method method = targetMethodArray[i];
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            if (modifiers == 1 && methodName.startsWith("set") && (parameterTypes = method.getParameterTypes()).length == 1) {
                String fieldName = methodName.substring(3);
                fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1);
                Class<?> paramClass = parameterTypes[0];
                if (json.containsKey((Object)fieldName)) {
                    Object sourceFieldValue = json.get((Object)fieldName);
                    Object targetFieldValue = FastJsonUtil.To_JavaObject(sourceFieldValue, paramClass);
                    method.invoke(entity, targetFieldValue);
                }
            }
            ++i;
        }
    }

    public static Object To_JSON(Object source) throws Exception {
        Class<?> sourceClass = source.getClass();
        if (sourceClass.isArray()) {
            JSONArray result = new JSONArray();
            int array_length = Array.getLength(source);
            int i = 0;
            while (i < array_length) {
                Object item = Array.get(source, i);
                result.add(FastJsonUtil.To_JSON(item));
                ++i;
            }
            return result;
        }
        JSONObject result = new JSONObject();
        Method[] meethodArray = sourceClass.getMethods();
        int i = 0;
        while (i < meethodArray.length) {
            Class<?>[] parameterTypes;
            Method method = meethodArray[i];
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            if (modifiers == 1 && methodName.startsWith("get") && (parameterTypes = method.getParameterTypes()).length == 0) {
                Object put_value;
                String fieldName = methodName.substring(3);
                fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1);
                Object value = method.invoke(source, new Object[0]);
                if (value == null) {
                    put_value = null;
                } else {
                    String valueClassName = value.getClass().getName();
                    if (valueClassName.equals("java.lang.String")) {
                        put_value = value;
                    } else if (valueClassName.equals("java.util.Date")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                        put_value = sdf.format(value);
                    } else {
                        put_value = valueClassName.equals("java.lang.Long") || valueClassName.equals("long") ? value : (valueClassName.equals("java.lang.Double") || valueClassName.equals("double") ? value : (valueClassName.equals("java.lang.Boolean") || valueClassName.equals("boolean") ? value : FastJsonUtil.To_JSON(value)));
                    }
                }
                result.put(fieldName, put_value);
            }
            ++i;
        }
        return result;
    }

    public static Object To_JavaObject(Object json, Class<?> entityClass) throws Exception {
        if (json == null) {
            return null;
        }
        String targetClassName = entityClass.getName();
        if (json instanceof JSONArray && entityClass.isArray()) {
            JSONArray sourceEntity = (JSONArray)json;
            int sourceLength = sourceEntity.size();
            Class<?> targetComponentType = entityClass.getComponentType();
            Object targetObjectArray = Array.newInstance(targetComponentType, sourceLength);
            int i = 0;
            while (i < sourceLength) {
                Object sourceObject = sourceEntity.get(i);
                Object targetObject = FastJsonUtil.To_JavaObject(sourceObject, targetComponentType);
                Array.set(targetObjectArray, i, targetObject);
                ++i;
            }
            return targetObjectArray;
        }
        if (json instanceof JSONObject) {
            JSONObject sourceEntity = (JSONObject)json;
            Constructor<?> constructorMethod = entityClass.getConstructor(new Class[0]);
            Object targetObject = constructorMethod.newInstance(new Object[0]);
            Method[] methodArray = entityClass.getMethods();
            int i = 0;
            while (i < methodArray.length) {
                Class<?>[] parameterTypes;
                Method method = methodArray[i];
                int modifiers = method.getModifiers();
                String methodName = method.getName();
                if (modifiers == 1 && methodName.startsWith("set") && (parameterTypes = method.getParameterTypes()).length == 1) {
                    String fieldName = methodName.substring(3);
                    fieldName = String.valueOf(fieldName.substring(0, 1).toLowerCase()) + fieldName.substring(1);
                    Class<?> paramClass = parameterTypes[0];
                    if (sourceEntity.containsKey((Object)fieldName)) {
                        Object sourceFieldValue = sourceEntity.get((Object)fieldName);
                        Object targetFieldValue = FastJsonUtil.To_JavaObject(sourceFieldValue, paramClass);
                        method.invoke(targetObject, targetFieldValue);
                    }
                }
                ++i;
            }
            return targetObject;
        }
        if (json instanceof String && targetClassName.equals("java.lang.String")) {
            return (String)json;
        }
        if (json instanceof String && targetClassName.equals("java.util.Date")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            return sdf.parse((String)json);
        }
        if (targetClassName.equals("java.lang.Long") || targetClassName.equals("long")) {
            if (json instanceof String) {
                Long value = Long.parseLong((String)json);
                return value;
            }
            if (json instanceof Integer) {
                return ((Integer)json).longValue();
            }
            if (json instanceof Long) {
                return (long)((Long)json);
            }
            if (json instanceof BigInteger) {
                return ((BigInteger)json).longValue();
            }
            return null;
        }
        if (targetClassName.equals("java.lang.Double") || targetClassName.equals("double")) {
            if (json instanceof String) {
                Double value = Double.parseDouble((String)json);
                return value;
            }
            if (json instanceof Integer) {
                return ((Integer)json).doubleValue();
            }
            if (json instanceof Long) {
                return ((Long)json).doubleValue();
            }
            if (json instanceof BigInteger) {
                return ((BigInteger)json).doubleValue();
            }
            if (json instanceof Float) {
                return ((Float)json).doubleValue();
            }
            if (json instanceof Double) {
                return (double)((Double)json);
            }
            if (json instanceof BigDecimal) {
                return ((BigDecimal)json).doubleValue();
            }
            return null;
        }
        if (targetClassName.equals("java.lang.Boolean") || targetClassName.equals("boolean")) {
            if (json instanceof String) {
                Boolean value = ((String)json).equalsIgnoreCase("true");
                return value;
            }
            if (json instanceof Boolean) {
                Boolean value = (Boolean)json;
                return value;
            }
            return null;
        }
        return null;
    }

    public static void Normalize(Object source) {
        block9: {
            block8: {
                if (!(source instanceof JSONObject)) break block8;
                JSONObject sourceJSON = (JSONObject)source;
                HashMap<String, Number> newMap = new HashMap<String, Number>();
                for (String key : sourceJSON.keySet()) {
                    Object value = sourceJSON.get((Object)key);
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        newMap.put(key, ((Integer)value).longValue());
                        continue;
                    }
                    if (value instanceof Long) continue;
                    if (value instanceof BigInteger) {
                        newMap.put(key, ((BigInteger)value).longValue());
                        continue;
                    }
                    if (value instanceof Float) {
                        newMap.put(key, ((Float)value).doubleValue());
                        continue;
                    }
                    if (value instanceof Double) continue;
                    if (value instanceof BigDecimal) {
                        newMap.put(key, ((BigDecimal)value).doubleValue());
                        continue;
                    }
                    if (!(value instanceof JSONObject) && !(value instanceof JSONArray)) continue;
                    FastJsonUtil.Normalize(value);
                }
                for (String key : newMap.keySet()) {
                    Object value = newMap.get(key);
                    sourceJSON.remove((Object)key);
                    sourceJSON.put(key, value);
                }
                break block9;
            }
            if (!(source instanceof JSONArray)) break block9;
            JSONArray sourceJSON = (JSONArray)source;
            int i = 0;
            while (i < sourceJSON.size()) {
                Object sourceItem = sourceJSON.get(i);
                if (sourceItem != null && (sourceItem instanceof JSONObject || sourceItem instanceof JSONArray)) {
                    FastJsonUtil.Normalize(sourceItem);
                }
                ++i;
            }
        }
    }

    public static Object Clone_JSON(Object source) {
        if (source instanceof JSONObject) {
            JSONObject result = new JSONObject();
            JSONObject sourceJSON = (JSONObject)source;
            for (String key : sourceJSON.keySet()) {
                Object value = sourceJSON.get((Object)key);
                result.put(key, FastJsonUtil.Clone_JSON(value));
            }
            return result;
        }
        if (source instanceof JSONArray) {
            JSONArray result = new JSONArray();
            JSONArray sourceJSON = (JSONArray)source;
            int i = 0;
            while (i < sourceJSON.size()) {
                result.add(FastJsonUtil.Clone_JSON(sourceJSON.get(i)));
                ++i;
            }
            return result;
        }
        if (source instanceof String) {
            return source;
        }
        if (source instanceof Double) {
            return source;
        }
        if (source instanceof Long) {
            return source;
        }
        if (source instanceof Boolean) {
            return source;
        }
        return null;
    }
}

