/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.zillion.database.agent.ZillionQueryResult;
import com.zillion.database.agent.ZillionQueryTmp;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.async.AsyncUtil;
import com.zillion.database.util.ResultSet_MySQL;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaWrapper;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableSchema;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.zillion.util.common.MyException;

public class MySQLUtil {
    public static void scan(Connection conn, String ori_tableName_full, SchemaRepositoryContainer container, ZillionTableSchema schema, SchemaWrapper schemaWrapper, JSONArray ReturnColumns, List<JSONObject> CriteriaList, String QueryType, JSONArray content, ZillionQueryTmp zqt, ZipArchiveOutputStream out, AsyncJob job, String[] keys, boolean SortInDB, JSONArray OrderBy, long Limit_Skip, long Limit_Count, ZillionQueryResult result, JSONObject Set2) throws Exception {
        String stringSQL;
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuffer sb_return = new StringBuffer();
        if (QueryType.equals("select") || QueryType.equals("export")) {
            if (ReturnColumns != null) {
                int i = 0;
                while (i < ReturnColumns.size()) {
                    String key = (String)ReturnColumns.get(i);
                    if (sb_return.length() > 0) {
                        sb_return.append(",");
                    }
                    sb_return.append("`" + key + "`");
                    ++i;
                }
            } else {
                sb_return.append(" * ");
            }
        }
        StringBuffer sb_set = new StringBuffer();
        if (QueryType.equals("update")) {
            MySQLUtil.generateSQL_Set(schema.ColumnMap, Set2, sb_set, typeList, paramList);
        }
        StringBuffer sb_condition = new StringBuffer();
        MySQLUtil.generateSQL(schema.ColumnMap, CriteriaList, sb_condition, typeList, paramList);
        StringBuffer sb_order_by = new StringBuffer();
        if (SortInDB && OrderBy != null && OrderBy.size() > 0) {
            int i = 0;
            while (i < OrderBy.size()) {
                JSONObject item0 = (JSONObject)OrderBy.get(i);
                String Column = (String)item0.get((Object)"Column");
                boolean Asc = (Boolean)item0.get((Object)"Asc");
                if (i > 0) {
                    sb_order_by.append(",");
                }
                sb_order_by.append("`" + Column + "`" + " " + (Asc ? "asc" : "desc"));
                ++i;
            }
        } else {
            String[] Asc = keys;
            int Column = keys.length;
            int item0 = 0;
            while (item0 < Column) {
                String keyItem = Asc[item0];
                if (sb_order_by.length() > 0) {
                    sb_order_by.append(",");
                }
                sb_order_by.append("`" + keyItem + "`");
                ++item0;
            }
        }
        String sb_limit = " limit " + Limit_Skip + "," + Limit_Count;
        JSONArray contentInner = new JSONArray();
        String sql_where = sb_condition.toString().length() > 2 ? " where " + sb_condition.toString() : " ";
        String sql_order_by = " order by " + sb_order_by.toString();
        if (QueryType.equals("select_count")) {
            stringSQL = "select count(*) from " + ori_tableName_full + sql_where + " " + sb_limit;
            result.count += (long)MySQLUtil.ori_execute(conn, stringSQL, typeList, paramList);
        } else if (QueryType.equals("select") || QueryType.equals("export")) {
            stringSQL = "select " + sb_return + " from " + ori_tableName_full + sql_where + " " + sql_order_by + " " + sb_limit;
            JSONArray selectContent = MySQLUtil.ori_select(conn, stringSQL, typeList, paramList, schema);
            int index_row = 0;
            while (index_row < selectContent.size()) {
                JSONObject contentItem = (JSONObject)selectContent.get(index_row);
                ++zqt.scanned_count;
                ++zqt.count_wait_tmp;
                if (zqt.count_wait_tmp >= AsyncUtil.count_wait) {
                    job.Add(zqt.count_wait_tmp);
                    zqt.count_wait_tmp = 0L;
                }
                if ((long)zqt.scanned_count > Limit_Skip && (long)zqt.scanned_count <= Limit_Skip + Limit_Count) {
                    ++result.count;
                    if (QueryType.equals("select")) {
                        if (job.brs != null) {
                            job.brs.TryPush(contentItem);
                        } else {
                            content.add((Object)contentItem);
                        }
                    } else {
                        contentInner.add((Object)contentItem);
                    }
                    if (QueryType.equals("export") && (long)contentInner.size() >= ZillionConstant.export_batch_size) {
                        out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(String.valueOf(zqt.df.format(zqt.zip_index++)) + ".json"));
                        byte[] bytes = JSON.toJSONString((Object)contentInner, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}).getBytes("UTF-8");
                        out.write(bytes);
                        out.closeArchiveEntry();
                        contentInner.clear();
                    }
                } else if ((long)zqt.scanned_count > Limit_Skip + Limit_Count) {
                    zqt.scanned_finish = true;
                    break;
                }
                ++index_row;
            }
            if (zqt.count_wait_tmp > 0L) {
                job.Add(zqt.count_wait_tmp);
                zqt.count_wait_tmp = 0L;
            }
            if (QueryType.equals("export") && contentInner.size() > 0) {
                out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(String.valueOf(zqt.df.format(zqt.zip_index++)) + ".json"));
                byte[] bytes = JSON.toJSONString((Object)contentInner, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}).getBytes("UTF-8");
                out.write(bytes);
                out.closeArchiveEntry();
                contentInner.clear();
            }
        } else if (QueryType.equals("delete")) {
            stringSQL = "delete from " + ori_tableName_full + sql_where;
            result.count += (long)MySQLUtil.ori_executeUpdate(conn, stringSQL, typeList, paramList);
        } else if (QueryType.equals("update")) {
            stringSQL = "update " + ori_tableName_full + " set " + sb_set.toString() + sql_where;
            result.count += (long)MySQLUtil.ori_executeUpdate(conn, stringSQL, typeList, paramList);
        } else {
            throw new MyException("");
        }
    }

    public static void batch_process(Connection conn, String ori_tableName_full, ZillionTableSchema schema, String QueryType, JSONArray InsertObjects, boolean is_put) throws Exception {
        if (!QueryType.equals("insert") && !QueryType.equals("delete")) {
            return;
        }
        if (InsertObjects.size() == 0) {
            return;
        }
        if (QueryType.equals("insert")) {
            Object col;
            String[] stringArray;
            String[] CriteriaInner;
            JSONObject InsertObject;
            int i;
            JSONArray object_insert = new JSONArray();
            JSONArray object_update = new JSONArray();
            if (is_put) {
                i = 0;
                while (i < InsertObjects.size()) {
                    InsertObject = (JSONObject)InsertObjects.get(i);
                    JSONObject Criteria = new JSONObject();
                    String[] stringArray2 = schema.Key;
                    int n = schema.Key.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray2[n2];
                        Criteria.put(key, InsertObject.get((Object)key));
                        ++n2;
                    }
                    ArrayList<Integer> typeList = new ArrayList<Integer>();
                    ArrayList<Object> paramList = new ArrayList<Object>();
                    StringBuffer sb_condition = new StringBuffer();
                    MySQLUtil.generateSQL(schema.ColumnMap, Criteria, sb_condition, typeList, paramList);
                    String stringSQL = "select * from " + ori_tableName_full + " where " + sb_condition.toString();
                    JSONArray selectContent = MySQLUtil.ori_select(conn, stringSQL, typeList, paramList, schema);
                    if (selectContent.size() == 0) {
                        object_insert.add((Object)InsertObject);
                    } else {
                        object_update.add((Object)InsertObject);
                    }
                    ++i;
                }
            } else {
                object_insert.addAll((Collection)InsertObjects);
            }
            i = 0;
            while (i < object_update.size()) {
                InsertObject = (JSONObject)object_update.get(i);
                ArrayList<Integer> typeList = new ArrayList<Integer>();
                ArrayList<Object> paramList = new ArrayList<Object>();
                StringBuffer sb_set = new StringBuffer();
                CriteriaInner = new JSONObject();
                JSONObject SetInner = new JSONObject();
                String[] stringArray3 = schema.Key;
                int n = schema.Key.length;
                int n3 = 0;
                while (n3 < n) {
                    String key = stringArray3[n3];
                    CriteriaInner.put(key, InsertObject.get((Object)key));
                    ++n3;
                }
                ArrayList<JSONObject> CriteriaInnerList = new ArrayList<JSONObject>();
                CriteriaInnerList.add((JSONObject)CriteriaInner);
                stringArray = schema.OtherColumn;
                int n4 = schema.OtherColumn.length;
                n = 0;
                while (n < n4) {
                    String key = stringArray[n];
                    SetInner.put(key, InsertObject.get((Object)key));
                    ++n;
                }
                MySQLUtil.generateSQL_Set(schema.ColumnMap, SetInner, sb_set, typeList, paramList);
                StringBuffer sb_condition = new StringBuffer();
                MySQLUtil.generateSQL(schema.ColumnMap, CriteriaInnerList, sb_condition, typeList, paramList);
                String sql_where = sb_condition.toString().length() > 2 ? " where " + sb_condition.toString() : " ";
                String stringSQL2 = "update " + ori_tableName_full + " set " + sb_set.toString() + sql_where;
                MySQLUtil.ori_executeUpdate(conn, stringSQL2, typeList, paramList);
                ++i;
            }
            StringBuffer sb_col = new StringBuffer();
            StringBuffer sb_wenhao = new StringBuffer();
            CriteriaInner = schema.Key;
            int sb_set = schema.Key.length;
            int paramList = 0;
            while (paramList < sb_set) {
                col = CriteriaInner[paramList];
                if (sb_col.length() > 0) {
                    sb_col.append(",");
                }
                sb_col.append("`" + (String)col + "`");
                if (sb_wenhao.length() > 0) {
                    sb_wenhao.append(",");
                }
                sb_wenhao.append("?");
                ++paramList;
            }
            CriteriaInner = schema.OtherColumn;
            sb_set = schema.OtherColumn.length;
            paramList = 0;
            while (paramList < sb_set) {
                col = CriteriaInner[paramList];
                if (sb_col.length() > 0) {
                    sb_col.append(",");
                }
                sb_col.append("`" + (String)col + "`");
                if (sb_wenhao.length() > 0) {
                    sb_wenhao.append(",");
                }
                sb_wenhao.append("?");
                ++paramList;
            }
            String stringSQL = "insert into " + ori_tableName_full + "(" + sb_col + ") values(" + sb_wenhao + ")";
            PreparedStatement stmt = conn.prepareStatement(stringSQL);
            int i2 = 0;
            while (i2 < object_insert.size()) {
                JSONObject InsertObject2 = (JSONObject)object_insert.get(i2);
                int parameterIndex = 1;
                String[][] columnArrayArray = new String[][]{schema.Key, schema.OtherColumn};
                stringArray = columnArrayArray;
                int stringSQL2 = columnArrayArray.length;
                int sql_where = 0;
                while (sql_where < stringSQL2) {
                    String columnArray;
                    String string = columnArray = stringArray[sql_where];
                    int n = ((String)string).length;
                    int n5 = 0;
                    while (n5 < n) {
                        String col2 = string[n5];
                        ZillionTableColumn ztc = schema.ColumnMap.get(col2);
                        Object columnObject = InsertObject2.get((Object)col2);
                        if (columnObject == null && ztc.NullValueConvert) {
                            columnObject = "";
                        }
                        int type = 12;
                        if (ztc.Type == ZillionTableColumnEnum.LONG) {
                            type = -5;
                        } else if (ztc.Type == ZillionTableColumnEnum.DOUBLE) {
                            type = 8;
                        } else if (ztc.Type == ZillionTableColumnEnum.BOOLEAN) {
                            type = 4;
                        }
                        if (columnObject == null) {
                            stmt.setNull(parameterIndex, type);
                        } else if (type == 4) {
                            stmt.setInt(parameterIndex, MySQLUtil.param_to_int(columnObject));
                        } else if (type == -5) {
                            stmt.setBigDecimal(parameterIndex, new BigDecimal(MySQLUtil.param_to_long(columnObject)));
                        } else if (type == 8) {
                            stmt.setDouble(parameterIndex, MySQLUtil.param_to_double(columnObject));
                        } else if (type == 12) {
                            stmt.setString(parameterIndex, (String)columnObject);
                        }
                        ++parameterIndex;
                        ++n5;
                    }
                    ++sql_where;
                }
                stmt.addBatch();
                ++i2;
            }
            stmt.executeBatch();
            stmt.close();
        } else if (QueryType.equals("delete")) {
            StringBuffer sb = new StringBuffer();
            String[] stringSQL = schema.Key;
            int sb_wenhao = schema.Key.length;
            int sb_col = 0;
            while (sb_col < sb_wenhao) {
                String col = stringSQL[sb_col];
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("`" + col + "`=?");
                ++sb_col;
            }
            String stringSQL3 = "delete from " + ori_tableName_full + " where " + sb.toString();
            PreparedStatement stmt = conn.prepareStatement(stringSQL3);
            int i = 0;
            while (i < InsertObjects.size()) {
                JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
                int parameterIndex = 1;
                String[] stringArray = schema.Key;
                int n = schema.Key.length;
                int n6 = 0;
                while (n6 < n) {
                    String col = stringArray[n6];
                    ZillionTableColumn ztc = schema.ColumnMap.get(col);
                    Object columnObject = InsertObject.get((Object)col);
                    if (columnObject == null && ztc.NullValueConvert) {
                        columnObject = "";
                    }
                    int type = 12;
                    if (ztc.Type == ZillionTableColumnEnum.LONG) {
                        type = -5;
                    } else if (ztc.Type == ZillionTableColumnEnum.DOUBLE) {
                        type = 8;
                    } else if (ztc.Type == ZillionTableColumnEnum.BOOLEAN) {
                        type = 4;
                    }
                    if (columnObject == null) {
                        stmt.setNull(parameterIndex, type);
                    } else if (type == 4) {
                        stmt.setInt(parameterIndex, MySQLUtil.param_to_int(columnObject));
                    } else if (type == -5) {
                        stmt.setBigDecimal(parameterIndex, new BigDecimal(MySQLUtil.param_to_long(columnObject)));
                    } else if (type == 8) {
                        stmt.setDouble(parameterIndex, MySQLUtil.param_to_double(columnObject));
                    } else if (type == 12) {
                        stmt.setString(parameterIndex, (String)columnObject);
                    }
                    ++parameterIndex;
                    ++n6;
                }
                stmt.addBatch();
                ++i;
            }
            stmt.execute();
            stmt.executeBatch();
            stmt.close();
        }
    }

    public static JSONArray batch_get(Connection conn, String ori_tableName_full, ZillionTableSchema schema, JSONArray InsertObjects, JSONArray content, Map<String, Boolean> ReturnColumnsMap) throws Exception {
        JSONArray InsertObjects_real = new JSONArray();
        ArrayList<Integer> typeList = new ArrayList<Integer>();
        ArrayList<Object> paramList = new ArrayList<Object>();
        int i = 0;
        while (i < InsertObjects.size()) {
            typeList.clear();
            paramList.clear();
            StringBuffer sb_condition = new StringBuffer();
            JSONObject InsertObject = (JSONObject)InsertObjects.get(i);
            JSONObject Criteria = new JSONObject();
            String[] stringArray = schema.Key;
            int n = schema.Key.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Criteria.put(key, InsertObject.get((Object)key));
                ++n2;
            }
            MySQLUtil.generateSQL(schema.ColumnMap, Criteria, sb_condition, typeList, paramList);
            String stringSQL = "select * from " + ori_tableName_full + " where " + sb_condition.toString();
            JSONArray selectContent = MySQLUtil.ori_select(conn, stringSQL, typeList, paramList, schema);
            if (selectContent.size() > 0) {
                content.addAll((Collection)selectContent);
            } else {
                InsertObjects_real.add((Object)InsertObject);
            }
            ++i;
        }
        return InsertObjects_real;
    }

    public static void generateSQL(Map<String, ZillionTableColumn> ColumnMap, List<JSONObject> CriteriaList, StringBuffer sb, List<Integer> typeList, List<Object> paramList) {
        JSONObject Criteria = CriteriaList.get(0);
        StringBuffer sb1 = new StringBuffer();
        MySQLUtil.generateSQL(ColumnMap, Criteria, sb1, typeList, paramList);
        sb.append("(" + sb1.toString() + ")");
        int i = 1;
        while (i < CriteriaList.size()) {
            JSONObject CriteriaInner = CriteriaList.get(i);
            StringBuffer sb12 = new StringBuffer();
            MySQLUtil.generateSQL(ColumnMap, CriteriaInner, sb12, typeList, paramList);
            sb.append(" or ");
            sb.append("(" + sb12.toString() + ")");
            ++i;
        }
    }

    public static void generateSQL(Map<String, ZillionTableColumn> ColumnMap, JSONObject Criteria, StringBuffer sb, List<Integer> typeList, List<Object> paramList) {
        for (String key : Criteria.keySet()) {
            Object columnObject = Criteria.get((Object)key);
            ZillionTableColumn columnDef = ColumnMap.get(key);
            int type = 12;
            if (columnDef.Type == ZillionTableColumnEnum.LONG) {
                type = -5;
            } else if (columnDef.Type == ZillionTableColumnEnum.DOUBLE) {
                type = 8;
            } else if (columnDef.Type == ZillionTableColumnEnum.BOOLEAN) {
                type = 4;
            }
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            if (columnObject instanceof JSONObject) {
                JSONObject columnJSON = (JSONObject)columnObject;
                StringBuffer sbInner = new StringBuffer();
                Iterator keyIterInner = columnJSON.keySet().iterator();
                while (keyIterInner.hasNext()) {
                    String fuhao;
                    Object columnObjectInner;
                    if (sbInner.length() > 0) {
                        sbInner.append(" and ");
                    }
                    if ((columnObjectInner = columnJSON.get((Object)(fuhao = (String)keyIterInner.next()))) == null && columnDef.NullValueConvert) {
                        columnObjectInner = "";
                    }
                    if (columnObjectInner == null) {
                        if (fuhao.equals("$lt")) {
                            sbInner.append("1=0");
                            continue;
                        }
                        if (fuhao.equals("$lte")) {
                            sbInner.append("`" + key + "` is null");
                            continue;
                        }
                        if (fuhao.equals("$gt")) {
                            sbInner.append("`" + key + "` is not null");
                            continue;
                        }
                        if (!fuhao.equals("$gte")) continue;
                        sbInner.append("1=1");
                        continue;
                    }
                    if (fuhao.equals("$lt")) {
                        if (columnDef.NullValueConvert) {
                            sbInner.append("`" + key + "`<?");
                        } else {
                            sbInner.append("(`" + key + "`<? or " + key + " is null)");
                        }
                        typeList.add(type);
                        paramList.add(columnObjectInner);
                        continue;
                    }
                    if (fuhao.equals("$lte")) {
                        if (columnDef.NullValueConvert) {
                            sbInner.append("`" + key + "`<=?");
                        } else {
                            sbInner.append("(`" + key + "`<=? or " + key + " is null)");
                        }
                        typeList.add(type);
                        paramList.add(columnObjectInner);
                        continue;
                    }
                    if (fuhao.equals("$gt")) {
                        sbInner.append("`" + key + "`>?");
                        typeList.add(type);
                        paramList.add(columnObjectInner);
                        continue;
                    }
                    if (!fuhao.equals("$gte")) continue;
                    sbInner.append("`" + key + "`>=?");
                    typeList.add(type);
                    paramList.add(columnObjectInner);
                }
                sb.append(sbInner.toString());
                continue;
            }
            if (columnObject == null && columnDef.NullValueConvert) {
                columnObject = "";
            }
            if (columnObject == null) {
                sb.append("`" + key + "` is null");
                continue;
            }
            sb.append("`" + key + "`=?");
            typeList.add(type);
            paramList.add(columnObject);
        }
    }

    public static void generateSQL_Set(Map<String, ZillionTableColumn> ColumnMap, JSONObject Set2, StringBuffer sb_set, List<Integer> typeList, List<Object> paramList) {
        for (String key : Set2.keySet()) {
            Object columnObject = Set2.get((Object)key);
            ZillionTableColumn columnDef = ColumnMap.get(key);
            int type = 12;
            if (columnDef.Type == ZillionTableColumnEnum.LONG) {
                type = -5;
            } else if (columnDef.Type == ZillionTableColumnEnum.DOUBLE) {
                type = 8;
            } else if (columnDef.Type == ZillionTableColumnEnum.BOOLEAN) {
                type = 4;
            }
            if (sb_set.length() > 0) {
                sb_set.append(",");
            }
            sb_set.append("`" + key + "`=?");
            if (columnObject == null && columnDef.NullValueConvert) {
                columnObject = "";
            }
            typeList.add(type);
            paramList.add(columnObject);
        }
    }

    public static boolean ori_execute(Connection conn, String stringSQL) throws Exception {
        PreparedStatement stmt = conn.prepareStatement(stringSQL);
        boolean result = stmt.execute();
        stmt.close();
        return result;
    }

    public static int ori_execute(Connection conn, String stringSQL, List<Integer> typeList, List<Object> params) throws Exception {
        int result = 0;
        PreparedStatement stmt = conn.prepareStatement(stringSQL);
        int i = 0;
        while (i < params.size()) {
            int parameterIndex = i + 1;
            Object param = params.get(i);
            int ttttt = typeList.get(i);
            if (param == null) {
                stmt.setNull(parameterIndex, ttttt);
            } else if (ttttt == 4) {
                stmt.setInt(parameterIndex, MySQLUtil.param_to_int(param));
            } else if (ttttt == -5) {
                stmt.setBigDecimal(parameterIndex, new BigDecimal(MySQLUtil.param_to_long(param)));
            } else if (ttttt == 8) {
                stmt.setDouble(parameterIndex, MySQLUtil.param_to_double(param));
            } else if (ttttt == 12) {
                stmt.setString(parameterIndex, (String)param);
            }
            ++i;
        }
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        stmt.close();
        return result;
    }

    public static int ori_executeQuery(Connection conn, String stringSQL) throws Exception {
        int result = 0;
        PreparedStatement stmt = conn.prepareStatement(stringSQL);
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        stmt.close();
        return result;
    }

    public static int ori_executeUpdate(Connection conn, String stringSQL, List<Integer> typeList, List<Object> params) throws Exception {
        int result = 0;
        PreparedStatement stmt = conn.prepareStatement(stringSQL);
        int i = 0;
        while (i < params.size()) {
            int parameterIndex = i + 1;
            Object param = params.get(i);
            int ttttt = typeList.get(i);
            if (param == null) {
                stmt.setNull(parameterIndex, ttttt);
            } else if (ttttt == 4) {
                stmt.setInt(parameterIndex, MySQLUtil.param_to_int(param));
            } else if (ttttt == -5) {
                stmt.setBigDecimal(parameterIndex, new BigDecimal(MySQLUtil.param_to_long(param)));
            } else if (ttttt == 8) {
                stmt.setDouble(parameterIndex, MySQLUtil.param_to_double(param));
            } else if (ttttt == 12) {
                stmt.setString(parameterIndex, (String)param);
            }
            ++i;
        }
        result = stmt.executeUpdate();
        stmt.close();
        return result;
    }

    public static ResultSet_MySQL ori_select(Connection conn, String stringSQL, List<Integer> typeList, List<Object> params) throws Exception {
        ResultSet_MySQL result = new ResultSet_MySQL();
        PreparedStatement stmt = conn.prepareStatement(stringSQL);
        int i = 0;
        while (i < params.size()) {
            int parameterIndex = i + 1;
            Object param = params.get(i);
            int ttttt = typeList.get(i);
            if (param == null) {
                stmt.setNull(parameterIndex, ttttt);
            } else if (ttttt == 4) {
                stmt.setInt(parameterIndex, MySQLUtil.param_to_int(param));
            } else if (ttttt == -5) {
                stmt.setBigDecimal(parameterIndex, new BigDecimal(MySQLUtil.param_to_long(param)));
            } else if (ttttt == 8) {
                stmt.setDouble(parameterIndex, MySQLUtil.param_to_double(param));
            } else if (ttttt == 12) {
                stmt.setString(parameterIndex, (String)param);
            }
            ++i;
        }
        ResultSet rs = stmt.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        String[] columnLabels = new String[rsmd.getColumnCount()];
        int[] columnTypes = new int[rsmd.getColumnCount()];
        int i2 = 1;
        while (i2 <= rsmd.getColumnCount()) {
            columnLabels[i2 - 1] = rsmd.getColumnLabel(i2);
            columnTypes[i2 - 1] = rsmd.getColumnType(i2);
            ++i2;
        }
        result.columnLabels = columnLabels;
        result.columnTypes = columnTypes;
        while (rs.next()) {
            Object[] columns = new Object[columnLabels.length];
            int i3 = 0;
            while (i3 < columnLabels.length) {
                int columnType = columnTypes[i3];
                if (columnType == 4) {
                    columns[i3] = rs.getInt(columnLabels[i3]);
                } else if (columnType == -5) {
                    try {
                        columns[i3] = rs.getBigDecimal(columnLabels[i3]);
                    }
                    catch (Exception e) {
                        columns[i3] = rs.getLong(columnLabels[i3]);
                    }
                } else if (columnType == 8) {
                    columns[i3] = rs.getDouble(columnLabels[i3]);
                } else if (columnType == 12) {
                    columns[i3] = rs.getString(columnLabels[i3]);
                } else if (columnType == -1) {
                    columns[i3] = rs.getString(columnLabels[i3]);
                } else {
                    throw new MyException("");
                }
                if (rs.wasNull()) {
                    columns[i3] = null;
                }
                ++i3;
            }
            result.rowList.add(columns);
        }
        rs.close();
        stmt.close();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONArray ori_select(Connection conn, String stringSQL, List<Integer> typeList, List<Object> params, ZillionTableSchema schema) throws Exception {
        JSONArray result = new JSONArray();
        PreparedStatement stmt = conn.prepareStatement(stringSQL);
        int i = 0;
        while (i < params.size()) {
            int parameterIndex = i + 1;
            Object param = params.get(i);
            int ttttt = typeList.get(i);
            if (param == null) {
                stmt.setNull(parameterIndex, ttttt);
            } else if (ttttt == 4) {
                stmt.setInt(parameterIndex, MySQLUtil.param_to_int(param));
            } else if (ttttt == -5) {
                stmt.setBigDecimal(parameterIndex, new BigDecimal(MySQLUtil.param_to_long(param)));
            } else if (ttttt == 8) {
                stmt.setDouble(parameterIndex, MySQLUtil.param_to_double(param));
            } else if (ttttt == 12) {
                stmt.setString(parameterIndex, (String)param);
            }
            ++i;
        }
        ResultSet rs = stmt.executeQuery();
        ResultSetMetaData rsmd = rs.getMetaData();
        String[] columnLabels = new String[rsmd.getColumnCount()];
        int[] columnTypes = new int[rsmd.getColumnCount()];
        int i2 = 1;
        while (i2 <= rsmd.getColumnCount()) {
            columnLabels[i2 - 1] = rsmd.getColumnLabel(i2);
            columnTypes[i2 - 1] = rsmd.getColumnType(i2);
            ++i2;
        }
        while (rs.next()) {
            JSONObject contentItem = new JSONObject();
            int i3 = 0;
            while (i3 < columnLabels.length) {
                String columnLabel = columnLabels[i3];
                int columnType = columnTypes[i3];
                ZillionTableColumn columnDef = schema.ColumnMap.get(columnLabel);
                if (columnDef == null) {
                    for (String key_def : schema.ColumnMap.keySet()) {
                        if (!key_def.equalsIgnoreCase(columnLabel)) continue;
                        columnDef = schema.ColumnMap.get(key_def);
                        break;
                    }
                }
                Object columnObject = null;
                if (columnType == 4) {
                    columnObject = rs.getInt(columnLabels[i3]);
                } else if (columnType == -5) {
                    try {
                        columnObject = rs.getBigDecimal(columnLabels[i3]);
                    }
                    catch (Exception e) {
                        columnObject = rs.getLong(columnLabels[i3]);
                    }
                } else if (columnType == 8) {
                    columnObject = rs.getDouble(columnLabels[i3]);
                } else if (columnType == 12) {
                    columnObject = rs.getString(columnLabels[i3]);
                } else {
                    if (columnType != -1) throw new MyException("");
                    columnObject = rs.getString(columnLabels[i3]);
                }
                if (rs.wasNull()) {
                    columnObject = null;
                }
                String columnName = columnDef.Name;
                Object columnValue = null;
                if (columnObject != null) {
                    if (columnDef.Type == ZillionTableColumnEnum.LONG) {
                        if (columnObject instanceof Long) {
                            columnValue = (long)((Long)columnObject);
                        } else {
                            if (!(columnObject instanceof BigDecimal)) throw new Exception("ZillionTableColumnEnum.LONG:" + columnObject.getClass().getName());
                            columnValue = ((BigDecimal)columnObject).longValue();
                        }
                    } else if (columnDef.Type == ZillionTableColumnEnum.DOUBLE) {
                        columnValue = (double)((Double)columnObject);
                    } else if (columnDef.Type == ZillionTableColumnEnum.STRING || columnDef.Type == ZillionTableColumnEnum.COMPRESSSTRING) {
                        if (columnObject.equals("") && columnDef.NullValueConvert) {
                            columnObject = null;
                        }
                        columnValue = (String)columnObject;
                    } else if (columnDef.Type == ZillionTableColumnEnum.BOOLEAN) {
                        columnValue = (Integer)columnObject == 1;
                    }
                }
                contentItem.put(columnName, columnValue);
                ++i3;
            }
            result.add((Object)contentItem);
        }
        rs.close();
        stmt.close();
        return result;
    }

    public static double param_to_double(Object columnObject) throws Exception {
        double result;
        if (columnObject instanceof Integer) {
            result = ((Integer)columnObject).doubleValue();
        } else if (columnObject instanceof Long) {
            result = ((Long)columnObject).doubleValue();
        } else if (columnObject instanceof BigInteger) {
            result = ((BigInteger)columnObject).doubleValue();
        } else if (columnObject instanceof Float) {
            result = ((Float)columnObject).doubleValue();
        } else if (columnObject instanceof Double) {
            result = (Double)columnObject;
        } else if (columnObject instanceof BigDecimal) {
            result = ((BigDecimal)columnObject).doubleValue();
        } else {
            throw new MyException("");
        }
        return result;
    }

    public static int param_to_int(Object columnObject) throws Exception {
        int result;
        if (columnObject instanceof Integer) {
            result = (Integer)columnObject;
        } else if (columnObject instanceof Long) {
            result = ((Long)columnObject).intValue();
        } else if (columnObject instanceof BigInteger) {
            result = ((BigInteger)columnObject).intValue();
        } else if (columnObject instanceof Boolean) {
            result = (Boolean)columnObject != false ? 1 : 0;
        } else {
            throw new MyException("");
        }
        return result;
    }

    public static long param_to_long(Object columnObject) throws Exception {
        long result;
        if (columnObject instanceof Integer) {
            result = ((Integer)columnObject).longValue();
        } else if (columnObject instanceof Long) {
            result = (Long)columnObject;
        } else if (columnObject instanceof BigInteger) {
            result = ((BigInteger)columnObject).longValue();
        } else if (columnObject instanceof BigDecimal) {
            result = ((BigDecimal)columnObject).longValue();
        } else if (columnObject instanceof Boolean) {
            result = (Boolean)columnObject != false ? 1 : 0;
        } else {
            throw new MyException("");
        }
        return result;
    }
}

