/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;

public class VisorTxInfo
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private IgniteUuid xid;
    private long duration;
    private TransactionIsolation isolation;
    private TransactionConcurrency concurrency;
    private long timeout;
    private String lb;
    private Collection<UUID> primaryNodes;
    private TransactionState state;
    private int size;

    public VisorTxInfo() {
    }

    public VisorTxInfo(IgniteUuid xid, long duration, TransactionIsolation isolation, TransactionConcurrency concurrency, long timeout, String lb, Collection<UUID> primaryNodes, TransactionState state, int size) {
        this.xid = xid;
        this.duration = duration;
        this.isolation = isolation;
        this.concurrency = concurrency;
        this.timeout = timeout;
        this.lb = lb;
        this.primaryNodes = primaryNodes;
        this.state = state;
        this.size = size;
    }

    public IgniteUuid getXid() {
        return this.xid;
    }

    public long getDuration() {
        return this.duration;
    }

    public TransactionIsolation getIsolation() {
        return this.isolation;
    }

    public TransactionConcurrency getConcurrency() {
        return this.concurrency;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getLabel() {
        return this.lb;
    }

    public Collection<UUID> getPrimaryNodes() {
        return this.primaryNodes;
    }

    public TransactionState getState() {
        return this.state;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeGridUuid(out, this.xid);
        out.writeLong(this.duration);
        U.writeEnum(out, this.isolation);
        U.writeEnum(out, this.concurrency);
        out.writeLong(this.timeout);
        U.writeString(out, this.lb);
        U.writeCollection(out, this.primaryNodes);
        U.writeEnum(out, this.state);
        out.writeInt(this.size);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.xid = U.readGridUuid(in);
        this.duration = in.readLong();
        this.isolation = TransactionIsolation.fromOrdinal(in.readByte());
        this.concurrency = TransactionConcurrency.fromOrdinal(in.readByte());
        this.timeout = in.readLong();
        this.lb = U.readString(in);
        this.primaryNodes = U.readCollection(in);
        this.state = TransactionState.fromOrdinal(in.readByte());
        this.size = in.readInt();
    }

    public String toString() {
        return S.toString(VisorTxInfo.class, this);
    }
}

