/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.freelist;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageInsertFragmentRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageInsertRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageRemoveRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DataPageUpdateRecord;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.Storable;
import org.apache.ignite.internal.processors.cache.persistence.evict.PageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.freelist.PagesList;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.AbstractDataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseBag;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class AbstractFreeList<T extends Storable>
extends PagesList
implements FreeList<T>,
ReuseList {
    private static final int BUCKETS = 256;
    private static final int REUSE_BUCKET = 255;
    private static final Integer COMPLETE = Integer.MAX_VALUE;
    private static final Integer FAIL_I = Integer.MIN_VALUE;
    private static final Long FAIL_L = Long.MAX_VALUE;
    private static final int MIN_PAGE_FREE_SPACE = 8;
    private final int shift;
    private final AtomicReferenceArray<PagesList.Stripe[]> buckets = new AtomicReferenceArray(256);
    private final int MIN_SIZE_FOR_DATA_PAGE;
    private final int emptyDataPagesBucket;
    private final PageHandler<T, Boolean> updateRow = new UpdateRowHandler();
    private final DataRegionMetricsImpl memMetrics;
    private final PageEvictionTracker evictionTracker;
    private final PageHandler<T, Integer> writeRow = new WriteRowHandler();
    private final PageHandler<Void, Long> rmvRow;

    public AbstractFreeList(int cacheId, String name, DataRegionMetricsImpl memMetrics, DataRegion memPlc, ReuseList reuseList, IgniteWriteAheadLogManager wal, long metaPageId, boolean initNew) throws IgniteCheckedException {
        super(cacheId, name, memPlc.pageMemory(), 256, wal, metaPageId);
        int pageSize;
        this.rmvRow = new RemoveRowHandler(cacheId == 0);
        this.evictionTracker = memPlc.evictionTracker();
        this.reuseList = reuseList == null ? this : reuseList;
        assert (U.isPow2(pageSize)) : "Page size must be a power of 2: " + pageSize;
        assert (U.isPow2(256));
        assert (256 <= pageSize) : pageSize;
        this.MIN_SIZE_FOR_DATA_PAGE = pageSize - 66;
        int shift = 0;
        for (pageSize = this.pageMem.pageSize(); pageSize > 256; pageSize >>>= 1) {
            ++shift;
        }
        this.shift = shift;
        this.memMetrics = memMetrics;
        this.emptyDataPagesBucket = this.bucket(this.MIN_SIZE_FOR_DATA_PAGE, false);
        this.init(metaPageId, initNew);
    }

    public long freeSpace() {
        long freeSpace = 0L;
        for (int b = 254; b > 0; --b) {
            long perPageFreeSpace = b << this.shift;
            long pages = this.bucketsSize[b].longValue();
            freeSpace += pages * perPageFreeSpace;
        }
        return freeSpace;
    }

    @Override
    public void dumpStatistics(IgniteLogger log) {
        long dataPages = 0L;
        boolean dumpBucketsInfo = false;
        for (int b = 0; b < 256; ++b) {
            long size = this.bucketsSize[b].longValue();
            if (this.isReuseBucket(b)) continue;
            dataPages += size;
        }
        if (dataPages > 0L && log.isInfoEnabled()) {
            log.info("FreeList [name=" + this.name + ", buckets=" + 256 + ", dataPages=" + dataPages + ", reusePages=" + this.bucketsSize[255].longValue() + "]");
        }
    }

    private int bucket(int freeSpace, boolean allowReuse) {
        assert (freeSpace > 0) : freeSpace;
        int bucket = freeSpace >>> this.shift;
        assert (bucket >= 0 && bucket < 256) : bucket;
        if (!allowReuse && this.isReuseBucket(bucket)) {
            --bucket;
        }
        return bucket;
    }

    private long allocateDataPage(int part) throws IgniteCheckedException {
        assert (part <= 65500);
        assert (part != 65535);
        return this.pageMem.allocatePage(this.grpId, part, (byte)1);
    }

    @Override
    public void insertDataRow(T row) throws IgniteCheckedException {
        int rowSize = this.ioVersions().latest().getRowSize(row);
        int written = 0;
        do {
            if (written != 0) {
                this.memMetrics.incrementLargeEntriesPages();
            }
            int freeSpace = Math.min(this.MIN_SIZE_FOR_DATA_PAGE, rowSize - written);
            long pageId = 0L;
            if (freeSpace == this.MIN_SIZE_FOR_DATA_PAGE) {
                pageId = this.takeEmptyPage(this.emptyDataPagesBucket, this.ioVersions());
            }
            boolean reuseBucket = false;
            if (pageId == 0L) {
                for (int b = this.bucket(freeSpace, false) + 1; b < 255; ++b) {
                    pageId = this.takeEmptyPage(b, this.ioVersions());
                    if (pageId == 0L) continue;
                    reuseBucket = this.isReuseBucket(b);
                    break;
                }
            }
            boolean allocated = pageId == 0L;
            pageId = allocated ? this.allocateDataPage(row.partition()) : PageIdUtils.changePartitionId(pageId, row.partition());
            AbstractDataPageIO<T> init = reuseBucket || allocated ? this.ioVersions().latest() : null;
            written = this.write(pageId, this.writeRow, init, row, written, FAIL_I);
            assert (written != FAIL_I);
        } while (written != COMPLETE);
    }

    @Override
    public boolean updateDataRow(long link, T row) throws IgniteCheckedException {
        assert (link != 0L);
        long pageId = PageIdUtils.pageId(link);
        int itemId = PageIdUtils.itemId(link);
        Boolean updated = this.write(pageId, this.updateRow, row, itemId, null);
        assert (updated != null);
        return updated;
    }

    @Override
    public void removeDataRowByLink(long link) throws IgniteCheckedException {
        assert (link != 0L);
        long pageId = PageIdUtils.pageId(link);
        int itemId = PageIdUtils.itemId(link);
        long nextLink = this.write(pageId, this.rmvRow, itemId, FAIL_L);
        assert (nextLink != FAIL_L);
        while (nextLink != 0L) {
            this.memMetrics.decrementLargeEntriesPages();
            itemId = PageIdUtils.itemId(nextLink);
            pageId = PageIdUtils.pageId(nextLink);
            nextLink = this.write(pageId, this.rmvRow, itemId, FAIL_L);
            assert (nextLink != FAIL_L);
        }
    }

    @Override
    protected PagesList.Stripe[] getBucket(int bucket) {
        return this.buckets.get(bucket);
    }

    @Override
    protected boolean casBucket(int bucket, PagesList.Stripe[] exp, PagesList.Stripe[] upd) {
        return this.buckets.compareAndSet(bucket, exp, upd);
    }

    @Override
    protected boolean isReuseBucket(int bucket) {
        return bucket == 255;
    }

    public int emptyDataPages() {
        return this.bucketsSize[this.emptyDataPagesBucket].intValue();
    }

    @Override
    public void addForRecycle(ReuseBag bag) throws IgniteCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        this.put(bag, 0L, 0L, 0L, 255);
    }

    @Override
    public long takeRecycledPage() throws IgniteCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        return this.takeEmptyPage(255, null);
    }

    @Override
    public long recycledPagesCount() throws IgniteCheckedException {
        assert (this.reuseList == this) : "not allowed to be a reuse list";
        return this.storedPagesCount(255);
    }

    public abstract IOVersions<? extends AbstractDataPageIO<T>> ioVersions();

    public String toString() {
        return "FreeList [name=" + this.name + ']';
    }

    private final class RemoveRowHandler
    extends PageHandler<Void, Long> {
        private final boolean maskPartId;

        RemoveRowHandler(boolean maskPartId) {
            this.maskPartId = maskPartId;
        }

        @Override
        public Long run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, Void ignored, int itemId) throws IgniteCheckedException {
            int newFreeSpace;
            AbstractDataPageIO io = (AbstractDataPageIO)iox;
            int oldFreeSpace = io.getFreeSpace(pageAddr);
            assert (oldFreeSpace >= 0) : oldFreeSpace;
            long nextLink = io.removeRow(pageAddr, itemId, AbstractFreeList.this.pageSize());
            if (AbstractFreeList.this.needWalDeltaRecord(pageId, page, walPlc)) {
                AbstractFreeList.this.wal.log(new DataPageRemoveRecord(cacheId, pageId, itemId));
            }
            if ((newFreeSpace = io.getFreeSpace(pageAddr)) > 8) {
                int newBucket = AbstractFreeList.this.bucket(newFreeSpace, false);
                if (oldFreeSpace > 8) {
                    int oldBucket = AbstractFreeList.this.bucket(oldFreeSpace, false);
                    if (oldBucket != newBucket) {
                        long l = pageId = this.maskPartId ? PageIdUtils.maskPartitionId(pageId) : pageId;
                        if (AbstractFreeList.this.removeDataPage(pageId, page, pageAddr, io, oldBucket)) {
                            AbstractFreeList.this.put(null, pageId, page, pageAddr, newBucket);
                        }
                    }
                } else {
                    AbstractFreeList.this.put(null, pageId, page, pageAddr, newBucket);
                }
                if (io.isEmpty(pageAddr)) {
                    AbstractFreeList.this.evictionTracker.forgetPage(pageId);
                }
            }
            return nextLink;
        }
    }

    private final class WriteRowHandler
    extends PageHandler<T, Integer> {
        private WriteRowHandler() {
        }

        @Override
        public Integer run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, T row, int written) throws IgniteCheckedException {
            AbstractDataPageIO io = (AbstractDataPageIO)iox;
            int rowSize = io.getRowSize(row);
            int oldFreeSpace = io.getFreeSpace(pageAddr);
            assert (oldFreeSpace > 0) : oldFreeSpace;
            written = written == 0 && oldFreeSpace >= rowSize ? this.addRow(pageId, page, pageAddr, io, row, rowSize) : this.addRowFragment(pageId, page, pageAddr, io, row, written, rowSize);
            int newFreeSpace = io.getFreeSpace(pageAddr);
            if (newFreeSpace > 8) {
                int bucket = AbstractFreeList.this.bucket(newFreeSpace, false);
                AbstractFreeList.this.put(null, pageId, page, pageAddr, bucket);
            }
            if (written == rowSize) {
                AbstractFreeList.this.evictionTracker.touchPage(pageId);
            }
            return written == rowSize ? COMPLETE : written;
        }

        private int addRow(long pageId, long page, long pageAddr, AbstractDataPageIO<T> io, T row, int rowSize) throws IgniteCheckedException {
            io.addRow(pageId, pageAddr, row, rowSize, AbstractFreeList.this.pageSize());
            if (AbstractFreeList.this.needWalDeltaRecord(pageId, page, null)) {
                byte[] payload = new byte[rowSize];
                DataPagePayload data = io.readPayload(pageAddr, PageIdUtils.itemId(row.link()), AbstractFreeList.this.pageSize());
                assert (data.payloadSize() == rowSize);
                PageUtils.getBytes(pageAddr, data.offset(), payload, 0, rowSize);
                AbstractFreeList.this.wal.log(new DataPageInsertRecord(AbstractFreeList.this.grpId, pageId, payload));
            }
            return rowSize;
        }

        private int addRowFragment(long pageId, long page, long pageAddr, AbstractDataPageIO<T> io, T row, int written, int rowSize) throws IgniteCheckedException {
            long lastLink = row.link();
            int payloadSize = io.addRowFragment(AbstractFreeList.this.pageMem, pageAddr, row, written, rowSize, AbstractFreeList.this.pageSize());
            assert (payloadSize > 0) : payloadSize;
            if (AbstractFreeList.this.needWalDeltaRecord(pageId, page, null)) {
                byte[] payload = new byte[payloadSize];
                DataPagePayload data = io.readPayload(pageAddr, PageIdUtils.itemId(row.link()), AbstractFreeList.this.pageSize());
                PageUtils.getBytes(pageAddr, data.offset(), payload, 0, payloadSize);
                AbstractFreeList.this.wal.log(new DataPageInsertFragmentRecord(AbstractFreeList.this.grpId, pageId, payload, lastLink));
            }
            return written + payloadSize;
        }
    }

    private final class UpdateRowHandler
    extends PageHandler<T, Boolean> {
        private UpdateRowHandler() {
        }

        @Override
        public Boolean run(int cacheId, long pageId, long page, long pageAddr, PageIO iox, Boolean walPlc, T row, int itemId) throws IgniteCheckedException {
            AbstractDataPageIO io = (AbstractDataPageIO)iox;
            int rowSize = io.getRowSize(row);
            boolean updated = io.updateRow(pageAddr, itemId, AbstractFreeList.this.pageSize(), null, row, rowSize);
            AbstractFreeList.this.evictionTracker.touchPage(pageId);
            if (updated && AbstractFreeList.this.needWalDeltaRecord(pageId, page, walPlc)) {
                byte[] payload = new byte[rowSize];
                DataPagePayload data = io.readPayload(pageAddr, itemId, AbstractFreeList.this.pageSize());
                assert (data.payloadSize() == rowSize);
                PageUtils.getBytes(pageAddr, data.offset(), payload, 0, rowSize);
                AbstractFreeList.this.wal.log(new DataPageUpdateRecord(cacheId, pageId, itemId, payload));
            }
            return updated;
        }
    }
}

