/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.configuration;

import java.util.BitSet;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CommunicationFailureContext;
import org.apache.ignite.configuration.CommunicationFailureResolver;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;

public class DefaultCommunicationFailureResolver
implements CommunicationFailureResolver {
    @LoggerResource
    private IgniteLogger log;

    @Override
    public void resolve(CommunicationFailureContext ctx) {
        ClusterGraph graph = new ClusterGraph(this.log, ctx);
        ClusterSearch cluster = graph.findLargestIndependentCluster();
        List<ClusterNode> nodes = ctx.topologySnapshot();
        assert (nodes.size() > 0);
        assert (cluster != null);
        if (graph.checkFullyConnected(cluster.nodesBitSet)) {
            assert (cluster.nodeCnt <= nodes.size());
            if (cluster.nodeCnt < nodes.size()) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Communication problem resolver found fully connected independent cluster [clusterSrvCnt=" + cluster.srvCnt + ", clusterTotalNodes=" + cluster.nodeCnt + ", totalAliveNodes=" + nodes.size() + "]");
                }
                for (int i = 0; i < nodes.size(); ++i) {
                    if (cluster.nodesBitSet.get(i)) continue;
                    ctx.killNode(nodes.get(i));
                }
            } else {
                U.warn(this.log, "All alive nodes are fully connected, this should be resolved automatically.");
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Communication problem resolver failed to find fully connected independent cluster.");
        }
    }

    private static String clusterNodeIds(BitSet cluster, List<ClusterNode> nodes, int limit) {
        int idx;
        int startIdx = 0;
        StringBuilder builder = new StringBuilder();
        int cnt = 0;
        while ((idx = cluster.nextSetBit(startIdx)) != -1) {
            startIdx = idx + 1;
            if (builder.length() == 0) {
                builder.append('[');
            } else {
                builder.append(", ");
            }
            builder.append(nodes.get(idx).id());
            if (cnt++ <= limit) continue;
            builder.append(", ...");
        }
        builder.append(']');
        return builder.toString();
    }

    public String toString() {
        return S.toString(DefaultCommunicationFailureResolver.class, this);
    }

    private static class ClusterGraph {
        private static final int WORD_IDX_SHIFT = 6;
        private final IgniteLogger log;
        private final int nodeCnt;
        private final long[] visitBitSet;
        private final CommunicationFailureContext ctx;
        private final List<ClusterNode> nodes;

        ClusterGraph(IgniteLogger log, CommunicationFailureContext ctx) {
            this.log = log;
            this.ctx = ctx;
            this.nodes = ctx.topologySnapshot();
            this.nodeCnt = this.nodes.size();
            assert (this.nodeCnt > 0);
            this.visitBitSet = ClusterGraph.initBitSet(this.nodeCnt);
        }

        private static int wordIndex(int bitIndex) {
            return bitIndex >> 6;
        }

        static long[] initBitSet(int bitCnt) {
            return new long[ClusterGraph.wordIndex(bitCnt - 1) + 1];
        }

        ClusterSearch findLargestIndependentCluster() {
            ClusterSearch maxCluster = null;
            for (int i = 0; i < this.nodeCnt; ++i) {
                if (ClusterGraph.getBit(this.visitBitSet, i)) continue;
                ClusterSearch cluster = new ClusterSearch(this.nodeCnt);
                this.search(cluster, i);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Communication problem resolver found cluster [srvCnt=" + cluster.srvCnt + ", totalNodeCnt=" + cluster.nodeCnt + ", nodeIds=" + DefaultCommunicationFailureResolver.clusterNodeIds(cluster.nodesBitSet, this.nodes, 1000) + "]");
                }
                if (maxCluster != null && cluster.srvCnt <= maxCluster.srvCnt) continue;
                maxCluster = cluster;
            }
            return maxCluster;
        }

        boolean checkFullyConnected(BitSet cluster) {
            int idx;
            int startIdx = 0;
            int clusterNodes = cluster.cardinality();
            while ((idx = cluster.nextSetBit(startIdx)) != -1) {
                ClusterNode node1 = this.nodes.get(idx);
                for (int i = 0; i < clusterNodes; ++i) {
                    if (!cluster.get(i) || i == idx) continue;
                    ClusterNode node2 = this.nodes.get(i);
                    if (!cluster.get(i) || this.ctx.connectionAvailable(node1, node2)) continue;
                    return false;
                }
                startIdx = idx + 1;
            }
            return true;
        }

        void search(ClusterSearch cluster, int idx) {
            assert (!ClusterGraph.getBit(this.visitBitSet, idx));
            ClusterGraph.setBit(this.visitBitSet, idx);
            cluster.nodesBitSet.set(idx);
            ++cluster.nodeCnt;
            ClusterNode node1 = this.nodes.get(idx);
            if (!CU.clientNode(node1)) {
                ++cluster.srvCnt;
            }
            for (int i = 0; i < this.nodeCnt; ++i) {
                boolean connected;
                if (i == idx || ClusterGraph.getBit(this.visitBitSet, i)) continue;
                ClusterNode node2 = this.nodes.get(i);
                boolean bl = connected = this.ctx.connectionAvailable(node1, node2) || this.ctx.connectionAvailable(node2, node1);
                if (!connected) continue;
                this.search(cluster, i);
            }
        }

        static void setBit(long[] words, int bitIndex) {
            int wordIndex;
            int n = wordIndex = ClusterGraph.wordIndex(bitIndex);
            words[n] = words[n] | 1L << bitIndex;
        }

        static boolean getBit(long[] words, int bitIndex) {
            int wordIndex = ClusterGraph.wordIndex(bitIndex);
            return (words[wordIndex] & 1L << bitIndex) != 0L;
        }
    }

    private static class ClusterSearch {
        int srvCnt;
        int nodeCnt;
        final BitSet nodesBitSet;

        ClusterSearch(int nodes) {
            this.nodesBitSet = new BitSet(nodes);
        }
    }
}

