/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.split;

import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import java.util.List;

public class SplitAlgorithm {
    private static SplitAlgorithm instance = new SplitAlgorithm();

    public static SplitAlgorithm Instance() {
        return instance;
    }

    private SplitAlgorithm() {
    }

    private boolean DataError(List<Double> estimateValue, double energy, List resultValue) {
        boolean has_null = false;
        for (int i = 0; i < estimateValue.size(); ++i) {
            Double estimate = estimateValue.get(i);
            if (estimate != null) continue;
            has_null = true;
            break;
        }
        if (has_null) {
            double value = energy / (double)estimateValue.size();
            for (int i = 0; i < estimateValue.size(); ++i) {
                Object onedata = resultValue.get(i);
                ((DoubleTimeObject)onedata).data_value = value;
            }
            return true;
        }
        double totalEstimateValue = 0.0;
        for (int i = 0; i < estimateValue.size(); ++i) {
            totalEstimateValue += estimateValue.get(i).doubleValue();
        }
        if (totalEstimateValue == 0.0) {
            double value = energy / (double)estimateValue.size();
            for (int i = 0; i < estimateValue.size(); ++i) {
                Object onedata = resultValue.get(i);
                ((DoubleTimeObject)onedata).data_value = value;
            }
            return true;
        }
        return false;
    }

    public void Solve(List<Double> estimateValue, List<Double> uncertainty, double energy, List resultValue) {
        int i;
        if (this.DataError(estimateValue, energy, resultValue)) {
            return;
        }
        double Sj2 = 0.0;
        double Xj = 0.0;
        for (i = 0; i < estimateValue.size(); ++i) {
            Sj2 += uncertainty.get(i) * uncertainty.get(i);
            Xj += estimateValue.get(i).doubleValue();
        }
        if (Sj2 < 1.0E-6) {
            this.SolveByRatio(estimateValue, energy, resultValue);
        } else {
            for (i = 0; i < estimateValue.size(); ++i) {
                Object onedata = resultValue.get(i);
                double value = estimateValue.get(i) + (energy - Xj) * (uncertainty.get(i) * uncertainty.get(i)) / Sj2;
                ((DoubleTimeObject)onedata).data_value = value;
            }
            boolean negativeNo = true;
            for (int i2 = 0; i2 < estimateValue.size(); ++i2) {
                Object onedata = resultValue.get(i2);
                double datavalue = ((DoubleTimeObject)onedata).data_value;
                if (!(datavalue < 0.0)) continue;
                negativeNo = false;
                break;
            }
            if (!negativeNo) {
                this.SolveByRatio(estimateValue, energy, resultValue);
            }
        }
        double resultTotal = 0.0;
        for (int i3 = 0; i3 < estimateValue.size(); ++i3) {
            Object onedata = resultValue.get(i3);
            double datavalue = ((DoubleTimeObject)onedata).data_value;
            resultTotal += datavalue;
        }
        double chazhi = Math.abs(resultTotal - energy);
        if (chazhi > 1.0E-6) {
            double shareValue = (energy - resultTotal) / (double)estimateValue.size();
            for (int i4 = 0; i4 < estimateValue.size(); ++i4) {
                Object onedata = resultValue.get(i4);
                ((DoubleTimeObject)onedata).data_value = shareValue;
            }
        }
    }

    public void SolveByRatio(List<Double> estimateValue, double energy, List resultValue) {
        int i;
        if (this.DataError(estimateValue, energy, resultValue)) {
            return;
        }
        double totalEstimateValue = 0.0;
        for (i = 0; i < estimateValue.size(); ++i) {
            totalEstimateValue += estimateValue.get(i).doubleValue();
        }
        for (i = 0; i < estimateValue.size(); ++i) {
            double value = energy * estimateValue.get(i) / totalEstimateValue;
            Object onedata = resultValue.get(i);
            ((DoubleTimeObject)onedata).data_value = value;
        }
    }
}

