/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.util.Configuration_MySQL;
import com.zillion.database.util.DatabaseImpl_HBase;
import com.zillion.database.util.DatabaseImpl_Mix;
import com.zillion.database.util.DatabaseImpl_MySQL;
import com.zillion.database.util.IDatabase;
import com.zillion.util.common.HashObject;
import com.zillion.util.table.SchemaParser;
import com.zillion.util.table.SchemaRepository;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaRepositoryThread;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import com.zillion.util.zk.ZKLockRW;
import com.zillion.util.zk.ZKWrapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.zillion.util.common.MyException;
import org.zillion.util.json.FastJsonReaderUtil;
import org.zillion.util.log.LogUtil;

public class SchemaRepositoryHelper {
    String full_name;

    public SchemaRepositoryHelper(String full_name) {
        this.full_name = full_name;
    }

    public void Initialize(SchemaRepositoryContainer container, String database_type, Configuration configuration, Configuration configuration_bak, Configuration_MySQL configuration_MySQL, boolean print, boolean observer) throws Exception {
        ZKWrapper ZK;
        String zookeeper_connectionAddress = null;
        int zookeeper_sessionTimeout = 30000;
        if (database_type.equals("HBase")) {
            zookeeper_connectionAddress = configuration.get("hbase.zookeeper.quorum");
            zookeeper_sessionTimeout = configuration.getInt("zookeeper.session.timeout", 30000);
            container.DatabaseImpl = new DatabaseImpl_HBase(configuration, configuration_bak);
            container.DatabaseImpl.Start();
        } else if (database_type.equals("MySQL")) {
            zookeeper_connectionAddress = configuration_MySQL.zookeeper_connectionAddress;
            zookeeper_sessionTimeout = configuration_MySQL.zookeeper_sessionTimeout;
            container.DatabaseImpl = new DatabaseImpl_MySQL(configuration_MySQL);
            container.DatabaseImpl.Start();
        } else if (database_type.equals("Mix")) {
            zookeeper_connectionAddress = configuration.get("hbase.zookeeper.quorum");
            zookeeper_sessionTimeout = configuration.getInt("zookeeper.session.timeout", 30000);
            container.DatabaseImpl = new DatabaseImpl_Mix(configuration, configuration_bak, configuration_MySQL, container);
            container.DatabaseImpl.Start();
        } else {
            throw new MyException("Database type error:" + database_type);
        }
        LogUtil.warn(" ********************************** SchemaRepository Initialize\tbegin");
        if ((database_type.equals("HBase") || database_type.equals("Mix")) && configuration.get("kerberos.principal") != null && configuration.get("keytab.file") != null) {
            String jaas_conf_path = configuration.get("zillion.jaas.conf");
            String krb5_conf_path = configuration.get("zillion.krb5.conf");
            ZK = new ZKWrapper(zookeeper_connectionAddress, zookeeper_sessionTimeout, jaas_conf_path, krb5_conf_path);
        } else {
            ZK = new ZKWrapper(zookeeper_connectionAddress, zookeeper_sessionTimeout);
        }
        Stat stat = ZK.exists("/zillion", false);
        if (stat == null) {
            try {
                ZK.create("/zillion", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
            }
            catch (Exception krb5_conf_path) {
                // empty catch block
            }
        }
        String status = "begin";
        while (true) {
            Thread.sleep(1L);
            if (status.equals("begin")) {
                stat = ZK.exists("/zillion/initbegin", false);
                if (stat != null) {
                    status = "check_begin_Y";
                    continue;
                }
                status = "check_begin_N";
                continue;
            }
            if (status.equals("check_begin_Y")) {
                stat = ZK.exists("/zillion/initend", false);
                if (stat != null) {
                    status = "check_end_Y";
                    continue;
                }
                status = "check_end_N";
                continue;
            }
            if (status.equals("check_begin_N")) {
                try {
                    ZK.create("/zillion/initbegin", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                    status = "process";
                }
                catch (Exception e) {
                    status = "begin";
                }
                continue;
            }
            if (status.equals("check_end_Y")) {
                status = "ready";
                continue;
            }
            if (status.equals("check_end_N")) {
                status = "check_begin_Y";
                continue;
            }
            if (status.equals("process")) {
                ZK.create("/zillion/ns", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                ZK.create("/zillion/nslock", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                List<String> namespaceList = container.DatabaseImpl.ori_namespaceList();
                for (String namespace : namespaceList) {
                    this.InitializeNamespace(ZK, container.DatabaseImpl, namespace);
                }
                ZK.create("/zillion/initend", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                status = "ready";
                continue;
            }
            if (status.equals("ready")) break;
        }
        container.repositoryMap = new HashMap<String, SchemaRepository>();
        container.ZK = ZK;
        this.ReadMeta(container, print, observer);
        SchemaRepositoryThread thread = new SchemaRepositoryThread(container, print, observer, this);
        thread.start();
        container.thread = thread;
        container.initialized = true;
        LogUtil.warn(" ********************************** SchemaRepository Initialize\tend");
    }

    public void InitializeNamespace(ZKWrapper ZK, IDatabase DatabaseImpl, String namespace) throws Exception {
        String method_name = "InitializeNamespace";
        if (!DatabaseImpl.ori_tableExists(namespace, "zillion_meta_data") || !DatabaseImpl.ori_tableExists(namespace, "zillion_meta_index")) {
            return;
        }
        ArrayList<String> tableNameList = new ArrayList<String>();
        ArrayList<String> tableContentList = new ArrayList<String>();
        ArrayList<HashObject> tableHashList = new ArrayList<HashObject>();
        ArrayList<String> indexNameList = new ArrayList<String>();
        ArrayList<String> indexContentList = new ArrayList<String>();
        ArrayList<HashObject> indexHashList = new ArrayList<HashObject>();
        ArrayList<String> splitNameList = new ArrayList<String>();
        ArrayList<HashObject> splitHashList = new ArrayList<HashObject>();
        DatabaseImpl.meta_read(namespace, tableNameList, tableContentList, tableHashList, indexNameList, indexContentList, indexHashList, splitNameList, splitHashList);
        String zkpath_namespace = "/zillion/ns/" + namespace;
        ZK.create(zkpath_namespace, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
        ZK.create(String.valueOf(zkpath_namespace) + "/metalock", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
        String parent_path_meta = String.valueOf(zkpath_namespace) + "/metalock";
        String lock_type_meta = "w";
        String node_path_meta = ZKLockRW.Create(ZK, parent_path_meta, lock_type_meta, this.full_name);
        LogUtil.info(" ********************************** " + method_name + " metalock:" + " begin " + node_path_meta);
        try {
            String tableName;
            ZK.create(String.valueOf(zkpath_namespace) + "/meta_data", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
            ZK.create(String.valueOf(zkpath_namespace) + "/meta_index", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
            ZK.create(String.valueOf(zkpath_namespace) + "/tablelocks", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
            ZK.create(String.valueOf(zkpath_namespace) + "/hash_exist", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
            ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
            ZK.create(String.valueOf(zkpath_namespace) + "/hashlocks", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
            int i = 0;
            while (i < tableNameList.size()) {
                String tableName2 = (String)tableNameList.get(i);
                String content = (String)tableContentList.get(i);
                HashObject hashObject = (HashObject)tableHashList.get(i);
                byte[] hash = hashObject.toBytes();
                ZK.create(String.valueOf(zkpath_namespace) + "/meta_data" + "/" + tableName2, content.getBytes("UTF-8"), CreateMode.PERSISTENT);
                ZK.create(String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName2, "c".getBytes("UTF-8"), CreateMode.PERSISTENT);
                ZK.create(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName2, hash, CreateMode.PERSISTENT);
                ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName2, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                ZK.create(String.valueOf(zkpath_namespace) + "/hashlocks" + "/" + tableName2, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                ++i;
            }
            i = 0;
            while (i < indexNameList.size()) {
                String name = (String)indexNameList.get(i);
                String[] splits = name.split("\\.");
                tableName = splits[0];
                String indexName = splits[1];
                String content = (String)indexContentList.get(i);
                HashObject hashObject = (HashObject)indexHashList.get(i);
                byte[] hash = hashObject.toBytes();
                ZK.create(String.valueOf(zkpath_namespace) + "/meta_index" + "/" + tableName + "." + indexName, content.getBytes("UTF-8"), CreateMode.PERSISTENT);
                ZK.create(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, hash, CreateMode.PERSISTENT);
                ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "." + indexName, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                ++i;
            }
            i = 0;
            while (i < splitNameList.size()) {
                int index_;
                String splitName = (String)splitNameList.get(i);
                tableName = splitName.substring(0, index_ = splitName.lastIndexOf(95));
                if (!tableName.startsWith("zillion_data_")) {
                    String child_name = splitName.substring(index_ + 1);
                    HashObject hashObject = (HashObject)splitHashList.get(i);
                    byte[] hash = hashObject.toBytes();
                    ZK.create(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "/" + child_name, hash, CreateMode.PERSISTENT);
                    ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + tableName + "/" + child_name, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                }
                ++i;
            }
            ZK.create(String.valueOf(zkpath_namespace) + "/observer", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
        }
        finally {
            ZKLockRW.Finish(ZK, node_path_meta);
            LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
        }
    }

    public void ReadMeta(SchemaRepositoryContainer container, boolean print, boolean observer) throws Exception {
        Stat stat = container.ZK.exists("/zillion/initend", false);
        if (stat == null) {
            return;
        }
        List<String> children = container.ZK.getChildren("/zillion/ns", false);
        List<String> namespaceList = container.namespaceList = children;
        for (String namespace : namespaceList) {
            SchemaRepository repository;
            if (container.repositoryMap.containsKey(namespace)) {
                repository = container.repositoryMap.get(namespace);
            } else {
                repository = new SchemaRepository();
                repository.namespace = namespace;
                container.repositoryMap.put(namespace, repository);
            }
            this.ReadMetaNamespace(container, namespace, repository, print, observer);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ReadMetaNamespace(SchemaRepositoryContainer container, String namespace, SchemaRepository repository, boolean print, boolean observer) throws Exception {
        String method_name = String.valueOf(this.full_name) + "\t" + "ReadMetaNamespace" + "\t" + namespace;
        String zkpath_namespace = "/zillion/ns/" + namespace;
        Stat stat = new Stat();
        container.ZK.getData(String.valueOf(zkpath_namespace) + "/tablelocks", false, stat);
        int repo_version = stat.getVersion();
        int exist_repo_version = repository.GetVersion();
        if (exist_repo_version != repo_version) {
            if (container.without_lock) {
                this.ReadMetaNamespace_without_lock(container, namespace, repository, print);
                return false;
            }
            String parent_path_meta = String.valueOf(zkpath_namespace) + "/metalock";
            String lock_type_meta = "r";
            String node_path_meta = ZKLockRW.Create(container.ZK, parent_path_meta, lock_type_meta, this.full_name);
            if (print) {
                LogUtil.debug(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
            }
            try {
                boolean wait_success = ZKLockRW.WaitOnce(container.ZK, parent_path_meta, node_path_meta);
                if (print) {
                    LogUtil.debug(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                }
                if (!wait_success) {
                    return false;
                }
                this.ReadMetaNamespace_without_lock(container, namespace, repository, print);
                if (print) {
                    LogUtil.info(" ********************************** " + method_name + " work success ");
                }
                if (!observer) return true;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String observer_content = repository.GetVersion() + "_" + sdf.format(new Date()) + "_" + this.full_name;
                if (repository.node_path == null) {
                    repository.node_path = container.ZK.create(String.valueOf(zkpath_namespace) + "/observer" + "/" + "observer", observer_content.getBytes("UTF-8"), CreateMode.EPHEMERAL_SEQUENTIAL);
                    if (!print) return true;
                    LogUtil.info(" ********************************** " + method_name + " " + zkpath_namespace + "/observer" + " create data " + repository.GetVersion());
                    return true;
                }
                container.ZK.setData(repository.node_path, observer_content.getBytes("UTF-8"), -1);
                if (!print) return true;
                LogUtil.info(" ********************************** " + method_name + " " + zkpath_namespace + "/observer" + " update data " + repository.GetVersion());
                return true;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                ZKLockRW.Finish(container.ZK, node_path_meta);
                if (print) {
                    LogUtil.debug(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
                }
            }
        }
        for (String tableName : repository.TableList()) {
            ZillionTableSchema schema = repository.GetTable(tableName);
            schema.timeout_unuse(container);
            schema.RefreshTableWrapper(container);
        }
        return false;
    }

    private void ReadMetaNamespace_without_lock(SchemaRepositoryContainer container, String namespace, SchemaRepository repository, boolean print) throws Exception {
        String method_name = String.valueOf(this.full_name) + "\t" + "ReadMetaNamespace" + "\t" + namespace;
        String zkpath_namespace = "/zillion/ns/" + namespace;
        Stat stat = new Stat();
        HashMap<String, Boolean> validMap = new HashMap<String, Boolean>();
        List<String> indexFullNameList = container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/meta_index", false);
        List<String> tableNameList = container.ZK.getChildren(String.valueOf(zkpath_namespace) + "/tablelocks", false);
        for (String tableName : tableNameList) {
            String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + tableName;
            stat = new Stat();
            byte[] data_bytes = container.ZK.getData(parent_path_table, false, stat);
            int table_version = stat.getVersion();
            String data_String = new String(data_bytes, "UTF-8");
            if (!data_String.equals("c")) continue;
            validMap.put(tableName, true);
            ZillionTableSchema exist_schema = repository.GetTable(tableName);
            if (exist_schema != null && exist_schema.version == table_version) continue;
            if (print) {
                LogUtil.info(" ********************************** " + method_name + " work read " + tableName);
            }
            stat = new Stat();
            data_bytes = container.ZK.getData(String.valueOf(zkpath_namespace) + "/meta_data" + "/" + tableName, false, stat);
            JSONObject content = (JSONObject)FastJsonReaderUtil.Instance().parse(new String(data_bytes, "UTF-8"));
            ZillionTableSchema schema = new ZillionTableSchema(namespace, tableName);
            schema.JSON = content;
            schema.version = table_version;
            SchemaParser.ParseTableSchema(schema, content);
            for (String indexFullName : indexFullNameList) {
                if (!indexFullName.startsWith(String.valueOf(tableName) + ".")) continue;
                Stat statInner = new Stat();
                byte[] data_bytesInner = container.ZK.getData(String.valueOf(zkpath_namespace) + "/meta_index" + "/" + indexFullName, false, statInner);
                JSONArray index_Columns = (JSONArray)FastJsonReaderUtil.Instance().parse(new String(data_bytesInner, "UTF-8"));
                ZillionTableIndex table_index = new ZillionTableIndex(schema, indexFullName.substring(tableName.length() + 1));
                SchemaParser.ParseIndexSchema(table_index, schema, index_Columns);
                schema.AddIndex(table_index);
            }
            if (exist_schema != null) {
                repository.DropTable(tableName);
                exist_schema.unuseTable(container.ZK);
            }
            repository.AddTable(schema);
            repository.SetTableVersion(tableName, table_version);
        }
        List<String> tableList = repository.TableList();
        for (String tableName : tableList) {
            if (validMap.containsKey(tableName)) continue;
            ZillionTableSchema schema = repository.DropTable(tableName);
            schema.unuseTable(container.ZK);
        }
        stat = new Stat();
        container.ZK.getData(String.valueOf(zkpath_namespace) + "/tablelocks", false, stat);
        repository.SetVersion(stat.getVersion());
    }
}

