/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.coprocessor;

import com.zillion.util.common.ByteToObject;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.zk.ZKWrapper;
import java.util.Iterator;
import java.util.List;
import org.apache.zookeeper.data.Stat;

public class ObserverCheck {
    public static void Wait(ZKWrapper zookeeper, String namespace, int repo_version) {
        block6: {
            block5: {
                if (!ZillionConstant.ObserverCheck) break block5;
                while (!ObserverCheck.Check(zookeeper, namespace, repo_version)) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block6;
            }
            if (ZillionConstant.ObserverWait <= 0L) break block6;
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean Check(ZKWrapper zookeeper, String namespace, int repo_version) {
        String zkpath_namespace = "/zillion/ns/" + namespace;
        try {
            String version_string;
            Stat stat = zookeeper.exists(String.valueOf(zkpath_namespace) + "/observer", false);
            if (stat == null) {
                return true;
            }
            List<String> childList = zookeeper.getChildren(String.valueOf(zkpath_namespace) + "/observer", false);
            Iterator<String> iterator = childList.iterator();
            do {
                String data_string;
                if (!iterator.hasNext()) {
                    return true;
                }
                String child = iterator.next();
                byte[] data = zookeeper.getData(String.valueOf(zkpath_namespace) + "/observer" + "/" + child, false, null);
                version_string = data_string = ByteToObject.toString(data);
                int index = data_string.indexOf("_");
                if (index == -1) continue;
                version_string = data_string.substring(0, index);
            } while (Integer.parseInt(version_string) >= repo_version);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

