/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.agent;

import com.alibaba.fastjson.JSONObject;
import com.zillion.database.agent.ZillionHashWorker;
import com.zillion.database.agent.ZillionHashWorkerItem;
import com.zillion.database.async.AsyncUtil;
import com.zillion.database.util.DatabaseImpl_HBase;
import com.zillion.database.util.DatabaseImpl_Mix;
import com.zillion.database.util.TableWrapper_HBase;
import com.zillion.util.common.ByteToObject;
import com.zillion.util.common.HashObject;
import com.zillion.util.common.HashUtil;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.table.HBaseAdminUtil;
import com.zillion.util.table.HTableUtil;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaWrapper;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;

public class ZillionHashWorkerThread
extends Thread {
    ZillionHashWorker worker;

    public ZillionHashWorkerThread(ZillionHashWorker worker) {
        this.worker = worker;
    }

    @Override
    public void run() {
        ZillionHashWorkerItem workItem;
        while ((workItem = this.worker.Pop()) != null) {
            try {
                if (this.worker.work_type.equals("RefreshHash")) {
                    if (workItem.schema_index != null) {
                        this.Process_index(this.worker.container, this.worker.schema, workItem.schema_index, workItem);
                        continue;
                    }
                    this.Process_table(this.worker.container, this.worker.schema, new ArrayList<ZillionTableIndex>(), workItem);
                    continue;
                }
                this.Process_table(this.worker.container, this.worker.schema, this.worker.schema_indexList, workItem);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void Process_table(SchemaRepositoryContainer container, ZillionTableSchema schema, List<ZillionTableIndex> schema_indexList, ZillionHashWorkerItem workItem) throws Exception {
        ZillionTableIndex schema_index;
        Result res;
        DatabaseImpl_HBase databaseImpl = container.DatabaseImpl instanceof DatabaseImpl_HBase ? (DatabaseImpl_HBase)container.DatabaseImpl : ((DatabaseImpl_Mix)container.DatabaseImpl).hbase;
        String namespace = schema.Namespace;
        String zkpath_namespace = "/zillion/ns/" + namespace;
        String tableName = schema.table_name;
        SchemaWrapper schemaWrapper = workItem.schemaWrapper;
        if (this.worker.work_type.equals("RepairIndex")) {
            int index_index = 0;
            while (index_index < schema_indexList.size()) {
                ZillionTableIndex schema_index2 = schema_indexList.get(index_index);
                if (schema.table_type.startsWith("split_")) {
                    HBaseAdminUtil.clearTable(databaseImpl.admin, databaseImpl.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_index_" + schema.table_name + "." + schema_index2.index_name + "_" + schemaWrapper.child_name)));
                } else {
                    HBaseAdminUtil.clearTable(databaseImpl.admin, databaseImpl.admin_bak, TableName.valueOf((String)namespace, (String)("zillion_index_" + schema.table_name + "." + schema_index2.index_name)));
                }
                ++index_index;
            }
        }
        HashObject resultInner = new HashObject();
        long count_wait_tmp = 0L;
        Scan scan = new Scan();
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"));
        if (this.worker.work_type.equals("AddIndex") || this.worker.work_type.equals("RepairIndex")) {
            String[] stringArray = schema.OtherColumn;
            int n = schema.OtherColumn.length;
            int n2 = 0;
            while (n2 < n) {
                String column_name = stringArray[n2];
                scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name));
                ++n2;
            }
        }
        TableWrapper_HBase table_wrapper = (TableWrapper_HBase)schemaWrapper.dataWrapper;
        ResultScanner scanner = table_wrapper.htable.getScanner(scan);
        ArrayList batchList = new ArrayList();
        int index_index = 0;
        while (index_index < schema_indexList.size()) {
            batchList.add(new ArrayList());
            ++index_index;
        }
        while ((res = scanner.next()) != null) {
            if (!HTableUtil.valid(schema, res.listCells())) continue;
            byte[] row_key_bytes = res.getRow();
            ++resultInner.insert_count;
            resultInner.hash_code = HashUtil.merge_hash_code(resultInner.hash_code, row_key_bytes);
            if (++count_wait_tmp >= AsyncUtil.count_wait) {
                this.worker.asyncJob.Add(count_wait_tmp);
                count_wait_tmp = 0L;
            }
            if (!this.worker.work_type.equals("AddIndex") && !this.worker.work_type.equals("RepairIndex")) continue;
            JSONObject InsertObject = HTableUtil.Convert(schema, res.getRow(), res.listCells());
            HashMap<String, byte[]> columnBytesMap = new HashMap<String, byte[]>();
            for (String column_name : schema.ColumnMap.keySet()) {
                ZillionTableColumn column = schema.ColumnMap.get(column_name);
                if (!InsertObject.containsKey((Object)column_name)) continue;
                Object columnObject = InsertObject.get((Object)column_name);
                byte[] column_bytes = HTableUtil.GenerateBytes(column, columnObject);
                columnBytesMap.put(column_name, column_bytes);
            }
            int index_index2 = 0;
            while (index_index2 < schema_indexList.size()) {
                ZillionTableIndex schema_index3 = schema_indexList.get(index_index2);
                TableWrapper_HBase table_index = null;
                int index_ = 0;
                while (index_ < schema.Indexes.size()) {
                    ZillionTableIndex zti = schema.Indexes.get(index_);
                    if (zti.index_name.equals(schema_index3.index_name)) {
                        table_index = (TableWrapper_HBase)schemaWrapper.indexWrapperList.get(index_);
                        break;
                    }
                    ++index_;
                }
                List batch = (List)batchList.get(index_index2);
                byte[] index_row_bytes = HTableUtil.BuildKey(schema.ColumnMap, schema_index3.Key, columnBytesMap);
                Put put_index = new Put(index_row_bytes);
                put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"), ByteToObject.toBytes("1"));
                put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("u"), ByteToObject.toBytes("1"));
                if (schema.table_type != null) {
                    if (schema.table_type.equals("index_data") || schema.table_type.startsWith("split_")) {
                        int ii = 0;
                        while (ii < schema.OtherColumn.length) {
                            String column_name = schema.OtherColumn[ii];
                            if (!schema_index3.KeyMap.containsKey(column_name) && columnBytesMap.containsKey(column_name)) {
                                byte[] column_bytes = (byte[])columnBytesMap.get(column_name);
                                put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), column_bytes);
                            }
                            ++ii;
                        }
                    } else if (schema.table_type.equals("all_column")) {
                        String[] Columns = schema.ColumnMap.keySet().toArray(new String[0]);
                        int ii = 0;
                        while (ii < Columns.length) {
                            String column_name = Columns[ii];
                            if (columnBytesMap.containsKey(column_name)) {
                                byte[] column_bytes = (byte[])columnBytesMap.get(column_name);
                                put_index.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes(column_name), column_bytes);
                            }
                            ++ii;
                        }
                    }
                }
                batch.add(put_index);
                if (batch.size() > 1000) {
                    table_index.htable.put(batch);
                    if (ZillionConstant.disable_AutoFlush) {
                        table_index.htable.flushCommits();
                    }
                    batch.clear();
                }
                ++index_index2;
            }
        }
        if (this.worker.work_type.equals("AddIndex") || this.worker.work_type.equals("RepairIndex")) {
            index_index = 0;
            while (index_index < schema_indexList.size()) {
                schema_index = schema_indexList.get(index_index);
                TableWrapper_HBase table_index = null;
                int index_ = 0;
                while (index_ < schema.Indexes.size()) {
                    ZillionTableIndex zti = schema.Indexes.get(index_);
                    if (zti.index_name.equals(schema_index.index_name)) {
                        table_index = (TableWrapper_HBase)schemaWrapper.indexWrapperList.get(index_);
                        break;
                    }
                    ++index_;
                }
                List batch = (List)batchList.get(index_index);
                if (batch.size() > 0) {
                    table_index.htable.put(batch);
                    if (ZillionConstant.disable_AutoFlush) {
                        table_index.htable.flushCommits();
                    }
                    batch.clear();
                }
                ++index_index;
            }
        }
        scanner.close();
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (count_wait_tmp > 0L) {
            this.worker.asyncJob.Add(count_wait_tmp);
            count_wait_tmp = 0L;
        }
        if (schema.table_type != null && schema.table_type.startsWith("split_")) {
            container.DatabaseImpl.meta_query_update_split_data(namespace, tableName, schemaWrapper.child_name, resultInner);
            byte[] hash = resultInner.toBytes();
            container.ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "/" + schemaWrapper.child_name, hash, -1);
        }
        if (this.worker.work_type.equals("AddIndex") || this.worker.work_type.equals("RepairIndex")) {
            index_index = 0;
            while (index_index < schema_indexList.size()) {
                schema_index = schema_indexList.get(index_index);
                String indexName = schema_index.index_name;
                if (schema.table_type != null && schema.table_type.startsWith("split_")) {
                    container.DatabaseImpl.meta_query_update_split_index(namespace, tableName, indexName, schemaWrapper.child_name, resultInner);
                    byte[] hash = resultInner.toBytes();
                    container.ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName + "/" + schemaWrapper.child_name, hash, -1);
                }
                ++index_index;
            }
        }
        workItem.hash = resultInner;
        workItem.finish = true;
    }

    private void Process_index(SchemaRepositoryContainer container, ZillionTableSchema schema, ZillionTableIndex schema_index, ZillionHashWorkerItem workItem) throws Exception {
        Result res;
        String namespace = schema.Namespace;
        String zkpath_namespace = "/zillion/ns/" + namespace;
        String tableName = schema.table_name;
        String indexName = schema_index.index_name;
        SchemaWrapper schemaWrapper = workItem.schemaWrapper;
        TableWrapper_HBase table_index = null;
        int index_ = 0;
        while (index_ < schema.Indexes.size()) {
            ZillionTableIndex index = schema.Indexes.get(index_);
            TableWrapper_HBase indexWrapper = (TableWrapper_HBase)schemaWrapper.indexWrapperList.get(index_);
            if (index.index_name.equals(schema_index.index_name)) {
                table_index = indexWrapper;
                break;
            }
            ++index_;
        }
        HashObject resultInner = new HashObject();
        Scan scan = new Scan();
        scan.addColumn(ByteToObject.toBytes("f"), ByteToObject.toBytes("v"));
        ResultScanner scanner = table_index.htable.getScanner(scan);
        while ((res = scanner.next()) != null) {
            byte[] row_bytes;
            if (!HTableUtil.valid(schema, res.listCells())) continue;
            byte[] row_bytes_index = res.getRow();
            if (schema.table_type == null) {
                int offset = 0;
                int index_column = 0;
                while (index_column < schema_index.Key.length) {
                    String column_name = schema_index.Key[index_column];
                    ZillionTableColumn ZillionTableColumn2 = schema.ColumnMap.get(column_name);
                    if (row_bytes_index[offset] == 0) {
                        ++offset;
                    } else if (ZillionTableColumn2.Type == ZillionTableColumnEnum.STRING) {
                        ++offset;
                        while (row_bytes_index[offset] != 0) {
                            ++offset;
                        }
                        ++offset;
                    } else {
                        ++offset;
                        offset += ByteToObject.lengthOfColumnEnum(ZillionTableColumn2.Type);
                    }
                    ++index_column;
                }
                row_bytes = new byte[row_bytes_index.length - offset];
                System.arraycopy(row_bytes_index, offset, row_bytes, 0, row_bytes.length);
            } else {
                HashMap<String, byte[]> key_bytesMap = new HashMap<String, byte[]>();
                int key_bytes_length = 0;
                int offset = 0;
                String[] stringArray = schema_index.Key;
                int n = schema_index.Key.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = stringArray[n2];
                    ZillionTableColumn ZillionTableColumn3 = schema.ColumnMap.get(column);
                    int column_offset = offset;
                    if (row_bytes_index[offset] != 0) {
                        if (ZillionTableColumn3.Type == ZillionTableColumnEnum.STRING) {
                            ++offset;
                            while (row_bytes_index[offset] != 0) {
                                ++offset;
                            }
                            ++offset;
                        } else {
                            ++offset;
                            offset += ByteToObject.lengthOfColumnEnum(ZillionTableColumn3.Type);
                        }
                    }
                    int column_offset_next = ++offset;
                    if (schema.KeyMap.containsKey(column)) {
                        byte[] value = new byte[column_offset_next - column_offset];
                        System.arraycopy(row_bytes_index, column_offset, value, 0, value.length);
                        key_bytesMap.put(column, value);
                        key_bytes_length += value.length;
                    }
                    ++n2;
                }
                row_bytes = new byte[key_bytes_length];
                int copy_length = 0;
                String[] stringArray2 = schema.Key;
                int n3 = schema.Key.length;
                n = 0;
                while (n < n3) {
                    String keyInner = stringArray2[n];
                    byte[] column_bytes = (byte[])key_bytesMap.get(keyInner);
                    System.arraycopy(column_bytes, 0, row_bytes, copy_length, column_bytes.length);
                    copy_length += column_bytes.length;
                    ++n;
                }
            }
            ++resultInner.insert_count;
            resultInner.hash_code = HashUtil.merge_hash_code(resultInner.hash_code, row_bytes);
        }
        scanner.close();
        if (schema.table_type != null && schema.table_type.startsWith("split_")) {
            container.DatabaseImpl.meta_query_update_split_index(namespace, tableName, indexName, schemaWrapper.child_name, resultInner);
            byte[] hash = resultInner.toBytes();
            container.ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName + "/" + schemaWrapper.child_name, hash, -1);
        }
        workItem.hash = resultInner;
        workItem.finish = true;
    }
}

