/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexLookupBatch;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public abstract class GridH2ScanIndex<D extends BaseIndex>
extends BaseIndex {
    private static final IndexType TYPE = IndexType.createScan((boolean)false);
    private final D delegate;

    public GridH2ScanIndex(D delegate) {
        this.delegate = delegate;
    }

    protected D delegate() {
        return this.delegate;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void add(Session ses, Row row) {
        this.delegate().add(ses, row);
    }

    public boolean canFindNext() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public boolean canScan() {
        return this.delegate().canScan();
    }

    public final void close(Session ses) {
    }

    public void commit(int operation, Row row) {
    }

    public int compareRows(SearchRow rowData, SearchRow compare) {
        return this.delegate().compareRows(rowData, compare);
    }

    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(filter.getSession(), first, last);
    }

    public Cursor find(Session ses, SearchRow first, SearchRow last) {
        return this.delegate().find(ses, null, null);
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException((String)"SCAN");
    }

    public Cursor findNext(Session ses, SearchRow higherThan, SearchRow last) {
        throw DbException.throwInternalError();
    }

    public int getColumnIndex(Column col) {
        return -1;
    }

    public Column[] getColumns() {
        return this.delegate().getColumns();
    }

    public IndexColumn[] getIndexColumns() {
        return this.delegate().getIndexColumns();
    }

    public IndexType getIndexType() {
        return TYPE;
    }

    public Row getRow(Session ses, long key) {
        return this.delegate().getRow(ses, key);
    }

    public long getRowCount(Session ses) {
        return this.delegate().getRowCount(ses);
    }

    public long getRowCountApproximation() {
        return this.delegate().getRowCountApproximation();
    }

    public Table getTable() {
        return this.delegate().getTable();
    }

    public boolean isRowIdIndex() {
        return this.delegate().isRowIdIndex();
    }

    public boolean needRebuild() {
        return false;
    }

    public void remove(Session ses) {
    }

    public void remove(Session ses, Row row) {
    }

    public void setSortedInsertMode(boolean sortedInsertMode) {
    }

    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        return this.delegate().createLookupBatch(filters, filter);
    }

    public void truncate(Session ses) {
    }

    public Schema getSchema() {
        return this.delegate().getSchema();
    }

    public boolean isHidden() {
        return this.delegate().isHidden();
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public ArrayList<DbObject> getChildren() {
        return this.delegate().getChildren();
    }

    public String getComment() {
        return this.delegate().getComment();
    }

    public String getCreateSQL() {
        return null;
    }

    public String getCreateSQLForCopy(Table tbl, String quotedName) {
        return this.delegate().getCreateSQLForCopy(tbl, quotedName);
    }

    public Database getDatabase() {
        return this.delegate().getDatabase();
    }

    public String getDropSQL() {
        return this.delegate().getDropSQL();
    }

    public int getId() {
        return this.delegate().getId();
    }

    public String getSQL() {
        return this.delegate().getSQL();
    }

    public int getType() {
        return this.delegate().getType();
    }

    public boolean isTemporary() {
        return this.delegate().isTemporary();
    }

    public void removeChildrenAndResources(Session ses) {
    }

    public void rename(String newName) {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void setComment(String comment) {
        throw DbException.getUnsupportedException((String)"comment");
    }

    public void setTemporary(boolean temporary) {
        throw DbException.getUnsupportedException((String)"temporary");
    }
}

