/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorPersistenceMetrics
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private float walLoggingRate;
    private float walWritingRate;
    private int walArchiveSegments;
    private float walFsyncTimeAvg;
    private long lastCpDuration;
    private long lastCpLockWaitDuration;
    private long lastCpMmarkDuration;
    private long lastCpPagesWriteDuration;
    private long lastCpFsyncDuration;
    private long lastCpTotalPages;
    private long lastCpDataPages;
    private long lastCpCowPages;

    public VisorPersistenceMetrics() {
    }

    public VisorPersistenceMetrics(DataStorageMetrics metrics) {
        this.walLoggingRate = metrics.getWalLoggingRate();
        this.walWritingRate = metrics.getWalWritingRate();
        this.walArchiveSegments = metrics.getWalArchiveSegments();
        this.walFsyncTimeAvg = metrics.getWalFsyncTimeAverage();
        this.lastCpDuration = metrics.getLastCheckpointDuration();
        this.lastCpLockWaitDuration = metrics.getLastCheckpointLockWaitDuration();
        this.lastCpMmarkDuration = metrics.getLastCheckpointMarkDuration();
        this.lastCpPagesWriteDuration = metrics.getLastCheckpointPagesWriteDuration();
        this.lastCpFsyncDuration = metrics.getLastCheckpointFsyncDuration();
        this.lastCpTotalPages = metrics.getLastCheckpointTotalPagesNumber();
        this.lastCpDataPages = metrics.getLastCheckpointDataPagesNumber();
        this.lastCpCowPages = metrics.getLastCheckpointCopiedOnWritePagesNumber();
    }

    public float getWalLoggingRate() {
        return this.walLoggingRate;
    }

    public float getWalWritingRate() {
        return this.walWritingRate;
    }

    public int getWalArchiveSegments() {
        return this.walArchiveSegments;
    }

    public float getWalFsyncTimeAverage() {
        return this.walFsyncTimeAvg;
    }

    public long getLastCheckpointingDuration() {
        return this.lastCpDuration;
    }

    public long getLastCheckpointLockWaitDuration() {
        return this.lastCpLockWaitDuration;
    }

    public long getLastCheckpointMarkDuration() {
        return this.lastCpMmarkDuration;
    }

    public long getLastCheckpointPagesWriteDuration() {
        return this.lastCpPagesWriteDuration;
    }

    public long getLastCheckpointFsyncDuration() {
        return this.lastCpFsyncDuration;
    }

    public long getLastCheckpointTotalPagesNumber() {
        return this.lastCpTotalPages;
    }

    public long getLastCheckpointDataPagesNumber() {
        return this.lastCpDataPages;
    }

    public long getLastCheckpointCopiedOnWritePagesNumber() {
        return this.lastCpCowPages;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeFloat(this.walLoggingRate);
        out.writeFloat(this.walWritingRate);
        out.writeInt(this.walArchiveSegments);
        out.writeFloat(this.walFsyncTimeAvg);
        out.writeLong(this.lastCpDuration);
        out.writeLong(this.lastCpLockWaitDuration);
        out.writeLong(this.lastCpMmarkDuration);
        out.writeLong(this.lastCpPagesWriteDuration);
        out.writeLong(this.lastCpFsyncDuration);
        out.writeLong(this.lastCpTotalPages);
        out.writeLong(this.lastCpDataPages);
        out.writeLong(this.lastCpCowPages);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.walLoggingRate = in.readFloat();
        this.walWritingRate = in.readFloat();
        this.walArchiveSegments = in.readInt();
        this.walFsyncTimeAvg = in.readFloat();
        this.lastCpDuration = in.readLong();
        this.lastCpLockWaitDuration = in.readLong();
        this.lastCpMmarkDuration = in.readLong();
        this.lastCpPagesWriteDuration = in.readLong();
        this.lastCpFsyncDuration = in.readLong();
        this.lastCpTotalPages = in.readLong();
        this.lastCpDataPages = in.readLong();
        this.lastCpCowPages = in.readLong();
    }

    public String toString() {
        return S.toString(VisorPersistenceMetrics.class, this);
    }
}

