/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.parser.simulator;

import com.sagacloud.parser.simulator.ComputeEngineLexer;
import com.sagacloud.parser.simulator.ComputeEngineParser;
import com.sagacloud.util.compute_engine.core.GrammarCompare;
import com.sagacloud.util.compute_engine.core.GrammarTreeNode;
import com.sagacloud.util.math.MathUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;

public class String2Grammar {
    public static GrammarTreeNode Generate(String str) throws Exception {
        ANTLRInputStream input = new ANTLRInputStream((InputStream)new ByteArrayInputStream((str + "$").getBytes()));
        ComputeEngineLexer lexer = new ComputeEngineLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ComputeEngineParser parser = new ComputeEngineParser((TokenStream)tokens);
        ComputeEngineParser.prog_return r = parser.prog();
        CommonTree t = (CommonTree)r.getTree();
        GrammarTreeNode result = String2Grammar.GenerateNode(t);
        return result;
    }

    private static GrammarTreeNode GenerateNode(CommonTree t) throws Exception {
        String text = t.getText();
        List children = t.getChildren();
        if (text.equals("if") || text.equals("elseif")) {
            GrammarTreeNode result = new GrammarTreeNode();
            result.type = "compare";
            result.compare = String2Grammar.Generate_compare((CommonTree)children.get(0));
            result.compare_yes_node = String2Grammar.GenerateNode((CommonTree)children.get(1));
            result.compare_no_node = String2Grammar.GenerateNode((CommonTree)children.get(2));
            return result;
        }
        if (text.equals("else")) {
            GrammarTreeNode result = String2Grammar.GenerateNode((CommonTree)children.get(0));
            return result;
        }
        if (MathUtil.Instance().diy_funname(MathUtil.Instance().fun0p, text)) {
            GrammarTreeNode result = new GrammarTreeNode();
            result.type = "evaluate";
            result.evaluate = text;
            result.evaluateItemList = new ArrayList<GrammarTreeNode>();
            return result;
        }
        if (MathUtil.Instance().diy_funname(MathUtil.Instance().fun1p, text)) {
            GrammarTreeNode result = new GrammarTreeNode();
            result.type = "evaluate";
            result.evaluate = text;
            result.evaluateItemList = new ArrayList<GrammarTreeNode>();
            result.evaluateItemList.add(String2Grammar.GenerateNode((CommonTree)children.get(0)));
            return result;
        }
        if (MathUtil.Instance().diy_funname(MathUtil.Instance().fun2p, text)) {
            GrammarTreeNode result = new GrammarTreeNode();
            result.type = "evaluate";
            result.evaluate = text;
            result.evaluateItemList = new ArrayList<GrammarTreeNode>();
            result.evaluateItemList.add(String2Grammar.GenerateNode((CommonTree)children.get(0)));
            result.evaluateItemList.add(String2Grammar.GenerateNode((CommonTree)children.get(1)));
            return result;
        }
        if (text.equals("+") || text.equals("-") || text.equals("*") || text.equals("/")) {
            GrammarTreeNode result = new GrammarTreeNode();
            result.type = "evaluate";
            result.evaluate = text;
            result.evaluateItemList = new ArrayList<GrammarTreeNode>();
            result.evaluateItemList.add(String2Grammar.GenerateNode((CommonTree)children.get(0)));
            result.evaluateItemList.add(String2Grammar.GenerateNode((CommonTree)children.get(1)));
            return result;
        }
        if (text.startsWith("other_")) {
            GrammarTreeNode result = new GrammarTreeNode();
            result.type = "other";
            result.other = text.substring("other_".length());
            return result;
        }
        try {
            GrammarTreeNode result = new GrammarTreeNode();
            result.const_value = Double.parseDouble(text);
            result.type = "const";
            return result;
        }
        catch (NumberFormatException e) {
            GrammarTreeNode result = new GrammarTreeNode();
            result.type = "var";
            result.var_original = text;
            int index = text.indexOf(39);
            if (index != -1) {
                result.var_sign = text.substring(0, index);
                result.var_offset = Integer.parseInt(text.substring(index + 1));
            } else {
                result.var_sign = text;
                result.var_offset = 0;
            }
            return result;
        }
    }

    private static GrammarCompare Generate_compare(CommonTree t) throws Exception {
        String text = t.getText();
        List children = t.getChildren();
        if (MathUtil.Instance().diy_funname(MathUtil.Instance().cmp, text)) {
            GrammarCompare result = new GrammarCompare();
            result.type = "itom";
            result.itom_op = text;
            result.itom_left = String2Grammar.GenerateNode((CommonTree)children.get(0));
            result.itom_right = String2Grammar.GenerateNode((CommonTree)children.get(1));
            return result;
        }
        if (text.equals("&&") || text.equals("||")) {
            GrammarCompare result = new GrammarCompare();
            result.type = "group";
            result.group_op = text;
            result.groupItemList = new ArrayList<GrammarCompare>();
            result.groupItemList.add(String2Grammar.Generate_compare((CommonTree)children.get(0)));
            result.groupItemList.add(String2Grammar.Generate_compare((CommonTree)children.get(1)));
            return result;
        }
        if (text.equals("!")) {
            GrammarCompare result = new GrammarCompare();
            result.type = "group";
            result.group_op = text;
            result.groupItemList = new ArrayList<GrammarCompare>();
            result.groupItemList.add(String2Grammar.Generate_compare((CommonTree)children.get(0)));
            return result;
        }
        throw new Exception("GrammarCompare error:" + text);
    }
}

