/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDelegationTokenResponse;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenOperation;
import org.apache.hadoop.yarn.webapp.YarnJacksonJaxbJsonProvider;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineAuthenticator
extends KerberosAuthenticator {
    private static ObjectMapper mapper = new ObjectMapper();

    protected Authenticator getFallBackAuthenticator() {
        return new TimelineAuthenticator();
    }

    public static void injectDelegationToken(Map<String, String> params, Token<?> dtToken) throws IOException {
        if (dtToken != null) {
            params.put("delegation", dtToken.encodeToUrlString());
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    boolean hasDelegationToken(URL url) {
        if (url.getQuery() == null) {
            return false;
        }
        return url.getQuery().contains("delegation=");
    }

    public void authenticate(URL url, AuthenticatedURL.Token token) throws IOException, AuthenticationException {
        if (!this.hasDelegationToken(url)) {
            super.authenticate(url, token);
        }
    }

    public static Token<TimelineDelegationTokenIdentifier> getDelegationToken(URL url, AuthenticatedURL.Token token, String renewer) throws IOException {
        TimelineDelegationTokenOperation op = TimelineDelegationTokenOperation.GETDELEGATIONTOKEN;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", op.toString());
        params.put("renewer", renewer);
        url = TimelineAuthenticator.appendParams(url, params);
        AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new TimelineAuthenticator());
        try {
            HttpURLConnection conn = aUrl.openConnection(url, token);
            conn.setRequestMethod(op.getHttpMethod());
            TimelineDelegationTokenResponse dtRes = TimelineAuthenticator.validateAndParseResponse(conn);
            if (!dtRes.getType().equals("url")) {
                throw new IOException("The response content is not expected: " + dtRes.getContent());
            }
            String tokenStr = dtRes.getContent().toString();
            Token dToken = new Token();
            dToken.decodeFromUrlString(tokenStr);
            return dToken;
        }
        catch (AuthenticationException ex) {
            throw new IOException(ex.toString(), ex);
        }
    }

    public static long renewDelegationToken(URL url, AuthenticatedURL.Token token, Token<TimelineDelegationTokenIdentifier> dToken) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", TimelineDelegationTokenOperation.RENEWDELEGATIONTOKEN.toString());
        params.put("token", dToken.encodeToUrlString());
        url = TimelineAuthenticator.appendParams(url, params);
        AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new TimelineAuthenticator());
        try {
            HttpURLConnection conn = aUrl.openConnection(url, token);
            conn.setRequestMethod(TimelineDelegationTokenOperation.RENEWDELEGATIONTOKEN.getHttpMethod());
            TimelineDelegationTokenResponse dtRes = TimelineAuthenticator.validateAndParseResponse(conn);
            if (!dtRes.getType().equals("expirationTime")) {
                throw new IOException("The response content is not expected: " + dtRes.getContent());
            }
            return Long.valueOf(dtRes.getContent().toString());
        }
        catch (AuthenticationException ex) {
            throw new IOException(ex.toString(), ex);
        }
    }

    public static void cancelDelegationToken(URL url, AuthenticatedURL.Token token, Token<TimelineDelegationTokenIdentifier> dToken) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", TimelineDelegationTokenOperation.CANCELDELEGATIONTOKEN.toString());
        params.put("token", dToken.encodeToUrlString());
        url = TimelineAuthenticator.appendParams(url, params);
        AuthenticatedURL aUrl = new AuthenticatedURL((Authenticator)new TimelineAuthenticator());
        try {
            HttpURLConnection conn = aUrl.openConnection(url, token);
            conn.setRequestMethod(TimelineDelegationTokenOperation.CANCELDELEGATIONTOKEN.getHttpMethod());
            TimelineAuthenticator.validateAndParseResponse(conn);
        }
        catch (AuthenticationException ex) {
            throw new IOException(ex.toString(), ex);
        }
    }

    public static URL appendParams(URL url, Map<String, String> params) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        String separator = url.toString().contains("?") ? "&" : "?";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(separator).append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF8"));
            separator = "&";
        }
        return new URL(sb.toString());
    }

    private static TimelineDelegationTokenResponse validateAndParseResponse(HttpURLConnection conn) throws IOException {
        int status = conn.getResponseCode();
        JsonNode json = mapper.readTree(conn.getInputStream());
        if (status == 200) {
            return (TimelineDelegationTokenResponse)mapper.readValue(json, TimelineDelegationTokenResponse.class);
        }
        try {
            String message = json.get("message").getTextValue();
            String exception = json.get("exception").getTextValue();
            String className = json.get("javaClassName").getTextValue();
            try {
                ClassLoader cl = TimelineAuthenticator.class.getClassLoader();
                Class<?> klass = cl.loadClass(className);
                Constructor<?> constr = klass.getConstructor(String.class);
                throw (IOException)constr.newInstance(message);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(MessageFormat.format("{0} - {1}", exception, message));
            }
        }
        catch (IOException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException(MessageFormat.format("HTTP status [{0}], {1}", status, conn.getResponseMessage()));
        }
    }

    static {
        YarnJacksonJaxbJsonProvider.configObjectMapper((ObjectMapper)mapper);
    }
}

