/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.agent.ZillionCriteriaGroup;
import com.zillion.database.agent.ZillionQueryResult;
import com.zillion.database.agent.ZillionQueryTmp;
import com.zillion.database.async.AsyncJob;
import com.zillion.database.util.Configuration_MySQL;
import com.zillion.database.util.DatabaseImpl_HBase;
import com.zillion.database.util.DatabaseImpl_MySQL;
import com.zillion.database.util.IDatabase;
import com.zillion.database.util.ITableWrapper;
import com.zillion.util.common.HashObject;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaWrapper;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import com.zillion.util.zk.ZKWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.zillion.util.common.MyException;

public class DatabaseImpl_Mix
implements IDatabase {
    public DatabaseImpl_HBase hbase;
    public DatabaseImpl_MySQL mysql;
    SchemaRepositoryContainer container;

    public DatabaseImpl_Mix(Configuration configuration, Configuration configuration_bak, Configuration_MySQL configuration_mysql, SchemaRepositoryContainer container) {
        this.hbase = new DatabaseImpl_HBase(configuration, configuration_bak);
        this.mysql = new DatabaseImpl_MySQL(configuration_mysql);
        this.container = container;
    }

    @Override
    public void Start() throws Exception {
        this.hbase.Start();
        this.mysql.Start();
    }

    @Override
    public void Stop() throws Exception {
        this.mysql.Stop();
        this.hbase.Stop();
    }

    @Override
    public void namespace_create(String namespace) throws Exception {
        this.hbase.namespace_create(namespace);
        this.mysql.namespace_create(namespace);
    }

    @Override
    public void namespace_drop(String namespace) throws Exception {
        this.hbase.namespace_drop(namespace);
        this.mysql.namespace_drop(namespace);
    }

    @Override
    public void meta_manage_create_data(String namespace) throws Exception {
        this.hbase.meta_manage_create_data(namespace);
    }

    @Override
    public void meta_manage_create_index(String namespace) throws Exception {
        this.hbase.meta_manage_create_index(namespace);
    }

    @Override
    public void meta_manage_make_sure_split(String namespace) throws Exception {
        this.hbase.meta_manage_make_sure_split(namespace);
    }

    @Override
    public void meta_manage_drop_data(String namespace) throws Exception {
        this.hbase.meta_manage_drop_data(namespace);
    }

    @Override
    public void meta_manage_drop_index(String namespace) throws Exception {
        this.hbase.meta_manage_drop_index(namespace);
    }

    @Override
    public void meta_manage_drop_split(String namespace) throws Exception {
        this.hbase.meta_manage_drop_split(namespace);
    }

    @Override
    public void meta_query_insert_data(String namespace, String tableName, JSONObject content, HashObject hashObject) throws Exception {
        this.hbase.meta_query_insert_data(namespace, tableName, content, hashObject);
    }

    @Override
    public void meta_query_insert_index(String namespace, String tableName, String indexName, JSONArray indexColumns, HashObject hashObject) throws Exception {
        this.hbase.meta_query_insert_index(namespace, tableName, indexName, indexColumns, hashObject);
    }

    @Override
    public void meta_query_insert_split(String namespace, String tableName, HashObject hashObject) throws Exception {
        this.hbase.meta_query_insert_split(namespace, tableName, hashObject);
    }

    @Override
    public void meta_query_delete_data(String namespace, String tableName) throws Exception {
        this.hbase.meta_query_delete_data(namespace, tableName);
    }

    @Override
    public void meta_query_delete_index(String namespace, String tableName, String indexName) throws Exception {
        this.hbase.meta_query_delete_index(namespace, tableName, indexName);
    }

    @Override
    public void meta_query_delete_split(String namespace, String tableName) throws Exception {
        this.hbase.meta_query_delete_split(namespace, tableName);
    }

    @Override
    public void meta_query_update_data(String namespace, String tableName, JSONObject content) throws Exception {
        this.hbase.meta_query_update_data(namespace, tableName, content);
    }

    @Override
    public void meta_query_update_data(String namespace, String tableName, HashObject hashObject) throws Exception {
        this.hbase.meta_query_update_data(namespace, tableName, hashObject);
    }

    @Override
    public void meta_query_update_index(String namespace, String tableName, String indexName, HashObject hashObject) throws Exception {
        this.hbase.meta_query_update_index(namespace, tableName, indexName, hashObject);
    }

    @Override
    public void meta_query_update_split_data(String namespace, String tableName, String child_name, HashObject hashObject) throws Exception {
        this.hbase.meta_query_update_split_data(namespace, tableName, child_name, hashObject);
    }

    @Override
    public void meta_query_update_split_index(String namespace, String tableName, String indexName, String child_name, HashObject hashObject) throws Exception {
        this.hbase.meta_query_update_split_index(namespace, tableName, indexName, child_name, hashObject);
    }

    @Override
    public boolean table_split_index_exist(String namespace, String table_name, String index_name, String child_name) throws Exception {
        String tableName = "zillion_index_" + table_name + "." + index_name + "_" + child_name;
        ZillionTableSchema schema = this.getSchema(namespace, tableName);
        if (schema.store_in_minor_db) {
            tableName = "zillion_index_" + table_name + "_" + child_name;
            return this.mysql.ori_tableExists(namespace, tableName);
        }
        return this.hbase.ori_tableExists(namespace, tableName);
    }

    @Override
    public void table_manage_create_data(String namespace, ZillionTableSchema schema) throws Exception {
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_create_data(namespace, schema);
        } else {
            this.hbase.table_manage_create_data(namespace, schema);
        }
    }

    @Override
    public void table_manage_create_index(String namespace, String tableName, ZillionTableIndex schema_index) throws Exception {
        ZillionTableSchema schema = schema_index.schema;
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_create_index(namespace, tableName, schema_index);
        } else {
            this.hbase.table_manage_create_index(namespace, tableName, schema_index);
        }
    }

    @Override
    public void table_manage_create_split_data(String namespace, String tableName, String child_name, ZillionTableSchema schema) throws Exception {
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_create_split_data(namespace, tableName, child_name, schema);
        } else {
            this.hbase.table_manage_create_split_data(namespace, tableName, child_name, schema);
        }
    }

    @Override
    public void table_manage_create_split_index(String namespace, String tableName, String indexName, String child_name, ZillionTableIndex schema_index) throws Exception {
        ZillionTableSchema schema = schema_index.schema;
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_create_split_index(namespace, tableName, indexName, child_name, schema_index);
        } else {
            this.hbase.table_manage_create_split_index(namespace, tableName, indexName, child_name, schema_index);
        }
    }

    @Override
    public void table_manage_drop_data(String namespace, String tableName) throws Exception {
        ZillionTableSchema schema = this.container.repositoryMap.get(namespace).GetTable(tableName);
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_drop_data(namespace, tableName);
        } else {
            this.hbase.table_manage_drop_data(namespace, tableName);
        }
    }

    @Override
    public void table_manage_drop_index(String namespace, String tableName, String indexName) throws Exception {
        ZillionTableSchema schema = this.container.repositoryMap.get(namespace).GetTable(tableName);
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_drop_index(namespace, tableName, indexName);
        } else {
            this.hbase.table_manage_drop_index(namespace, tableName, indexName);
        }
    }

    @Override
    public void table_manage_drop_split_data(String namespace, String tableName, String child_name) throws Exception {
        ZillionTableSchema schema = this.container.repositoryMap.get(namespace).GetTable(tableName);
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_drop_split_data(namespace, tableName, child_name);
        } else {
            this.hbase.table_manage_drop_split_data(namespace, tableName, child_name);
        }
    }

    @Override
    public void table_manage_drop_split_index(String namespace, String tableName, String indexName, String child_name) throws Exception {
        ZillionTableSchema schema = this.container.repositoryMap.get(namespace).GetTable(tableName);
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_drop_split_index(namespace, tableName, indexName, child_name);
        } else {
            this.hbase.table_manage_drop_split_index(namespace, tableName, indexName, child_name);
        }
    }

    @Override
    public void table_manage_alter_add_column(String namespace, String ori_tableName, List<ZillionTableColumn> ztcList) throws Exception {
        ZillionTableSchema schema = this.getSchema(namespace, ori_tableName);
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_alter_add_column(namespace, ori_tableName, ztcList);
        } else {
            this.hbase.table_manage_alter_add_column(namespace, ori_tableName, ztcList);
        }
    }

    @Override
    public void table_manage_alter_drop_column(String namespace, String ori_tableName, List<String> columnList) throws Exception {
        ZillionTableSchema schema = this.getSchema(namespace, ori_tableName);
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_alter_drop_column(namespace, ori_tableName, columnList);
        } else {
            this.hbase.table_manage_alter_drop_column(namespace, ori_tableName, columnList);
        }
    }

    @Override
    public void table_manage_alter_compression(String namespace, String ori_tableName, boolean enable) throws Exception {
        ZillionTableSchema schema = this.getSchema(namespace, ori_tableName);
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_alter_compression(namespace, ori_tableName, enable);
        } else {
            this.hbase.table_manage_alter_compression(namespace, ori_tableName, enable);
        }
    }

    @Override
    public void table_manage_alter_in_memory(String namespace, String ori_tableName, boolean enable) throws Exception {
        ZillionTableSchema schema = this.getSchema(namespace, ori_tableName);
        if (schema.store_in_minor_db) {
            this.mysql.table_manage_alter_in_memory(namespace, ori_tableName, enable);
        } else {
            this.hbase.table_manage_alter_in_memory(namespace, ori_tableName, enable);
        }
    }

    @Override
    public void meta_read(String namespace, List<String> tableNameList, List<String> tableContentList, List<HashObject> tableHashList, List<String> indexNameList, List<String> indexContentList, List<HashObject> indexHashList, List<String> splitNameList, List<HashObject> splitHashList) throws Exception {
        this.hbase.meta_read(namespace, tableNameList, tableContentList, tableHashList, indexNameList, indexContentList, indexHashList, splitNameList, splitHashList);
    }

    @Override
    public int clear_table_split(String namespace, ZillionTableSchema schema, List<String> query_monthList, ZKWrapper ZK) throws Exception {
        if (schema.store_in_minor_db) {
            return this.mysql.clear_table_split(namespace, schema, query_monthList, ZK);
        }
        return this.hbase.clear_table_split(namespace, schema, query_monthList, ZK);
    }

    @Override
    public int clear_table_not_split(String namespace, ZillionTableSchema schema, ZKWrapper ZK) throws Exception {
        if (schema.store_in_minor_db) {
            return this.mysql.clear_table_not_split(namespace, schema, ZK);
        }
        return this.hbase.clear_table_not_split(namespace, schema, ZK);
    }

    @Override
    public void scan(SchemaRepositoryContainer container, ZillionTableSchema schema, SchemaWrapper schemaWrapper, JSONArray ReturnColumns, ZillionCriteriaGroup group, String QueryType, JSONArray content, ZillionQueryTmp zqt, ZipArchiveOutputStream out, AsyncJob job, boolean SortInDB, JSONArray OrderBy, long Limit_Skip, long Limit_Count, ZillionQueryResult result, JSONObject Set2) throws Exception {
        if (schema.store_in_minor_db) {
            this.mysql.scan(container, schema, schemaWrapper, ReturnColumns, group, QueryType, content, zqt, out, job, SortInDB, OrderBy, Limit_Skip, Limit_Count, result, Set2);
        } else {
            this.hbase.scan(container, schema, schemaWrapper, ReturnColumns, group, QueryType, content, zqt, out, job, SortInDB, OrderBy, Limit_Skip, Limit_Count, result, Set2);
        }
    }

    @Override
    public void batch_process(ZillionTableSchema schema, SchemaWrapper wrapper, String QueryType, JSONArray InsertObjects, JSONObject Set2, boolean is_put) throws Exception {
        if (schema.store_in_minor_db) {
            this.mysql.batch_process(schema, wrapper, QueryType, InsertObjects, Set2, is_put);
        } else {
            this.hbase.batch_process(schema, wrapper, QueryType, InsertObjects, Set2, is_put);
        }
    }

    @Override
    public JSONArray batch_get(ZillionTableSchema schema, ITableWrapper table_wrapper, JSONArray InsertObjects, JSONArray content, Map<String, Boolean> ReturnColumnsMap) throws Exception {
        if (schema.store_in_minor_db) {
            return this.mysql.batch_get(schema, table_wrapper, InsertObjects, content, ReturnColumnsMap);
        }
        return this.hbase.batch_get(schema, table_wrapper, InsertObjects, content, ReturnColumnsMap);
    }

    @Override
    public ITableWrapper generateTableWrapper(String namespace, String ori_tableName, int exist_count) throws Exception {
        ZillionTableSchema schema = this.getSchema(namespace, ori_tableName);
        if (schema.store_in_minor_db) {
            return this.mysql.generateTableWrapper(namespace, ori_tableName, exist_count);
        }
        return this.hbase.generateTableWrapper(namespace, ori_tableName, exist_count);
    }

    @Override
    public void ori_drop_table(String namespace, String ori_tableName) throws Exception {
        ZillionTableSchema schema = this.getSchema(namespace, ori_tableName);
        if (schema.store_in_minor_db) {
            this.mysql.ori_drop_table(namespace, ori_tableName);
        } else {
            this.hbase.ori_drop_table(namespace, ori_tableName);
        }
    }

    @Override
    public List<String> ori_namespaceList() throws Exception {
        return this.hbase.ori_namespaceList();
    }

    @Override
    public boolean ori_tableExists(String namespace, String ori_tableName) throws Exception {
        if (ori_tableName.startsWith("zillion_meta_")) {
            return this.hbase.ori_tableExists(namespace, ori_tableName);
        }
        ZillionTableSchema schema = this.getSchema(namespace, ori_tableName);
        if (schema.store_in_minor_db) {
            return this.mysql.ori_tableExists(namespace, ori_tableName);
        }
        return this.hbase.ori_tableExists(namespace, ori_tableName);
    }

    @Override
    public List<String> ori_tableList(String namespace) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.mysql.ori_tableList(namespace));
        result.addAll(this.hbase.ori_tableList(namespace));
        return result;
    }

    private ZillionTableSchema getSchema(String namespace, String ori_tableName) throws Exception {
        int index_;
        String tableName;
        if (ori_tableName.startsWith("zillion_data_")) {
            tableName = ori_tableName.substring("zillion_data_".length());
        } else if (ori_tableName.startsWith("zillion_index_")) {
            tableName = ori_tableName.substring("zillion_index_".length());
        } else {
            throw new MyException("getSchema:" + namespace + "." + ori_tableName);
        }
        ZillionTableSchema schema = this.container.repositoryMap.get(namespace).GetTable(tableName);
        if (schema == null && (index_ = tableName.lastIndexOf(46)) != -1) {
            tableName = tableName.substring(0, index_);
            schema = this.container.repositoryMap.get(namespace).GetTable(tableName);
        }
        if (schema == null && (index_ = tableName.lastIndexOf(95)) != -1) {
            tableName = tableName.substring(0, index_);
            schema = this.container.repositoryMap.get(namespace).GetTable(tableName);
        }
        return schema;
    }
}

