/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClientFailedException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.jetbrains.annotations.Nullable;

public class ZookeeperClient
implements Watcher {
    private static final long RETRY_TIMEOUT = IgniteSystemProperties.getLong((String)"IGNITE_ZOOKEEPER_DISCOVERY_RETRY_TIMEOUT", (long)2000L);
    private static final int MAX_RETRY_COUNT = IgniteSystemProperties.getInteger((String)"IGNITE_ZOOKEEPER_DISCOVERY_MAX_RETRY_COUNT", (int)10);
    private final AtomicInteger retryCount = new AtomicInteger();
    private static final int MAX_REQ_SIZE = 1048528;
    private static final List<ACL> ZK_ACL = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final ZooKeeper zk;
    private final IgniteLogger log;
    private ConnectionState state = ConnectionState.Disconnected;
    private long connLossTimeout;
    private volatile long connStartTime;
    private final Object stateMux = new Object();
    private final IgniteRunnable connLostC;
    private final Timer connTimer;
    private final ArrayDeque<ZkAsyncOperation> retryQ = new ArrayDeque();
    private volatile boolean closing;

    ZookeeperClient(IgniteLogger log, String connectString, int sesTimeout, IgniteRunnable connLostC) throws Exception {
        this(null, log, connectString, sesTimeout, connLostC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZookeeperClient(String igniteInstanceName, IgniteLogger log, String connectString, int sesTimeout, IgniteRunnable connLostC) throws Exception {
        this.log = log.getLogger(this.getClass());
        this.connLostC = connLostC;
        this.connLossTimeout = sesTimeout;
        long connStartTime = this.connStartTime = System.currentTimeMillis();
        this.connTimer = new Timer("zk-client-timer-" + igniteInstanceName);
        String threadName = Thread.currentThread().getName();
        Thread.currentThread().setName("zk-" + igniteInstanceName);
        try {
            this.zk = new ZooKeeper(connectString, sesTimeout, (Watcher)this);
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
        Object object = this.stateMux;
        synchronized (object) {
            if (connStartTime == this.connStartTime && this.state == ConnectionState.Disconnected) {
                this.scheduleConnectionCheck();
            }
        }
    }

    ZooKeeper zk() {
        return this.zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean connected() {
        Object object = this.stateMux;
        synchronized (object) {
            return this.state == ConnectionState.Connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String state() {
        Object object = this.stateMux;
        synchronized (object) {
            return this.state.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent evt) {
        if (this.closing) {
            return;
        }
        if (evt.getType() == Watcher.Event.EventType.None) {
            ConnectionState newState;
            Iterator<ZkAsyncOperation> iterator = this.stateMux;
            synchronized (iterator) {
                if (this.state == ConnectionState.Lost) {
                    U.warn((IgniteLogger)this.log, (Object)("Received event after connection was lost [evtState=" + evt.getState() + "]"));
                    return;
                }
                if (!this.zk.getState().isAlive()) {
                    return;
                }
                Watcher.Event.KeeperState zkState = evt.getState();
                switch (zkState) {
                    case SaslAuthenticated: {
                        return;
                    }
                    case AuthFailed: {
                        newState = this.state;
                        break;
                    }
                    case Disconnected: {
                        newState = ConnectionState.Disconnected;
                        break;
                    }
                    case SyncConnected: {
                        newState = ConnectionState.Connected;
                        break;
                    }
                    case Expired: {
                        U.warn((IgniteLogger)this.log, (Object)"Session expired, changing state to Lost");
                        newState = ConnectionState.Lost;
                        break;
                    }
                    default: {
                        U.error((IgniteLogger)this.log, (Object)("Unexpected state for ZooKeeper client, close connection: " + zkState));
                        newState = ConnectionState.Lost;
                    }
                }
                if (newState != this.state) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("ZooKeeper client state changed [prevState=" + (Object)((Object)this.state) + ", newState=" + (Object)((Object)newState) + ']');
                    }
                    this.state = newState;
                    if (newState == ConnectionState.Disconnected) {
                        this.connStartTime = System.currentTimeMillis();
                        this.scheduleConnectionCheck();
                    } else if (newState == ConnectionState.Connected) {
                        this.retryCount.set(0);
                        this.stateMux.notifyAll();
                    } else assert (this.state == ConnectionState.Lost) : this.state;
                } else {
                    return;
                }
            }
            if (newState == ConnectionState.Lost) {
                this.closeClient();
                this.notifyConnectionLost();
            } else if (newState == ConnectionState.Connected) {
                for (ZkAsyncOperation op : this.retryQ) {
                    op.execute();
                }
            }
        }
    }

    private void notifyConnectionLost() {
        if (!this.closing && this.state == ConnectionState.Lost && this.connLostC != null) {
            this.connLostC.run();
        }
        this.connTimer.cancel();
    }

    boolean exists(String path) throws ZookeeperClientFailedException, InterruptedException {
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                return this.zk.exists(path, false) != null;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    void createAll(List<String> paths, CreateMode createMode) throws ZookeeperClientFailedException, InterruptedException, KeeperException.NodeExistsException {
        ArrayList<Op> ops = new ArrayList<Op>(paths.size());
        for (String path : paths) {
            ops.add(Op.create((String)path, (byte[])EMPTY_BYTES, ZK_ACL, (CreateMode)createMode));
        }
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                this.zk.multi(ops);
                return;
            }
            catch (KeeperException.NodeExistsException e) {
                throw e;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    boolean needSplitNodeData(String path, byte[] data, int overhead) {
        return this.requestOverhead(path) + data.length + overhead > 1048528;
    }

    List<byte[]> splitNodeData(String path, byte[] data, int overhead) {
        int partSize = 1048528 - this.requestOverhead(path) - overhead;
        int partCnt = data.length / partSize;
        if (data.length % partSize != 0) {
            ++partCnt;
        }
        assert (partCnt > 1) : "Do not need split";
        ArrayList<byte[]> parts = new ArrayList<byte[]>(partCnt);
        int remaining = data.length;
        for (int i = 0; i < partCnt; ++i) {
            int partSize0 = Math.min(remaining, partSize);
            byte[] part = new byte[partSize0];
            System.arraycopy(data, i * partSize, part, 0, part.length);
            remaining -= partSize0;
            parts.add(part);
        }
        assert (remaining == 0) : remaining;
        return parts;
    }

    private int requestOverhead(String path) {
        return path.length();
    }

    String createIfNeeded(String path, byte[] data, CreateMode createMode) throws ZookeeperClientFailedException, InterruptedException {
        assert (!createMode.isSequential()) : createMode;
        if (data == null) {
            data = EMPTY_BYTES;
        }
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                return this.zk.create(path, data, ZK_ACL, createMode);
            }
            catch (KeeperException.NodeExistsException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node already exists: " + path);
                }
                return path;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    String createSequential(String checkPrefix, String parentPath, String path, byte[] data, CreateMode createMode) throws ZookeeperClientFailedException, InterruptedException {
        assert (createMode.isSequential()) : createMode;
        if (data == null) {
            data = EMPTY_BYTES;
        }
        boolean first = true;
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                if (!first) {
                    List children = this.zk.getChildren(parentPath, false);
                    for (int i = 0; i < children.size(); ++i) {
                        String child = (String)children.get(i);
                        if (!((String)children.get(i)).startsWith(checkPrefix)) continue;
                        String resPath = parentPath + "/" + child;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Check before retry, node already created: " + resPath);
                        }
                        return resPath;
                    }
                }
                return this.zk.create(path, data, ZK_ACL, createMode);
            }
            catch (KeeperException.NodeExistsException e) {
                assert (!createMode.isSequential()) : createMode;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Node already exists: " + path);
                }
                return path;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                first = false;
                continue;
            }
            break;
        }
    }

    List<String> getChildren(String path) throws ZookeeperClientFailedException, InterruptedException {
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                return this.zk.getChildren(path, false);
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    List<String> getChildrenIfPathExists(String path) throws KeeperException.NoNodeException, InterruptedException, ZookeeperClientFailedException {
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                return this.zk.getChildren(path, false);
            }
            catch (KeeperException.NoNodeException e) {
                throw e;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    boolean existsNoRetry(String path) throws InterruptedException, KeeperException {
        return this.zk.exists(path, false) != null;
    }

    void deleteIfExistsNoRetry(String path, int ver) throws InterruptedException, KeeperException {
        try {
            this.zk.delete(path, ver);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    void deleteIfExists(String path, int ver) throws ZookeeperClientFailedException, InterruptedException {
        try {
            this.delete(path, ver);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    void deleteAll(@Nullable String parent, List<String> paths, int ver) throws KeeperException.NoNodeException, ZookeeperClientFailedException, InterruptedException {
        if (paths.isEmpty()) {
            return;
        }
        ArrayList<Op> ops = new ArrayList<Op>(paths.size());
        for (String path : paths) {
            String path0 = parent != null ? parent + "/" + path : path;
            ops.add(Op.delete((String)path0, (int)ver));
        }
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                this.zk.multi(ops);
                return;
            }
            catch (KeeperException.NoNodeException e) {
                throw e;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    private void delete(String path, int ver) throws KeeperException.NoNodeException, ZookeeperClientFailedException, InterruptedException {
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                this.zk.delete(path, ver);
                return;
            }
            catch (KeeperException.NoNodeException e) {
                throw e;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    void setData(String path, byte[] data, int ver) throws ZookeeperClientFailedException, InterruptedException, KeeperException.NoNodeException, KeeperException.BadVersionException {
        if (data == null) {
            data = EMPTY_BYTES;
        }
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                this.zk.setData(path, data, ver);
                return;
            }
            catch (KeeperException.BadVersionException | KeeperException.NoNodeException e) {
                throw e;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    byte[] getData(String path, @Nullable Stat stat) throws KeeperException.NoNodeException, ZookeeperClientFailedException, InterruptedException {
        while (true) {
            long connStartTime = this.connStartTime;
            try {
                return this.zk.getData(path, false, stat);
            }
            catch (KeeperException.NoNodeException e) {
                throw e;
            }
            catch (Exception e) {
                this.onZookeeperError(connStartTime, e);
                continue;
            }
            break;
        }
    }

    byte[] getData(String path) throws KeeperException.NoNodeException, ZookeeperClientFailedException, InterruptedException {
        return this.getData(path, null);
    }

    void deleteIfExistsAsync(String path) {
        new DeleteIfExistsOperation(path).execute();
    }

    void existsAsync(String path, Watcher watcher, AsyncCallback.StatCallback cb) {
        ExistsOperation op = new ExistsOperation(path, watcher, cb);
        this.zk.exists(path, watcher, (AsyncCallback.StatCallback)new StatCallbackWrapper(op), null);
    }

    void getChildrenAsync(String path, Watcher watcher, AsyncCallback.Children2Callback cb) {
        GetChildrenOperation op = new GetChildrenOperation(path, watcher, cb);
        this.zk.getChildren(path, watcher, (AsyncCallback.Children2Callback)new ChildrenCallbackWrapper(op), null);
    }

    void getDataAsync(String path, Watcher watcher, AsyncCallback.DataCallback cb) {
        GetDataOperation op = new GetDataOperation(path, watcher, cb);
        this.zk.getData(path, watcher, (AsyncCallback.DataCallback)new DataCallbackWrapper(op), null);
    }

    private void createAsync(String path, byte[] data, CreateMode createMode, AsyncCallback.StringCallback cb) {
        if (data == null) {
            data = EMPTY_BYTES;
        }
        CreateOperation op = new CreateOperation(path, data, createMode, cb);
        this.zk.create(path, data, ZK_ACL, createMode, (AsyncCallback.StringCallback)new CreateCallbackWrapper(op), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCloseStart() {
        this.closing = true;
        Object object = this.stateMux;
        synchronized (object) {
            this.stateMux.notifyAll();
        }
    }

    public void close() {
        this.closeClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onZookeeperError(long prevConnStartTime, Exception e) throws ZookeeperClientFailedException, InterruptedException {
        ZookeeperClientFailedException err = null;
        Object object = this.stateMux;
        synchronized (object) {
            boolean retry;
            if (this.closing) {
                throw new ZookeeperClientFailedException("ZooKeeper client is closed.");
            }
            U.warn((IgniteLogger)this.log, (Object)("Failed to execute ZooKeeper operation [err=" + e + ", state=" + (Object)((Object)this.state) + ']'));
            if (this.state == ConnectionState.Lost) {
                U.error((IgniteLogger)this.log, (Object)("Operation failed with unexpected error, connection lost: " + e), (Throwable)e);
                throw new ZookeeperClientFailedException(e);
            }
            boolean bl = retry = e instanceof KeeperException && this.needRetry(((KeeperException)e).code().intValue());
            if (retry) {
                long remainingTime;
                if (this.state == ConnectionState.Connected && this.connStartTime == prevConnStartTime) {
                    this.state = ConnectionState.Disconnected;
                    this.connStartTime = System.currentTimeMillis();
                    remainingTime = this.connLossTimeout;
                } else {
                    assert (this.connStartTime != 0L);
                    assert (this.state == ConnectionState.Disconnected) : this.state;
                    remainingTime = this.connLossTimeout - (System.currentTimeMillis() - this.connStartTime);
                    if (remainingTime <= 0L) {
                        this.state = ConnectionState.Lost;
                        U.warn((IgniteLogger)this.log, (Object)("Failed to establish ZooKeeper connection, close client [timeout=" + this.connLossTimeout + ']'));
                        err = new ZookeeperClientFailedException(e);
                    }
                }
                if (err == null) {
                    U.warn((IgniteLogger)this.log, (Object)("ZooKeeper operation failed, will retry [err=" + e + ", retryTimeout=" + RETRY_TIMEOUT + ", connLossTimeout=" + this.connLossTimeout + ", path=" + ((KeeperException)e).getPath() + ", remainingWaitTime=" + remainingTime + ']'));
                    this.stateMux.wait(RETRY_TIMEOUT);
                    if (this.closing) {
                        throw new ZookeeperClientFailedException("ZooKeeper client is closed.");
                    }
                }
            } else {
                U.error((IgniteLogger)this.log, (Object)("Operation failed with unexpected error, close ZooKeeper client: " + e), (Throwable)e);
                this.state = ConnectionState.Lost;
                err = new ZookeeperClientFailedException(e);
            }
        }
        if (err != null) {
            this.closeClient();
            this.notifyConnectionLost();
            throw err;
        }
    }

    private boolean needRetry(int code) {
        boolean retryByErrorCode;
        boolean bl = retryByErrorCode = code == KeeperException.Code.CONNECTIONLOSS.intValue() || code == KeeperException.Code.SESSIONMOVED.intValue() || code == KeeperException.Code.OPERATIONTIMEOUT.intValue();
        if (retryByErrorCode) {
            return MAX_RETRY_COUNT <= 0 || this.retryCount.incrementAndGet() < MAX_RETRY_COUNT;
        }
        return false;
    }

    private void closeClient() {
        try {
            this.zk.close();
        }
        catch (Exception closeErr) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to close ZooKeeper client: " + closeErr), (Object)closeErr);
        }
        this.connTimer.cancel();
    }

    private void scheduleConnectionCheck() {
        assert (this.state == ConnectionState.Disconnected) : this.state;
        this.connTimer.schedule((TimerTask)new ConnectionTimeoutTask(this.connStartTime), this.connLossTimeout);
    }

    private static enum ConnectionState {
        Connected,
        Disconnected,
        Lost;

    }

    private class ConnectionTimeoutTask
    extends TimerTask {
        private final long connectStartTime;

        ConnectionTimeoutTask(long connectStartTime) {
            this.connectStartTime = connectStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean connLoss = false;
            Object object = ZookeeperClient.this.stateMux;
            synchronized (object) {
                if (ZookeeperClient.this.closing) {
                    return;
                }
                if (ZookeeperClient.this.state == ConnectionState.Disconnected && ZookeeperClient.this.connStartTime == this.connectStartTime) {
                    ZookeeperClient.this.state = ConnectionState.Lost;
                    U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to establish ZooKeeper connection, close client [timeout=" + ZookeeperClient.this.connLossTimeout + ']'));
                    connLoss = true;
                }
            }
            if (connLoss) {
                ZookeeperClient.this.closeClient();
                ZookeeperClient.this.notifyConnectionLost();
            }
        }
    }

    class StatCallbackWrapper
    implements AsyncCallback.StatCallback {
        private final ExistsOperation op;

        private StatCallbackWrapper(ExistsOperation op) {
            this.op = op;
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (ZookeeperClient.this.closing) {
                return;
            }
            if (ZookeeperClient.this.needRetry(rc)) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost. Will retry after connection restore [path=" + path + ']'));
                ZookeeperClient.this.retryQ.add(this.op);
            } else if (rc == KeeperException.Code.SESSIONEXPIRED.intValue()) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost [path=" + path + ']'));
            } else {
                this.op.cb.processResult(rc, path, ctx, stat);
            }
        }
    }

    class DataCallbackWrapper
    implements AsyncCallback.DataCallback {
        private final GetDataOperation op;

        private DataCallbackWrapper(GetDataOperation op) {
            this.op = op;
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            if (ZookeeperClient.this.closing) {
                return;
            }
            if (ZookeeperClient.this.needRetry(rc)) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost. Will retry after connection restore [path=" + path + ']'));
                ZookeeperClient.this.retryQ.add(this.op);
            } else if (rc == KeeperException.Code.SESSIONEXPIRED.intValue()) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost [path=" + path + ']'));
            } else {
                this.op.cb.processResult(rc, path, ctx, data, stat);
            }
        }
    }

    class ChildrenCallbackWrapper
    implements AsyncCallback.Children2Callback {
        private final GetChildrenOperation op;

        private ChildrenCallbackWrapper(GetChildrenOperation op) {
            this.op = op;
        }

        public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
            if (ZookeeperClient.this.closing) {
                return;
            }
            if (ZookeeperClient.this.needRetry(rc)) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost. Will retry after connection restore [path=" + path + ']'));
                ZookeeperClient.this.retryQ.add(this.op);
            } else if (rc == KeeperException.Code.SESSIONEXPIRED.intValue()) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost [path=" + path + ']'));
            } else {
                this.op.cb.processResult(rc, path, ctx, children, stat);
            }
        }
    }

    class CreateCallbackWrapper
    implements AsyncCallback.StringCallback {
        final CreateOperation op;

        CreateCallbackWrapper(CreateOperation op) {
            this.op = op;
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            if (ZookeeperClient.this.closing) {
                return;
            }
            if (rc == KeeperException.Code.NODEEXISTS.intValue()) {
                return;
            }
            if (ZookeeperClient.this.needRetry(rc)) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost. Will retry after connection restore [path=" + path + ']'));
                ZookeeperClient.this.retryQ.add(this.op);
            } else if (rc == KeeperException.Code.SESSIONEXPIRED.intValue()) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost [path=" + path + ']'));
            } else if (this.op.cb != null) {
                this.op.cb.processResult(rc, path, ctx, name);
            }
        }
    }

    class DeleteIfExistsOperation
    implements AsyncCallback.VoidCallback,
    ZkAsyncOperation {
        private final String path;

        DeleteIfExistsOperation(String path) {
            this.path = path;
        }

        @Override
        public void execute() {
            ZookeeperClient.this.zk.delete(this.path, -1, (AsyncCallback.VoidCallback)this, null);
        }

        public void processResult(int rc, String path, Object ctx) {
            if (ZookeeperClient.this.closing) {
                return;
            }
            if (rc == KeeperException.Code.NONODE.intValue()) {
                return;
            }
            if (ZookeeperClient.this.needRetry(rc)) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost. Will retry after connection restore [path=" + path + ']'));
                ZookeeperClient.this.retryQ.add(this);
            } else if (rc == KeeperException.Code.SESSIONEXPIRED.intValue()) {
                U.warn((IgniteLogger)ZookeeperClient.this.log, (Object)("Failed to execute async operation, connection lost [path=" + path + ']'));
            } else assert (rc == 0) : KeeperException.Code.get((int)rc);
        }
    }

    class CreateOperation
    implements ZkAsyncOperation {
        private final String path;
        private final byte[] data;
        private final CreateMode createMode;
        private final AsyncCallback.StringCallback cb;

        CreateOperation(String path, byte[] data, CreateMode createMode, AsyncCallback.StringCallback cb) {
            this.path = path;
            this.data = data;
            this.createMode = createMode;
            this.cb = cb;
        }

        @Override
        public void execute() {
            ZookeeperClient.this.createAsync(this.path, this.data, this.createMode, this.cb);
        }
    }

    class ExistsOperation
    implements ZkAsyncOperation {
        private final String path;
        private final Watcher watcher;
        private final AsyncCallback.StatCallback cb;

        ExistsOperation(String path, Watcher watcher, AsyncCallback.StatCallback cb) {
            this.path = path;
            this.watcher = watcher;
            this.cb = cb;
        }

        @Override
        public void execute() {
            ZookeeperClient.this.existsAsync(this.path, this.watcher, this.cb);
        }
    }

    class GetDataOperation
    implements ZkAsyncOperation {
        private final String path;
        private final Watcher watcher;
        private final AsyncCallback.DataCallback cb;

        GetDataOperation(String path, Watcher watcher, AsyncCallback.DataCallback cb) {
            this.path = path;
            this.watcher = watcher;
            this.cb = cb;
        }

        @Override
        public void execute() {
            ZookeeperClient.this.getDataAsync(this.path, this.watcher, this.cb);
        }
    }

    class GetChildrenOperation
    implements ZkAsyncOperation {
        private final String path;
        private final Watcher watcher;
        private final AsyncCallback.Children2Callback cb;

        GetChildrenOperation(String path, Watcher watcher, AsyncCallback.Children2Callback cb) {
            this.path = path;
            this.watcher = watcher;
            this.cb = cb;
        }

        @Override
        public void execute() {
            ZookeeperClient.this.getChildrenAsync(this.path, this.watcher, this.cb);
        }
    }

    static interface ZkAsyncOperation {
        public void execute();
    }
}

