/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class LogCLIHelpers
implements Configurable {
    private Configuration conf;

    @InterfaceAudience.Private
    @VisibleForTesting
    public int dumpAContainersLogs(String appId, String containerId, String nodeId, String jobOwner) throws IOException {
        AggregatedLogFormat.LogReader reader;
        Path remoteRootLogDir = new Path(this.getConf().get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String suffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(this.getConf());
        Path logPath = LogAggregationUtils.getRemoteNodeLogFileForApp(remoteRootLogDir, ConverterUtils.toApplicationId(appId), jobOwner, ConverterUtils.toNodeId(nodeId), suffix);
        try {
            reader = new AggregatedLogFormat.LogReader(this.getConf(), logPath);
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("Logs not available at " + logPath.toString());
            System.out.println("Log aggregation has not completed or is not enabled.");
            return -1;
        }
        return this.dumpAContainerLogs(containerId, reader, System.out);
    }

    @InterfaceAudience.Private
    public int dumpAContainerLogs(String containerIdStr, AggregatedLogFormat.LogReader reader, PrintStream out) throws IOException {
        AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
        DataInputStream valueStream = reader.next(key);
        while (valueStream != null && !key.toString().equals(containerIdStr)) {
            key = new AggregatedLogFormat.LogKey();
            valueStream = reader.next(key);
        }
        if (valueStream == null) {
            System.out.println("Logs for container " + containerIdStr + " are not present in this log-file.");
            return -1;
        }
        try {
            while (true) {
                AggregatedLogFormat.LogReader.readAContainerLogsForALogType(valueStream, out);
            }
        }
        catch (EOFException eof) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int dumpAllContainersLogs(ApplicationId appId, String appOwner, PrintStream out) throws IOException {
        RemoteIterator nodeFiles;
        Path remoteRootLogDir = new Path(this.getConf().get("yarn.nodemanager.remote-app-log-dir", "/tmp/logs"));
        String user = appOwner;
        String logDirSuffix = LogAggregationUtils.getRemoteNodeLogDirSuffix(this.getConf());
        Path remoteAppLogDir = LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, logDirSuffix);
        try {
            Path qualifiedLogDir = FileContext.getFileContext((Configuration)this.getConf()).makeQualified(remoteAppLogDir);
            nodeFiles = FileContext.getFileContext((URI)qualifiedLogDir.toUri(), (Configuration)this.getConf()).listStatus(remoteAppLogDir);
        }
        catch (FileNotFoundException fnf) {
            System.out.println("Logs not available at " + remoteAppLogDir.toString());
            System.out.println("Log aggregation has not completed or is not enabled.");
            return -1;
        }
        while (nodeFiles.hasNext()) {
            FileStatus thisNodeFile = (FileStatus)nodeFiles.next();
            AggregatedLogFormat.LogReader reader = new AggregatedLogFormat.LogReader(this.getConf(), new Path(remoteAppLogDir, thisNodeFile.getPath().getName()));
            try {
                AggregatedLogFormat.LogKey key = new AggregatedLogFormat.LogKey();
                DataInputStream valueStream = reader.next(key);
                while (valueStream != null) {
                    String containerString = "\n\nContainer: " + key + " on " + thisNodeFile.getPath().getName();
                    out.println(containerString);
                    out.println(StringUtils.repeat((String)"=", (int)containerString.length()));
                    try {
                        while (true) {
                            AggregatedLogFormat.LogReader.readAContainerLogsForALogType(valueStream, out);
                        }
                    }
                    catch (EOFException eof) {
                        key = new AggregatedLogFormat.LogKey();
                        valueStream = reader.next(key);
                    }
                }
            }
            finally {
                reader.close();
            }
        }
        return 0;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

