/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.log;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LogUtil {
    private static Logger logger;

    static {
        try {
            String resource = "/log4j.properties";
            URL resourceUrl = LogUtil.class.getResource(resource);
            String resourcePath = null;
            resourcePath = resourceUrl == null ? String.valueOf(System.getProperty("user.dir")) + resource : resourceUrl.getPath();
            String GetPath = resourcePath.substring(0, resourcePath.length() - resource.length());
            String filepathLog4j = String.valueOf(GetPath) + "/log4j.properties";
            File fileLog4j = new File(filepathLog4j);
            if (fileLog4j.exists()) {
                PropertyConfigurator.configure((String)URLDecoder.decode(filepathLog4j, "UTF-8"));
                logger = Logger.getLogger(LogUtil.class);
            } else {
                PropertyConfigurator.configure((InputStream)LogUtil.class.getResourceAsStream("/log4j.properties"));
                logger = Logger.getLogger(LogUtil.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void debug(String message) {
        if (logger != null) {
            logger.debug((Object)message);
        } else {
            System.out.println("debug " + message);
        }
    }

    public static void info(String message) {
        if (logger != null) {
            logger.info((Object)message);
        } else {
            System.out.println("info " + message);
        }
    }

    public static void warn(String message) {
        if (logger != null) {
            logger.warn((Object)message);
        } else {
            System.out.println("warn " + message);
        }
    }

    public static void error(String message) {
        if (logger != null) {
            logger.error((Object)message);
        } else {
            System.out.println("error " + message);
        }
    }

    public static void fatal(String message) {
        if (logger != null) {
            logger.fatal((Object)message);
        } else {
            System.out.println("fatal " + message);
        }
    }

    public static synchronized void debug(Exception e) {
        String message = LogUtil.GetExceptionStackTrace(e);
        if (logger != null) {
            logger.debug((Object)message);
        } else {
            System.out.println("debug " + message);
        }
    }

    public static synchronized void info(Exception e) {
        String message = LogUtil.GetExceptionStackTrace(e);
        if (logger != null) {
            logger.info((Object)message);
        } else {
            System.out.println("info " + message);
        }
    }

    public static synchronized void warn(Exception e) {
        String message = LogUtil.GetExceptionStackTrace(e);
        if (logger != null) {
            logger.warn((Object)message);
        } else {
            System.out.println("warn " + message);
        }
    }

    public static synchronized void error(Exception e) {
        String message = LogUtil.GetExceptionStackTrace(e);
        if (logger != null) {
            logger.error((Object)message);
        } else {
            System.out.println("error " + message);
        }
    }

    public static synchronized void fatal(Exception e) {
        String message = LogUtil.GetExceptionStackTrace(e);
        if (logger != null) {
            logger.fatal((Object)message);
        } else {
            System.out.println("fatal " + message);
        }
    }

    private static String GetExceptionStackTrace(Exception e) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u5bee\u509a\u7236: ");
        sb.append("\n");
        sb.append(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
        sb.append("\n");
        StackTraceElement[] elements = e.getStackTrace();
        int i = 0;
        while (i < elements.length) {
            StackTraceElement element = elements[i];
            sb.append("\t" + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")");
            sb.append("\n");
            ++i;
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            sb.append("Caused by: " + cause.getClass().getName() + ": " + cause.getMessage());
            sb.append("\n");
            StackTraceElement[] elements2 = cause.getStackTrace();
            int i2 = 0;
            while (i2 < elements2.length) {
                StackTraceElement element = elements2[i2];
                sb.append("\t" + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")");
                sb.append("\n");
                ++i2;
            }
        }
        return sb.toString();
    }
}

