/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.verify.ValidateIndexesClosure;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskArg;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesTaskResult;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorValidateIndexesTask
extends VisorMultiNodeTask<VisorValidateIndexesTaskArg, VisorValidateIndexesTaskResult, VisorValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;

    @Nullable
    protected VisorValidateIndexesTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        HashMap<UUID, IgniteException> exceptions = new HashMap<UUID, IgniteException>();
        HashMap<UUID, Object> jobResults = new HashMap<UUID, Object>();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            jobResults.put(res.getNode().id(), res.getData());
        }
        return new VisorValidateIndexesTaskResult(jobResults, exceptions);
    }

    protected VisorJob<VisorValidateIndexesTaskArg, VisorValidateIndexesJobResult> job(VisorValidateIndexesTaskArg arg) {
        return new VisorValidateIndexesJob(arg, this.debug);
    }

    private static class VisorValidateIndexesJob
    extends VisorJob<VisorValidateIndexesTaskArg, VisorValidateIndexesJobResult> {
        private static final long serialVersionUID = 0L;

        protected VisorValidateIndexesJob(@Nullable VisorValidateIndexesTaskArg arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorValidateIndexesJobResult run(@Nullable VisorValidateIndexesTaskArg arg) throws IgniteException {
            try {
                ValidateIndexesClosure clo = new ValidateIndexesClosure(arg.getCaches());
                this.ignite.context().resource().injectGeneric((Object)clo);
                Object res = clo.call();
                return new VisorValidateIndexesJobResult((Map)res);
            }
            catch (Exception e) {
                throw new IgniteException((Throwable)e);
            }
        }

        public String toString() {
            return S.toString(VisorValidateIndexesJob.class, (Object)((Object)this));
        }
    }
}

