/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.internal.processors.query.h2.H2CachedStatementKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

class H2StatementCache
extends LinkedHashMap<H2CachedStatementKey, PreparedStatement> {
    private int size;
    private volatile long lastUsage;

    H2StatementCache(int size) {
        super(size, 0.75f, true);
        this.size = size;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<H2CachedStatementKey, PreparedStatement> eldest) {
        boolean rmv;
        boolean bl = rmv = this.size() > this.size;
        if (rmv) {
            PreparedStatement stmt = eldest.getValue();
            U.closeQuiet((AutoCloseable)stmt);
        }
        return rmv;
    }

    @Nullable
    public PreparedStatement get(String schemaName, String sql) {
        return (PreparedStatement)this.get(new H2CachedStatementKey(schemaName, sql));
    }

    public long lastUsage() {
        return this.lastUsage;
    }

    public void updateLastUsage() {
        this.lastUsage = U.currentTimeMillis();
    }

    @Nullable
    public PreparedStatement remove(String schemaName, String sql) {
        return (PreparedStatement)this.remove(new H2CachedStatementKey(schemaName, sql));
    }
}

