/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.tx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxMapping;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cache.transactions.TransactionProxyImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.tx.VisorTxInfo;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.transactions.Transaction;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorTxTask
extends VisorMultiNodeTask<VisorTxTaskArg, Map<ClusterNode, VisorTxTaskResult>, VisorTxTaskResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<VisorTxTaskArg, VisorTxTaskResult> job(VisorTxTaskArg arg) {
        return new VisorTxJob(arg, this.debug);
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<VisorTxTaskArg> arg) {
        final VisorTxTaskArg taskArg = arg.getArgument();
        if (taskArg.getConsistentIds() != null) {
            return F.transform(this.ignite.cluster().forPredicate(new IgnitePredicate<ClusterNode>(){

                @Override
                public boolean apply(ClusterNode node) {
                    return taskArg.getConsistentIds().contains(node.consistentId().toString());
                }
            }).nodes(), new IgniteClosure<ClusterNode, UUID>(){

                @Override
                public UUID apply(ClusterNode node) {
                    return node.id();
                }
            });
        }
        if (taskArg.getProjection() == VisorTxProjection.SERVER) {
            return F.transform(this.ignite.cluster().forServers().nodes(), new IgniteClosure<ClusterNode, UUID>(){

                @Override
                public UUID apply(ClusterNode node) {
                    return node.id();
                }
            });
        }
        if (taskArg.getProjection() == VisorTxProjection.CLIENT) {
            return F.transform(this.ignite.cluster().forClients().nodes(), new IgniteClosure<ClusterNode, UUID>(){

                @Override
                public UUID apply(ClusterNode node) {
                    return node.id();
                }
            });
        }
        return F.transform(this.ignite.cluster().nodes(), new IgniteClosure<ClusterNode, UUID>(){

            @Override
            public UUID apply(ClusterNode node) {
                return node.id();
            }
        });
    }

    @Override
    @Nullable
    protected Map<ClusterNode, VisorTxTaskResult> reduce0(List<ComputeJobResult> results) throws IgniteException {
        TreeMap<ClusterNode, VisorTxTaskResult> mapRes = new TreeMap<ClusterNode, VisorTxTaskResult>();
        for (ComputeJobResult result : results) {
            VisorTxTaskResult data = (VisorTxTaskResult)result.getData();
            if (data == null || data.getInfos().isEmpty()) continue;
            mapRes.put(result.getNode(), data);
        }
        return mapRes;
    }

    private static class TxSizeComparator
    implements Comparator<VisorTxInfo> {
        public static final TxSizeComparator INSTANCE = new TxSizeComparator();

        private TxSizeComparator() {
        }

        @Override
        public int compare(VisorTxInfo o1, VisorTxInfo o2) {
            return Long.compare(o2.getSize(), o1.getSize());
        }
    }

    private static class TxDurationComparator
    implements Comparator<VisorTxInfo> {
        public static final TxDurationComparator INSTANCE = new TxDurationComparator();

        private TxDurationComparator() {
        }

        @Override
        public int compare(VisorTxInfo o1, VisorTxInfo o2) {
            return Long.compare(o2.getDuration(), o1.getDuration());
        }
    }

    private static class VisorTxJob
    extends VisorJob<VisorTxTaskArg, VisorTxTaskResult> {
        private static final long serialVersionUID = 0L;
        public static final int DEFAULT_LIMIT = 50;

        private VisorTxJob(VisorTxTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorTxTaskResult run(@Nullable VisorTxTaskArg arg) throws IgniteException {
            if (arg == null) {
                return new VisorTxTaskResult(Collections.emptyList());
            }
            Collection<Transaction> transactions = this.ignite.transactions().localActiveTransactions();
            ArrayList<VisorTxInfo> infos = new ArrayList<VisorTxInfo>();
            int limit = arg.getLimit() == null ? 50 : arg.getLimit();
            Pattern lbMatch = null;
            if (arg.getLabelRegex() != null) {
                try {
                    lbMatch = Pattern.compile(arg.getLabelRegex());
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
            for (Transaction transaction : transactions) {
                GridNearTxLocal locTx = ((TransactionProxyImpl)transaction).tx();
                if (arg.getXid() != null && !locTx.xid().toString().equals(arg.getXid()) || arg.getState() != null && locTx.state() != arg.getState()) continue;
                long duration = U.currentTimeMillis() - transaction.startTime();
                if (arg.getMinDuration() != null && duration < arg.getMinDuration() || arg.getMinSize() != null && locTx.size() < arg.getMinSize() || lbMatch != null && (locTx.label() == null || !lbMatch.matcher(locTx.label()).matches())) continue;
                ArrayList<UUID> mappings = new ArrayList<UUID>();
                int size = 0;
                if (locTx.mappings() != null) {
                    for (GridDistributedTxMapping mapping : locTx.mappings().mappings()) {
                        mappings.add(mapping.primary().id());
                        size += mapping.entries().size();
                    }
                }
                infos.add(new VisorTxInfo(locTx.xid(), duration, locTx.isolation(), locTx.concurrency(), locTx.timeout(), locTx.label(), mappings, locTx.state(), size));
                if (arg.getOperation() == VisorTxOperation.KILL) {
                    locTx.rollbackAsync();
                }
                if (infos.size() != limit) continue;
                break;
            }
            Comparator<VisorTxInfo> comp = TxDurationComparator.INSTANCE;
            if (arg.getSortOrder() != null) {
                switch (arg.getSortOrder()) {
                    case DURATION: {
                        comp = TxDurationComparator.INSTANCE;
                        break;
                    }
                    case SIZE: {
                        comp = TxSizeComparator.INSTANCE;
                        break;
                    }
                }
            }
            Collections.sort(infos, comp);
            return new VisorTxTaskResult(infos);
        }
    }
}

