/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorBasicConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String igniteInstanceName;
    private String ggHome;
    private String locHost;
    private String marsh;
    private DeploymentMode deployMode;
    private Boolean clientMode;
    private boolean daemon;
    private boolean jmxRemote;
    private boolean restart;
    private long netTimeout;
    private String log;
    private long discoStartupDelay;
    private String mBeanSrv;
    private boolean noAscii;
    private boolean noDiscoOrder;
    private boolean noShutdownHook;
    private String progName;
    private boolean quiet;
    private String successFile;
    private boolean updateNtf;
    private boolean activeOnStart;
    private String addrRslvr;
    private boolean cacheSanityCheckEnabled;
    private String clsLdr;
    private String consistentId;
    private Long failureDetectionTimeout;
    private String igniteWorkDir;
    private boolean lateAffAssignment;
    private boolean marshLocJobs;
    private long metricsUpdateFreq;
    private Long clientFailureDetectionTimeout;
    private int sndRetryCnt;
    private long sndRetryDelay;
    private int timeSrvPortBase;
    private int timeSrvPortRange;
    private long utilityCacheKeepAliveTime;

    public VisorBasicConfiguration() {
    }

    public VisorBasicConfiguration(IgniteEx ignite, IgniteConfiguration c) {
        this.igniteInstanceName = c.getIgniteInstanceName();
        this.ggHome = System.getProperty("IGNITE_HOME", c.getIgniteHome());
        this.locHost = System.getProperty("IGNITE_LOCAL_HOST", c.getLocalHost());
        this.marsh = VisorTaskUtils.compactClass(c.getMarshaller());
        this.deployMode = c.getDeploymentMode();
        this.clientMode = c.isClientMode();
        this.daemon = VisorTaskUtils.boolValue("IGNITE_DAEMON", c.isDaemon());
        this.jmxRemote = ignite.isJmxRemoteEnabled();
        this.restart = ignite.isRestartEnabled();
        this.netTimeout = c.getNetworkTimeout();
        this.log = VisorTaskUtils.compactClass(c.getGridLogger());
        this.discoStartupDelay = c.getDiscoveryStartupDelay();
        this.mBeanSrv = VisorTaskUtils.compactClass(c.getMBeanServer());
        this.noAscii = VisorTaskUtils.boolValue("IGNITE_NO_ASCII", false);
        this.noDiscoOrder = VisorTaskUtils.boolValue("IGNITE_NO_DISCO_ORDER", false);
        this.noShutdownHook = VisorTaskUtils.boolValue("IGNITE_NO_SHUTDOWN_HOOK", false);
        this.progName = System.getProperty("IGNITE_PROG_NAME");
        this.quiet = VisorTaskUtils.boolValue("IGNITE_QUIET", true);
        this.successFile = System.getProperty("IGNITE_SUCCESS_FILE");
        this.updateNtf = VisorTaskUtils.boolValue("IGNITE_UPDATE_NOTIFIER", true);
        this.activeOnStart = c.isActiveOnStart();
        this.addrRslvr = VisorTaskUtils.compactClass(c.getAddressResolver());
        this.cacheSanityCheckEnabled = c.isCacheSanityCheckEnabled();
        this.clsLdr = VisorTaskUtils.compactClass(c.getClassLoader());
        this.consistentId = c.getConsistentId() != null ? String.valueOf(c.getConsistentId()) : null;
        this.failureDetectionTimeout = c.getFailureDetectionTimeout();
        this.igniteWorkDir = c.getWorkDirectory();
        this.lateAffAssignment = c.isLateAffinityAssignment();
        this.marshLocJobs = c.isMarshalLocalJobs();
        this.metricsUpdateFreq = c.getMetricsUpdateFrequency();
        this.clientFailureDetectionTimeout = c.getClientFailureDetectionTimeout();
        this.sndRetryCnt = c.getNetworkSendRetryCount();
        this.sndRetryDelay = c.getNetworkSendRetryDelay();
        this.timeSrvPortBase = c.getTimeServerPortBase();
        this.timeSrvPortRange = c.getTimeServerPortRange();
        this.utilityCacheKeepAliveTime = c.getUtilityCacheKeepAliveTime();
    }

    @Nullable
    public String getIgniteInstanceName() {
        return this.igniteInstanceName;
    }

    @Nullable
    public String getGgHome() {
        return this.ggHome;
    }

    @Nullable
    public String getLocalHost() {
        return this.locHost;
    }

    public String getMarshaller() {
        return this.marsh;
    }

    public Object getDeploymentMode() {
        return this.deployMode;
    }

    public Boolean isClientMode() {
        return this.clientMode;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public boolean isJmxRemote() {
        return this.jmxRemote;
    }

    public boolean isRestart() {
        return this.restart;
    }

    public long getNetworkTimeout() {
        return this.netTimeout;
    }

    public String getLogger() {
        return this.log;
    }

    public long getDiscoStartupDelay() {
        return this.discoStartupDelay;
    }

    @Nullable
    public String getMBeanServer() {
        return this.mBeanSrv;
    }

    public boolean isNoAscii() {
        return this.noAscii;
    }

    public boolean isNoDiscoOrder() {
        return this.noDiscoOrder;
    }

    public boolean isNoShutdownHook() {
        return this.noShutdownHook;
    }

    public String getProgramName() {
        return this.progName;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String getSuccessFile() {
        return this.successFile;
    }

    public boolean isUpdateNotifier() {
        return this.updateNtf;
    }

    public boolean isActiveOnStart() {
        return this.activeOnStart;
    }

    public String getAddressResolver() {
        return this.addrRslvr;
    }

    public boolean isCacheSanityCheckEnabled() {
        return this.cacheSanityCheckEnabled;
    }

    public String getClassLoader() {
        return this.clsLdr;
    }

    public String getConsistentId() {
        return this.consistentId;
    }

    public Long getFailureDetectionTimeout() {
        return this.failureDetectionTimeout;
    }

    public String getWorkDirectory() {
        return this.igniteWorkDir;
    }

    public boolean isLateAffinityAssignment() {
        return this.lateAffAssignment;
    }

    public boolean isMarshalLocalJobs() {
        return this.marshLocJobs;
    }

    public long getMetricsUpdateFrequency() {
        return this.metricsUpdateFreq;
    }

    public Long getClientFailureDetectionTimeout() {
        return this.clientFailureDetectionTimeout;
    }

    public int getNetworkSendRetryCount() {
        return this.sndRetryCnt;
    }

    public long getNetworkSendRetryDelay() {
        return this.sndRetryDelay;
    }

    public int getTimeServerPortBase() {
        return this.timeSrvPortBase;
    }

    public int getTimeServerPortRange() {
        return this.timeSrvPortRange;
    }

    public long getUtilityCacheKeepAliveTime() {
        return this.utilityCacheKeepAliveTime;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.igniteInstanceName);
        U.writeString(out, this.ggHome);
        U.writeString(out, this.locHost);
        U.writeString(out, this.marsh);
        U.writeEnum(out, this.deployMode);
        out.writeObject(this.clientMode);
        out.writeBoolean(this.daemon);
        out.writeBoolean(this.jmxRemote);
        out.writeBoolean(this.restart);
        out.writeLong(this.netTimeout);
        U.writeString(out, this.log);
        out.writeLong(this.discoStartupDelay);
        U.writeString(out, this.mBeanSrv);
        out.writeBoolean(this.noAscii);
        out.writeBoolean(this.noDiscoOrder);
        out.writeBoolean(this.noShutdownHook);
        U.writeString(out, this.progName);
        out.writeBoolean(this.quiet);
        U.writeString(out, this.successFile);
        out.writeBoolean(this.updateNtf);
        out.writeBoolean(this.activeOnStart);
        U.writeString(out, this.addrRslvr);
        out.writeBoolean(this.cacheSanityCheckEnabled);
        U.writeString(out, this.clsLdr);
        U.writeString(out, this.consistentId);
        out.writeObject(this.failureDetectionTimeout);
        U.writeString(out, this.igniteWorkDir);
        out.writeBoolean(this.lateAffAssignment);
        out.writeBoolean(this.marshLocJobs);
        out.writeLong(this.metricsUpdateFreq);
        out.writeObject(this.clientFailureDetectionTimeout);
        out.writeInt(this.sndRetryCnt);
        out.writeLong(this.sndRetryDelay);
        out.writeInt(this.timeSrvPortBase);
        out.writeInt(this.timeSrvPortRange);
        out.writeLong(this.utilityCacheKeepAliveTime);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.igniteInstanceName = U.readString(in);
        this.ggHome = U.readString(in);
        this.locHost = U.readString(in);
        this.marsh = U.readString(in);
        this.deployMode = DeploymentMode.fromOrdinal(in.readByte());
        this.clientMode = (Boolean)in.readObject();
        this.daemon = in.readBoolean();
        this.jmxRemote = in.readBoolean();
        this.restart = in.readBoolean();
        this.netTimeout = in.readLong();
        this.log = U.readString(in);
        this.discoStartupDelay = in.readLong();
        this.mBeanSrv = U.readString(in);
        this.noAscii = in.readBoolean();
        this.noDiscoOrder = in.readBoolean();
        this.noShutdownHook = in.readBoolean();
        this.progName = U.readString(in);
        this.quiet = in.readBoolean();
        this.successFile = U.readString(in);
        this.updateNtf = in.readBoolean();
        this.activeOnStart = in.readBoolean();
        this.addrRslvr = U.readString(in);
        this.cacheSanityCheckEnabled = in.readBoolean();
        this.clsLdr = U.readString(in);
        this.consistentId = U.readString(in);
        this.failureDetectionTimeout = (Long)in.readObject();
        this.igniteWorkDir = U.readString(in);
        this.lateAffAssignment = in.readBoolean();
        this.marshLocJobs = in.readBoolean();
        this.metricsUpdateFreq = in.readLong();
        this.clientFailureDetectionTimeout = (Long)in.readObject();
        this.sndRetryCnt = in.readInt();
        this.sndRetryDelay = in.readLong();
        this.timeSrvPortBase = in.readInt();
        this.timeSrvPortRange = in.readInt();
        this.utilityCacheKeepAliveTime = in.readLong();
    }

    public String toString() {
        return S.toString(VisorBasicConfiguration.class, this);
    }
}

