/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.cache.VisorCacheMetrics;
import org.apache.ignite.lang.IgniteUuid;

public class VisorCache
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private static final CachePeekMode[] PEEK_ONHEAP_PRIMARY = new CachePeekMode[]{CachePeekMode.ONHEAP, CachePeekMode.PRIMARY};
    private static final CachePeekMode[] PEEK_ONHEAP_BACKUP = new CachePeekMode[]{CachePeekMode.ONHEAP, CachePeekMode.BACKUP};
    private String name;
    private IgniteUuid dynamicDeploymentId;
    private CacheMode mode;
    private long memorySize;
    private long indexesSize;
    private long size;
    private int nearSize;
    private long primarySize;
    private long backupSize;
    private int partitions;
    private boolean near;
    private VisorCacheMetrics metrics;
    private boolean sys;

    public VisorCache() {
    }

    public VisorCache(IgniteEx ignite, GridCacheAdapter ca, boolean collectMetrics) throws IgniteCheckedException {
        assert (ca != null);
        GridCacheContext cctx = ca.context();
        CacheConfiguration cfg = ca.configuration();
        this.name = ca.name();
        this.dynamicDeploymentId = cctx.dynamicDeploymentId();
        this.mode = cfg.getCacheMode();
        this.primarySize = ca.localSizeLong(PEEK_ONHEAP_PRIMARY);
        this.backupSize = ca.localSizeLong(PEEK_ONHEAP_BACKUP);
        this.nearSize = ca.nearSize();
        this.size = this.primarySize + this.backupSize + (long)this.nearSize;
        this.partitions = ca.affinity().partitions();
        this.near = cctx.isNear();
        if (collectMetrics) {
            this.metrics = new VisorCacheMetrics(ignite, this.name);
        }
        this.sys = ignite.context().cache().systemCache(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IgniteUuid getDynamicDeploymentId() {
        return this.dynamicDeploymentId;
    }

    public CacheMode getMode() {
        return this.mode;
    }

    public long getMemorySize() {
        return this.memorySize;
    }

    public long getIndexesSize() {
        return this.indexesSize;
    }

    public long getSize() {
        return this.size;
    }

    public int getNearSize() {
        return this.nearSize;
    }

    public long getBackupSize() {
        return this.backupSize;
    }

    public long getPrimarySize() {
        return this.primarySize;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public VisorCacheMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(VisorCacheMetrics metrics) {
        this.metrics = metrics;
    }

    public boolean isNear() {
        return this.near;
    }

    public boolean isSystem() {
        return this.sys;
    }

    public long size() {
        return this.size + (this.metrics != null ? this.metrics.getOffHeapEntriesCount() : 0L);
    }

    public long offHeapAllocatedSize() {
        return this.metrics != null ? this.metrics.getOffHeapAllocatedSize() : 0L;
    }

    public long heapEntriesCount() {
        return this.metrics != null ? this.metrics.getHeapEntriesCount() : 0L;
    }

    public long offHeapPrimaryEntriesCount() {
        return this.metrics != null ? this.metrics.getOffHeapPrimaryEntriesCount() : 0L;
    }

    public long offHeapBackupEntriesCount() {
        return this.metrics != null ? this.metrics.getOffHeapBackupEntriesCount() : 0L;
    }

    public long offHeapEntriesCount() {
        return this.metrics != null ? this.metrics.getOffHeapEntriesCount() : 0L;
    }

    @Override
    public byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        U.writeGridUuid(out, this.dynamicDeploymentId);
        U.writeEnum(out, this.mode);
        out.writeLong(this.memorySize);
        out.writeLong(this.indexesSize);
        out.writeLong(this.size);
        out.writeInt(this.nearSize);
        out.writeLong(this.primarySize);
        out.writeLong(this.backupSize);
        out.writeInt(this.partitions);
        out.writeBoolean(this.near);
        out.writeObject(this.metrics);
        out.writeBoolean(this.sys);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.dynamicDeploymentId = U.readGridUuid(in);
        this.mode = CacheMode.fromOrdinal(in.readByte());
        this.memorySize = in.readLong();
        this.indexesSize = in.readLong();
        this.size = in.readLong();
        this.nearSize = in.readInt();
        this.primarySize = in.readLong();
        this.backupSize = in.readLong();
        this.partitions = in.readInt();
        this.near = in.readBoolean();
        this.metrics = (VisorCacheMetrics)in.readObject();
        this.sys = protoVer > 1 ? in.readBoolean() : this.metrics != null && this.metrics.isSystem();
    }

    public String toString() {
        return S.toString(VisorCache.class, this);
    }
}

