/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.ipc.shmem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.util.ipc.shmem.IpcSharedMemoryOperationTimedoutException;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IpcSharedMemoryUtils {
    static native long allocateSystemResources(String var0, int var1, boolean var2) throws IgniteCheckedException;

    static native long attach(int var0, boolean var1) throws IgniteCheckedException;

    static native void ipcClose(long var0);

    static native void freeSystemResources(String var0, long var1, boolean var3);

    static native void freeSystemResources(String var0, int var1);

    static native long readSharedMemory(long var0, byte[] var2, long var3, long var5, long var7) throws IgniteCheckedException, IpcSharedMemoryOperationTimedoutException;

    static native int unreadCount(long var0);

    static native int sharedMemoryId(long var0);

    static native int semaphoreId(long var0);

    static native long readSharedMemoryByteBuffer(long var0, ByteBuffer var2, long var3, long var5, long var7) throws IgniteCheckedException, IpcSharedMemoryOperationTimedoutException;

    static native void writeSharedMemory(long var0, byte[] var2, long var3, long var5, long var7) throws IgniteCheckedException, IpcSharedMemoryOperationTimedoutException;

    static native void writeSharedMemoryByteBuffer(long var0, ByteBuffer var2, long var3, long var5, long var7) throws IgniteCheckedException, IpcSharedMemoryOperationTimedoutException;

    public static int pid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        try {
            int idx = name.indexOf(64);
            return idx > 0 ? Integer.parseInt(name.substring(0, idx)) : -1;
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    static native boolean alive(int var0);

    static Collection<Integer> sharedMemoryIds() throws IOException, InterruptedException {
        if (U.isMacOs() || U.isLinux()) {
            return IpcSharedMemoryUtils.sharedMemoryIdsOnMacOS();
        }
        throw new IllegalStateException("Current OS is not supported.");
    }

    static IgniteCheckedException linkError(UnsatisfiedLinkError e) {
        return new IgniteCheckedException("Linkage error due to possible native library, libigniteshmem.so, version mismatch (stop all grid nodes, clean up your '/tmp' folder, and try again).", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Collection<Integer> sharedMemoryIdsOnMacOS() throws IOException, InterruptedException {
        Process proc = Runtime.getRuntime().exec("ipcs -m");
        BufferedReader rdr = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        ArrayList<Integer> ret = new ArrayList<Integer>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if (!line.startsWith(IpcSharedMemoryUtils.getPlatformDependentLineStartFlag())) continue;
                String[] toks = line.split(" ");
                try {
                    ret.add(Integer.parseInt(toks[1]));
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            ArrayList<Integer> arrayList = ret;
            return arrayList;
        }
        finally {
            proc.waitFor();
        }
    }

    private static String getPlatformDependentLineStartFlag() {
        if (U.isMacOs()) {
            return "m ";
        }
        if (U.isLinux()) {
            return "0x";
        }
        throw new IllegalStateException("This OS is not supported.");
    }
}

