/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridCacheQueryResponse
extends GridCacheIdMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    private boolean finished;
    private long reqId;
    @GridDirectTransient
    private Throwable err;
    private byte[] errBytes;
    private boolean fields;
    @GridDirectCollection(value=byte[].class)
    private Collection<byte[]> metaDataBytes;
    @GridToStringInclude
    @GridDirectTransient
    private List<GridQueryFieldMetadata> metadata;
    @GridDirectCollection(value=byte[].class)
    private Collection<byte[]> dataBytes;
    @GridDirectTransient
    private Collection<Object> data;

    public GridCacheQueryResponse() {
    }

    public GridCacheQueryResponse(int cacheId, long reqId, boolean finished, boolean fields, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.reqId = reqId;
        this.finished = finished;
        this.fields = fields;
        this.addDepInfo = addDepInfo;
    }

    public GridCacheQueryResponse(int cacheId, long reqId, Throwable err, boolean addDepInfo) {
        this.cacheId = cacheId;
        this.reqId = reqId;
        this.err = err;
        this.addDepInfo = addDepInfo;
        this.finished = true;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (this.err != null && this.errBytes == null) {
            this.errBytes = U.marshal(ctx, (Object)this.err);
        }
        if (this.metaDataBytes == null && this.metadata != null) {
            this.metaDataBytes = this.marshalCollection(this.metadata, cctx);
        }
        if (this.dataBytes == null && this.data != null) {
            this.dataBytes = this.marshalCollection(this.data, cctx);
        }
        if (this.addDepInfo && !F.isEmpty(this.data)) {
            for (Object o : this.data) {
                if (!(o instanceof Map.Entry)) continue;
                Map.Entry e = (Map.Entry)o;
                this.prepareObject(e.getKey(), cctx);
                this.prepareObject(e.getValue(), cctx);
            }
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.errBytes != null && this.err == null) {
            this.err = (Throwable)U.unmarshal(ctx, this.errBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.metadata == null) {
            this.metadata = this.unmarshalCollection(this.metaDataBytes, ctx, ldr);
        }
        if (this.data == null) {
            this.data = this.unmarshalCollection0(this.dataBytes, ctx, ldr);
        }
    }

    @Nullable
    protected <T> List<T> unmarshalCollection0(@Nullable Collection<byte[]> byteCol, GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        assert (ldr != null);
        assert (ctx != null);
        if (byteCol == null) {
            return null;
        }
        ArrayList<Object> col = new ArrayList<Object>(byteCol.size());
        Marshaller marsh = ctx.marshaller();
        ClassLoader ldr0 = U.resolveClassLoader(ldr, ctx.gridConfig());
        CacheObjectContext cacheObjCtx = null;
        for (byte[] bytes : byteCol) {
            Object key;
            Object obj;
            Object e = obj = bytes == null ? null : (Object)marsh.unmarshal(bytes, ldr0);
            if (obj instanceof Map.Entry && (key = ((Map.Entry)obj).getKey()) instanceof KeyCacheObject) {
                if (cacheObjCtx == null) {
                    cacheObjCtx = ctx.cacheContext(this.cacheId).cacheObjectContext();
                }
                ((KeyCacheObject)key).finishUnmarshal(cacheObjCtx, ldr0);
            }
            col.add(obj);
        }
        return col;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    public List<GridQueryFieldMetadata> metadata() {
        return this.metadata;
    }

    public void metadata(@Nullable List<GridQueryFieldMetadata> metadata) {
        this.metadata = metadata;
    }

    public Collection<Object> data() {
        return this.data;
    }

    public void data(Collection<?> data) {
        this.data = data;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void finished(boolean finished) {
        this.finished = finished;
    }

    public long requestId() {
        return this.reqId;
    }

    @Override
    public Throwable error() {
        return this.err;
    }

    public boolean fields() {
        return this.fields;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 3: {
                if (!writer.writeCollection("dataBytes", this.dataBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeByteArray("errBytes", this.errBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeBoolean("fields", this.fields)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeBoolean("finished", this.finished)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeCollection("metaDataBytes", this.metaDataBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeLong("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 3: {
                this.dataBytes = reader.readCollection("dataBytes", MessageCollectionItemType.BYTE_ARR);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.errBytes = reader.readByteArray("errBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.fields = reader.readBoolean("fields");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.finished = reader.readBoolean("finished");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.metaDataBytes = reader.readCollection("metaDataBytes", MessageCollectionItemType.BYTE_ARR);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.reqId = reader.readLong("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheQueryResponse.class);
    }

    @Override
    public short directType() {
        return 59;
    }

    @Override
    public byte fieldsCount() {
        return 9;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheQueryResponse.class, this);
    }
}

