/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.affinity.GridAffinityAssignment;
import org.apache.ignite.internal.processors.affinity.GridAffinityMessage;
import org.apache.ignite.internal.processors.affinity.GridAffinityUtils;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridTuple3;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridAffinityProcessor
extends GridProcessorAdapter {
    private static final long AFFINITY_MAP_CLEAN_UP_DELAY = 3000L;
    private static final int ERROR_RETRIES = 3;
    private static final long ERROR_WAIT = 500L;
    private final ConcurrentMap<AffinityAssignmentKey, IgniteInternalFuture<AffinityInfo>> affMap = new ConcurrentHashMap<AffinityAssignmentKey, IgniteInternalFuture<AffinityInfo>>();
    private final GridLocalEventListener lsnr = new GridLocalEventListener(){

        @Override
        public void onEvent(Event evt) {
            int evtType = evt.type();
            assert (evtType == 12 || evtType == 11 || evtType == 10);
            if (GridAffinityProcessor.this.affMap.isEmpty()) {
                return;
            }
            DiscoveryEvent discoEvt = (DiscoveryEvent)evt;
            if (evtType == 12 || evtType == 11) {
                Collection<String> caches = GridAffinityProcessor.this.ctx.cache().cacheNames();
                final HashSet<AffinityAssignmentKey> rmv = new HashSet<AffinityAssignmentKey>();
                for (AffinityAssignmentKey key : GridAffinityProcessor.this.affMap.keySet()) {
                    if (caches.contains(key.cacheName) && key.topVer.topologyVersion() >= discoEvt.topologyVersion() - 10L) continue;
                    rmv.add(key);
                }
                if (!rmv.isEmpty()) {
                    GridAffinityProcessor.this.ctx.timeout().addTimeoutObject(new GridTimeoutObjectAdapter(IgniteUuid.fromUuid(GridAffinityProcessor.this.ctx.localNodeId()), 3000L){

                        @Override
                        public void onTimeout() {
                            GridAffinityProcessor.this.affMap.keySet().removeAll(rmv);
                        }
                    });
                }
            }
        }
    };

    public GridAffinityProcessor(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.ctx.event().addLocalEventListener(this.lsnr, 12, 11, 10);
    }

    @Override
    public void onKernalStop(boolean cancel) {
        this.ctx.event().removeLocalEventListener(this.lsnr, new int[0]);
    }

    public int partition(String cacheName, Object key) throws IgniteCheckedException {
        return this.partition(cacheName, key, null);
    }

    public int partition(String cacheName, Object key, @Nullable AffinityInfo aff) throws IgniteCheckedException {
        int part;
        assert (cacheName != null);
        if (key instanceof KeyCacheObject && (part = ((KeyCacheObject)key).partition()) >= 0) {
            return part;
        }
        return this.partition0(cacheName, key, aff);
    }

    public int partition0(String cacheName, Object key, @Nullable AffinityInfo aff) throws IgniteCheckedException {
        assert (cacheName != null);
        if (aff == null && (aff = this.affinityCache(cacheName, this.ctx.cache().context().exchange().readyAffinityVersion())) == null) {
            throw new IgniteCheckedException("Failed to get cache affinity (cache was not started yet or cache was already stopped): " + cacheName);
        }
        return aff.affFunc.partition(aff.affinityKey(key));
    }

    @Nullable
    public ClusterNode mapPartitionToNode(String cacheName, int partId, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (cacheName != null);
        AffinityInfo affInfo = this.affinityCache(cacheName, topVer);
        return affInfo != null ? F.first(affInfo.assignment().get(partId)) : null;
    }

    public <K> Map<ClusterNode, Collection<K>> mapKeysToNodes(String cacheName, @Nullable Collection<? extends K> keys) throws IgniteCheckedException {
        assert (cacheName != null);
        return this.keysToNodes(cacheName, keys);
    }

    @Nullable
    public <K> ClusterNode mapKeyToNode(String cacheName, K key) throws IgniteCheckedException {
        assert (cacheName != null);
        Map<ClusterNode, Collection<K>> map = this.keysToNodes(cacheName, F.asList(key));
        return !F.isEmpty(map) ? F.first(map.keySet()) : null;
    }

    @Nullable
    public <K> ClusterNode mapKeyToNode(String cacheName, K key, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (cacheName != null);
        Map<ClusterNode, Collection<K>> map = this.keysToNodes(cacheName, F.asList(key), topVer);
        return map != null ? F.first(map.keySet()) : null;
    }

    public <K> List<ClusterNode> mapKeyToPrimaryAndBackups(String cacheName, K key, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        assert (cacheName != null);
        A.notNull(key, "key");
        AffinityInfo affInfo = this.affinityCache(cacheName, topVer);
        if (affInfo == null) {
            return Collections.emptyList();
        }
        int part = this.partition(cacheName, key, affInfo);
        return affInfo.assignment.get(part);
    }

    @Nullable
    public Object affinityKey(String cacheName, @Nullable Object key) throws IgniteCheckedException {
        assert (cacheName != null);
        if (key == null) {
            return null;
        }
        AffinityInfo affInfo = this.affinityCache(cacheName, this.ctx.cache().context().exchange().readyAffinityVersion());
        if (affInfo == null) {
            return null;
        }
        return affInfo.affinityKey(key);
    }

    public <K> CacheAffinityProxy<K> affinityProxy(String cacheName) {
        CU.validateCacheName(cacheName);
        return new CacheAffinityProxy(cacheName);
    }

    private <K> Map<ClusterNode, Collection<K>> keysToNodes(@Nullable String cacheName, Collection<? extends K> keys) throws IgniteCheckedException {
        return this.keysToNodes(cacheName, keys, this.ctx.cache().context().exchange().readyAffinityVersion());
    }

    private <K> Map<ClusterNode, Collection<K>> keysToNodes(@Nullable String cacheName, Collection<? extends K> keys, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        if (F.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        AffinityInfo affInfo = this.affinityCache(cacheName, topVer);
        return affInfo != null ? this.affinityMap(affInfo, keys) : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AffinityInfo affinityCache(String cacheName, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        AffinityAssignmentKey key = new AffinityAssignmentKey(cacheName, topVer);
        IgniteInternalFuture fut = (IgniteInternalFuture)this.affMap.get(key);
        if (fut != null) {
            return (AffinityInfo)fut.get();
        }
        GridCacheAdapter cache = this.ctx.cache().internalCache(cacheName);
        if (cache != null) {
            GridCacheContext cctx = cache.context();
            cctx.awaitStarted();
            AffinityAssignment assign0 = cctx.affinity().assignment(topVer);
            try {
                cctx.gate().enter();
            }
            catch (IllegalStateException ignored) {
                return null;
            }
            try {
                GridAffinityAssignment assign = assign0 instanceof GridAffinityAssignment ? (GridAffinityAssignment)assign0 : new GridAffinityAssignment(topVer, assign0.assignment(), assign0.idealAssignment());
                AffinityInfo info = new AffinityInfo(cctx.config().getAffinity(), cctx.config().getAffinityMapper(), assign, cctx.cacheObjectContext());
                IgniteInternalFuture old = this.affMap.putIfAbsent(key, new GridFinishedFuture<AffinityInfo>(info));
                if (old != null) {
                    info = (AffinityInfo)old.get();
                }
                AffinityInfo affinityInfo = info;
                return affinityInfo;
            }
            finally {
                cctx.gate().leave();
            }
        }
        Collection<ClusterNode> cacheNodes = this.ctx.discovery().cacheNodes(cacheName, topVer);
        if (F.isEmpty(cacheNodes)) {
            return null;
        }
        GridFutureAdapter<AffinityInfo> fut0 = new GridFutureAdapter<AffinityInfo>();
        IgniteInternalFuture old = this.affMap.putIfAbsent(key, fut0);
        if (old != null) {
            return (AffinityInfo)old.get();
        }
        int max = 3;
        int cnt = 0;
        Iterator<ClusterNode> it = cacheNodes.iterator();
        while (true) {
            ++cnt;
            if (!it.hasNext()) {
                it = cacheNodes.iterator();
            }
            if (!it.hasNext()) {
                throw new IgniteCheckedException("No cache nodes in topology for cache name: " + cacheName);
            }
            ClusterNode n = it.next();
            CacheMode mode = this.ctx.cache().cacheMode(cacheName);
            if (mode == null) {
                if (this.ctx.clientDisconnected()) {
                    throw new IgniteClientDisconnectedCheckedException(this.ctx.cluster().clientReconnectFuture(), "Failed to get affinity mapping, client disconnected.");
                }
                throw new IgniteCheckedException("No cache nodes in topology for cache name: " + cacheName);
            }
            if (mode == CacheMode.LOCAL) {
                fut0.onDone(new IgniteCheckedException("Failed to map keys for LOCAL cache."));
                fut0.get();
            }
            try {
                fut0.onDone(this.affinityInfoFromNode(cacheName, topVer, n));
            }
            catch (IgniteCheckedException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to get affinity from node (will retry) [cache=" + cacheName + ", node=" + U.toShortString(n) + ", msg=" + e.getMessage() + ']');
                }
                if (cnt < max) {
                    U.sleep(500L);
                    continue;
                }
                this.affMap.remove(key, fut0);
                fut0.onDone(new IgniteCheckedException("Failed to get affinity mapping from node: " + n, e));
            }
            catch (Error | RuntimeException e) {
                fut0.onDone(new IgniteCheckedException("Failed to get affinity mapping from node: " + n, e));
            }
            break;
        }
        return (AffinityInfo)fut0.get();
    }

    private AffinityInfo affinityInfoFromNode(String cacheName, AffinityTopologyVersion topVer, ClusterNode n) throws IgniteCheckedException {
        GridTuple3<GridAffinityMessage, GridAffinityMessage, GridAffinityAssignment> t = this.ctx.closure().callAsyncNoFailover(GridClosureCallMode.BROADCAST, GridAffinityUtils.affinityJob(cacheName, topVer), F.asList(n), true, 0L, false).get();
        AffinityFunction f = (AffinityFunction)GridAffinityUtils.unmarshall(this.ctx, n.id(), t.get1());
        AffinityKeyMapper m = (AffinityKeyMapper)GridAffinityUtils.unmarshall(this.ctx, n.id(), t.get2());
        assert (m != null);
        f.reset();
        m.reset();
        CacheConfiguration ccfg = this.ctx.cache().cacheConfiguration(cacheName);
        return new AffinityInfo(f, m, t.get3(), this.ctx.cacheObjects().contextForCache(ccfg));
    }

    private <K> Map<ClusterNode, Collection<K>> affinityMap(AffinityInfo aff, Collection<? extends K> keys) throws IgniteCheckedException {
        assert (aff != null);
        assert (!F.isEmpty(keys));
        try {
            if (keys.size() == 1) {
                return Collections.singletonMap(this.primary(aff, F.first(keys)), keys);
            }
            GridLeanMap<ClusterNode, Collection<ClusterNode>> map = new GridLeanMap<ClusterNode, Collection<ClusterNode>>();
            for (K k : keys) {
                ClusterNode n = this.primary(aff, k);
                LinkedList<K> mapped = (LinkedList<K>)map.get(n);
                if (mapped == null) {
                    mapped = new LinkedList<K>();
                    map.put(n, mapped);
                }
                mapped.add(k);
            }
            return map;
        }
        catch (IgniteException e) {
            throw new IgniteCheckedException("Failed to get affinity map for keys: " + keys, e);
        }
    }

    private <K> ClusterNode primary(AffinityInfo aff, K key) throws IgniteCheckedException {
        int part = aff.affFunc.partition(aff.affinityKey(key));
        List<ClusterNode> nodes = aff.assignment.get(part);
        if (F.isEmpty(nodes)) {
            throw new IgniteCheckedException("Failed to get affinity nodes [aff=" + aff + ", key=" + key + ']');
        }
        return (ClusterNode)nodes.iterator().next();
    }

    public Object similaryAffinityKey(AffinityFunction aff, IgnitePredicate<ClusterNode> nodeFilter, int backups, int parts) {
        return new SimilarAffinityKey(aff.getClass(), nodeFilter.getClass(), backups, parts);
    }

    @Override
    public void printMemoryStats() {
        X.println(">>>", new Object[0]);
        X.println(">>> Affinity processor memory stats [igniteInstanceName=" + this.ctx.igniteInstanceName() + ']', new Object[0]);
        X.println(">>>   affMapSize: " + this.affMap.size(), new Object[0]);
    }

    private static class SimilarAffinityKey {
        private final int backups;
        private final Class<?> affFuncCls;
        private final Class<?> filterCls;
        private final int partsCnt;
        private final int hash;

        SimilarAffinityKey(Class<?> affFuncCls, Class<?> filterCls, int backups, int partsCnt) {
            this.backups = backups;
            this.affFuncCls = affFuncCls;
            this.filterCls = filterCls;
            this.partsCnt = partsCnt;
            int hash = backups;
            hash = 31 * hash + affFuncCls.hashCode();
            hash = 31 * hash + filterCls.hashCode();
            this.hash = hash = 31 * hash + partsCnt;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimilarAffinityKey key = (SimilarAffinityKey)o;
            return this.backups == key.backups && this.affFuncCls == key.affFuncCls && this.filterCls == key.filterCls && this.partsCnt == key.partsCnt;
        }

        public String toString() {
            return S.toString(SimilarAffinityKey.class, this);
        }
    }

    private class CacheAffinityProxy<K>
    implements Affinity<K> {
        private final String cacheName;

        public CacheAffinityProxy(String cacheName) {
            this.cacheName = cacheName;
        }

        @Override
        public int partitions() {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                int n = this.cache().affinityFunction().partitions();
                return n;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public int partition(K key) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                int n = GridAffinityProcessor.this.partition0(this.cacheName, key, this.cache());
                return n;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public boolean isPrimary(ClusterNode n, K key) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                boolean bl = this.cache().assignment().primaryPartitions(n.id()).contains(this.partition(key));
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public boolean isBackup(ClusterNode n, K key) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                boolean bl = this.cache().assignment().backupPartitions(n.id()).contains(this.partition(key));
                return bl;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPrimaryOrBackup(ClusterNode n, K key) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                boolean bl = this.isPrimary(n, key) || this.isBackup(n, key);
                return bl;
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public int[] primaryPartitions(ClusterNode n) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                Set<Integer> parts = this.cache().assignment().primaryPartitions(n.id());
                int[] nArray = U.toIntArray(parts);
                return nArray;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public int[] backupPartitions(ClusterNode n) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                Set<Integer> parts = this.cache().assignment().backupPartitions(n.id());
                int[] nArray = U.toIntArray(parts);
                return nArray;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public int[] allPartitions(ClusterNode n) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                GridAffinityAssignment assignment = this.cache().assignment();
                int[] primary = U.toIntArray(assignment.primaryPartitions(n.id()));
                int[] backup = U.toIntArray(assignment.backupPartitions(n.id()));
                int[] nArray = U.addAll(primary, backup);
                return nArray;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public Object affinityKey(K key) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                Object object = this.cache().affinityKey(key);
                return object;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public Map<ClusterNode, Collection<K>> mapKeysToNodes(@Nullable Collection<? extends K> keys) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                if (F.isEmpty(keys)) {
                    Map<ClusterNode, Collection<K>> map = Collections.emptyMap();
                    return map;
                }
                AffinityInfo affInfo = this.cache();
                Map map = GridAffinityProcessor.this.affinityMap(affInfo, keys);
                return map;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        @Nullable
        public ClusterNode mapKeyToNode(K key) {
            A.notNull(key, "key");
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                AffinityInfo affInfo = this.cache();
                Map map = GridAffinityProcessor.this.affinityMap(affInfo, Collections.singletonList(key));
                ClusterNode clusterNode = (ClusterNode)F.first(map.keySet());
                return clusterNode;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public Collection<ClusterNode> mapKeyToPrimaryAndBackups(K key) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                AffinityInfo aff = this.cache();
                List<ClusterNode> list = aff.assignment().get(GridAffinityProcessor.this.partition(this.cacheName, key, aff));
                return list;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public ClusterNode mapPartitionToNode(int part) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                ClusterNode clusterNode = F.first(this.cache().assignment().get(part));
                return clusterNode;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public Map<Integer, ClusterNode> mapPartitionsToNodes(Collection<Integer> parts) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                HashMap<Integer, ClusterNode> map = new HashMap<Integer, ClusterNode>();
                if (!F.isEmpty(parts)) {
                    AffinityInfo aff = this.cache();
                    for (int p : parts) {
                        map.put(p, F.first(aff.assignment().get(p)));
                    }
                }
                HashMap<Integer, ClusterNode> hashMap = map;
                return hashMap;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        @Override
        public Collection<ClusterNode> mapPartitionToPrimaryAndBackups(int part) {
            GridAffinityProcessor.this.ctx.gateway().readLock();
            try {
                List<ClusterNode> list = this.cache().assignment().get(part);
                return list;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                GridAffinityProcessor.this.ctx.gateway().readUnlock();
            }
        }

        private AffinityInfo cache() throws IgniteCheckedException {
            AffinityInfo aff = GridAffinityProcessor.this.affinityCache(this.cacheName, GridAffinityProcessor.this.ctx.cache().context().exchange().readyAffinityVersion());
            if (aff == null) {
                throw new IgniteException("Failed to find cache (cache was not started yet or cache was already stopped): " + this.cacheName);
            }
            return aff;
        }
    }

    private static class AffinityAssignmentKey {
        private String cacheName;
        private AffinityTopologyVersion topVer;

        private AffinityAssignmentKey(String cacheName, @NotNull AffinityTopologyVersion topVer) {
            this.cacheName = cacheName;
            this.topVer = topVer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AffinityAssignmentKey)) {
                return false;
            }
            AffinityAssignmentKey that = (AffinityAssignmentKey)o;
            return this.topVer.equals(that.topVer) && F.eq(this.cacheName, that.cacheName);
        }

        public int hashCode() {
            int res = this.cacheName != null ? this.cacheName.hashCode() : 0;
            res = 31 * res + this.topVer.hashCode();
            return res;
        }

        public String toString() {
            return S.toString(AffinityAssignmentKey.class, this);
        }
    }

    private static class AffinityInfo {
        private AffinityFunction affFunc;
        private AffinityKeyMapper mapper;
        private GridAffinityAssignment assignment;
        private CacheObjectContext cacheObjCtx;

        private AffinityInfo(AffinityFunction affFunc, AffinityKeyMapper mapper, GridAffinityAssignment assignment, CacheObjectContext cacheObjCtx) {
            this.affFunc = affFunc;
            this.mapper = mapper;
            this.assignment = assignment;
            this.cacheObjCtx = cacheObjCtx;
        }

        private Object affinityKey(Object key) {
            if (key instanceof CacheObject && !(key instanceof BinaryObject)) {
                key = ((CacheObject)key).value(this.cacheObjCtx, false);
            }
            return this.mapper.affinityKey(key);
        }

        private AffinityFunction affinityFunction() {
            return this.affFunc;
        }

        private GridAffinityAssignment assignment() {
            return this.assignment;
        }

        public String toString() {
            return S.toString(AffinityInfo.class, this);
        }
    }
}

