/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class MasterAddressTracker
extends ZooKeeperNodeTracker {
    public MasterAddressTracker(ZooKeeperWatcher watcher, Abortable abortable) {
        super(watcher, watcher.getMasterAddressZNode(), abortable);
    }

    public ServerName getMasterAddress() {
        return this.getMasterAddress(false);
    }

    public int getMasterInfoPort() {
        try {
            ZooKeeperProtos.Master master = MasterAddressTracker.parse(this.getData(false));
            if (master == null) {
                return 0;
            }
            return master.getInfoPort();
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse master zk node data", (Throwable)e);
            return 0;
        }
    }

    public int getBackupMasterInfoPort(ServerName sn) {
        String backupZNode = ZKUtil.joinZNode(this.watcher.backupMasterAddressesZNode, sn.toString());
        try {
            byte[] data = ZKUtil.getData(this.watcher, backupZNode);
            ZooKeeperProtos.Master backup = MasterAddressTracker.parse(data);
            if (backup == null) {
                return 0;
            }
            return backup.getInfoPort();
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get backup master: " + sn + "'s info port."), (Throwable)e);
            return 0;
        }
    }

    public ServerName getMasterAddress(boolean refresh) {
        try {
            return ServerName.parseFrom(super.getData(refresh));
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return null;
        }
    }

    public static ServerName getMasterAddress(ZooKeeperWatcher zkw) throws KeeperException, IOException {
        byte[] data;
        try {
            data = ZKUtil.getData(zkw, zkw.getMasterAddressZNode());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (data == null) {
            throw new IOException("Can't get master address from ZooKeeper; znode data == null");
        }
        try {
            return ServerName.parseFrom(data);
        }
        catch (DeserializationException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
    }

    public static int getMasterInfoPort(ZooKeeperWatcher zkw) throws KeeperException, IOException {
        byte[] data;
        try {
            data = ZKUtil.getData(zkw, zkw.getMasterAddressZNode());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        if (data == null) {
            throw new IOException("Can't get master address from ZooKeeper; znode data == null");
        }
        try {
            return MasterAddressTracker.parse(data).getInfoPort();
        }
        catch (DeserializationException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
    }

    public static boolean setMasterAddress(ZooKeeperWatcher zkw, String znode, ServerName master, int infoPort) throws KeeperException {
        return ZKUtil.createEphemeralNodeAndWatch(zkw, znode, MasterAddressTracker.toByteArray(master, infoPort));
    }

    public boolean hasMaster() {
        return super.getData(false) != null;
    }

    static byte[] toByteArray(ServerName sn, int infoPort) {
        ZooKeeperProtos.Master.Builder mbuilder = ZooKeeperProtos.Master.newBuilder();
        HBaseProtos.ServerName.Builder snbuilder = HBaseProtos.ServerName.newBuilder();
        snbuilder.setHostName(sn.getHostname());
        snbuilder.setPort(sn.getPort());
        snbuilder.setStartCode(sn.getStartcode());
        mbuilder.setMaster(snbuilder.build());
        mbuilder.setRpcVersion(0);
        mbuilder.setInfoPort(infoPort);
        return ProtobufUtil.prependPBMagic(mbuilder.build().toByteArray());
    }

    public static ZooKeeperProtos.Master parse(byte[] data) throws DeserializationException {
        if (data == null) {
            return null;
        }
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        try {
            return (ZooKeeperProtos.Master)ZooKeeperProtos.Master.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
    }

    public static boolean deleteIfEquals(ZooKeeperWatcher zkw, String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null");
        }
        try {
            Stat stat = new Stat();
            byte[] data = ZKUtil.getDataNoWatch(zkw, zkw.getMasterAddressZNode(), stat);
            ServerName sn = ServerName.parseFrom(data);
            if (sn != null && content.equals(sn.toString())) {
                return ZKUtil.deleteNode(zkw, zkw.getMasterAddressZNode(), stat.getVersion());
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Can't get or delete the master znode", (Throwable)e);
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Can't get or delete the master znode", (Throwable)e);
        }
        return false;
    }
}

