/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.util;

import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import java.util.Date;
import java.util.List;

public class InsertUtil {
    private static InsertUtil instance = new InsertUtil();

    public static InsertUtil Instance() {
        return instance;
    }

    private InsertUtil() {
    }

    public int FindIndex(List dataList, Object findData) {
        Date insertDate = null;
        if (findData instanceof Date) {
            insertDate = (Date)findData;
        } else if (findData instanceof DoubleTimeObject) {
            insertDate = ((DoubleTimeObject)findData).data_time;
        }
        int beginIndex = 0;
        int endIndex = dataList.size() - 1;
        int findIndex = -1;
        while (beginIndex <= endIndex) {
            int tempIndex = (beginIndex + endIndex) / 2;
            Object tmpData = dataList.get(tempIndex);
            Date tmpDate = null;
            if (tmpData instanceof Date) {
                tmpDate = (Date)tmpData;
            } else if (tmpData instanceof DoubleTimeObject) {
                tmpDate = ((DoubleTimeObject)tmpData).data_time;
            }
            int compareResult = tmpDate.compareTo(insertDate);
            if (compareResult == 0) {
                findIndex = tempIndex;
                break;
            }
            if (compareResult < 0) {
                beginIndex = tempIndex + 1;
                continue;
            }
            endIndex = tempIndex - 1;
        }
        return findIndex;
    }

    public int FindInsertIndex(List dataList, Object insertData) {
        return this.FindInsertIndex(dataList, insertData, false, 0);
    }

    public int FindInsertIndex(List dataList, Object insertData, boolean returnFindIndex, int returnFindIndexOffset) {
        Date insertDate = null;
        if (insertData instanceof Date) {
            insertDate = (Date)insertData;
        } else if (insertData instanceof DoubleTimeObject) {
            insertDate = ((DoubleTimeObject)insertData).data_time;
        }
        int beginIndex = 0;
        int endIndex = dataList.size() - 1;
        boolean lastMoveLeft = true;
        boolean find = false;
        while (beginIndex <= endIndex) {
            int tempIndex = (beginIndex + endIndex) / 2;
            Object tmpData = dataList.get(tempIndex);
            Date tmpDate = null;
            if (tmpData instanceof Date) {
                tmpDate = (Date)tmpData;
            } else if (tmpData instanceof DoubleTimeObject) {
                tmpDate = ((DoubleTimeObject)tmpData).data_time;
            }
            int compareResult = tmpDate.compareTo(insertDate);
            if (compareResult == 0) {
                find = true;
                break;
            }
            if (compareResult < 0) {
                beginIndex = tempIndex + 1;
                lastMoveLeft = false;
                continue;
            }
            endIndex = tempIndex - 1;
            lastMoveLeft = true;
        }
        int insertIndex = 0;
        if (!find) {
            insertIndex = lastMoveLeft ? endIndex + 1 : beginIndex;
        } else if (returnFindIndex) {
            insertIndex = (beginIndex + endIndex) / 2;
            insertIndex += returnFindIndexOffset;
        } else {
            insertIndex = -1;
        }
        return insertIndex;
    }

    public void InsertIntoDataList(List dataList, Object insertData) {
        if (dataList.size() == 0) {
            dataList.add(insertData);
        }
        Date insertDate = null;
        if (insertData instanceof Date) {
            insertDate = (Date)insertData;
        } else if (insertData instanceof DoubleTimeObject) {
            insertDate = ((DoubleTimeObject)insertData).data_time;
        }
        int beginIndex = 0;
        int endIndex = dataList.size() - 1;
        boolean lastMoveLeft = true;
        boolean find = false;
        while (beginIndex <= endIndex) {
            int tempIndex = (beginIndex + endIndex) / 2;
            Object tmpData = dataList.get(tempIndex);
            Date tmpDate = null;
            if (tmpData instanceof Date) {
                tmpDate = (Date)tmpData;
            } else if (tmpData instanceof DoubleTimeObject) {
                tmpDate = ((DoubleTimeObject)tmpData).data_time;
            }
            int compareResult = tmpDate.compareTo(insertDate);
            if (compareResult == 0) {
                find = true;
                break;
            }
            if (compareResult < 0) {
                beginIndex = tempIndex + 1;
                lastMoveLeft = false;
                continue;
            }
            endIndex = tempIndex - 1;
            lastMoveLeft = true;
        }
        int insertIndex = 0;
        if (!find) {
            insertIndex = lastMoveLeft ? endIndex + 1 : beginIndex;
            dataList.add(insertIndex, insertData);
        }
    }
}

