/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.alibaba.fastjson.JSONObject;
import com.sagacloud.extend.dao_data.ImplDao_fjd_near;
import com.sagacloud.util.compute_engine.core.CoreComputeUtil;
import com.sagacloud.util.compute_engine.core.CoreInput;
import com.sagacloud.util.compute_engine.core.CoreOutput;
import com.sagacloud.util.compute_engine.core.Dao_dataManager;
import com.sagacloud.util.compute_engine.core.IDao_data;
import com.sagacloud.util.compute_engine.core.IDao_log;
import com.sagacloud.util.compute_engine.fjd.ImplDao_log;
import com.sagacloud.util.compute_engine.fjd_1.EntitySpan;
import com.sagacloud.util.compute_engine.fjd_1.EntityValidSpan;
import com.sagacloud.util.compute_engine.fjd_1.ProcessUtil2;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DateUtil;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_fjd_near;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.sagacloud.util.compute_engine.util.TimeSpan;
import com.sagacloud.util.split.HistoryUtil;
import com.sagacloud.util.split.SplitAlgorithm;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zillion.util.log.LogUtil;

public class Compute_fjd_1 {
    public static Map<String, List<TimeSpan>> Compute(String object_sign, String instance_name, List<CoreInput> inputList, List<CoreOutput> outputList, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, IDao_log dao_log) throws Exception {
        HashMap<String, CoreInput> inputMap = new HashMap<String, CoreInput>();
        for (CoreInput input : inputList) {
            inputMap.put(input.input_sign, input);
        }
        for (int i = 0; i < outputList.size(); ++i) {
            CoreOutput output = outputList.get(i);
            CoreInput input = (CoreInput)inputMap.get("ori_" + output.output_sign.substring("fjd_0_".length()));
            if (!input.source_output_sign.startsWith("Acc_")) continue;
            Compute_fjd_1.Process(object_sign, compute_round, inputTimeSpanMap, input, output, dao_log);
        }
        return inputTimeSpanMap;
    }

    private static void Process(String object_sign, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, CoreInput input, CoreOutput output, IDao_log dao_log) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String building = object_sign;
        String mf = output.output_sign.substring("fjd_0_".length());
        int index_ = mf.lastIndexOf(95);
        String meter = mf.substring(0, index_);
        long funcid = Long.parseLong(mf.substring(index_ + 1));
        if (!inputTimeSpanMap.containsKey(meter + "_" + funcid)) {
            return;
        }
        String time_period = input.time_period;
        long interval = DateUtil.Instance().get_about(time_period);
        List<TimeSpan> timeSpanList = inputTimeSpanMap.get(meter + "_" + funcid);
        Date time_from = timeSpanList.get((int)0).timefrom;
        Date time_to = timeSpanList.get((int)(timeSpanList.size() - 1)).timeto;
        Date time_from_query = new Date(time_from.getTime() - 1000L * ConstantCE.fjd_1_compute_min_span_second);
        List<DoubleTimeObject> recordDataList = Dao_dataManager.Instance().Get(input.dao_type).GetDataListGteLte(input.dao_key, null, time_from_query, DateUtil.Instance().GetDate_offset(time_to, time_period, ConstantCE.fjd_1_max_analyse_after_interval_count), true);
        if (recordDataList.size() == 0) {
            return;
        }
        ArrayList<DoubleTimeObject> badDataList = new ArrayList<DoubleTimeObject>();
        EntitySpan span = new EntitySpan();
        ArrayList<EntityValidSpan> validList = new ArrayList<EntityValidSpan>();
        boolean new_get_not_null = true;
        while (true) {
            if (new_get_not_null) {
                badDataList = new ArrayList();
                span = new EntitySpan();
                validList = new ArrayList();
                ProcessUtil2.Process(building, meter, funcid, time_period, recordDataList, badDataList, span, validList);
            }
            if (validList.size() == 0 || time_from.getTime() - time_from_query.getTime() > 86400000L * (long)ConstantCE.fjd_1_max_analyse_before_day) break;
            Date seek = DateUtil.Instance().GetDate_offset(time_from, time_period, -1);
            int seek_index = -1;
            for (int ii = 0; ii < recordDataList.size(); ++ii) {
                DoubleTimeObject data = recordDataList.get(ii);
                if (data.data_time.getTime() < seek.getTime()) continue;
                seek_index = ii;
                break;
            }
            if (seek_index == -1) break;
            DoubleTimeObject seek_data = recordDataList.get(seek_index);
            boolean buyiyang = false;
            for (int ii = seek_index - 1; ii >= 0; --ii) {
                DoubleTimeObject data = recordDataList.get(ii);
                if (!(Math.abs(data.data_value - seek_data.data_value) >= 0.001)) continue;
                buyiyang = true;
                break;
            }
            if (buyiyang) break;
            Date next_from = new Date(time_from_query.getTime() - (time_from.getTime() - time_from_query.getTime()));
            List<DoubleTimeObject> tmpDataList = Dao_dataManager.Instance().Get(input.dao_type).GetDataListGteLte(input.dao_key, null, next_from, time_from_query, false);
            new_get_not_null = tmpDataList.size() > 0;
            tmpDataList.addAll(recordDataList);
            recordDataList = tmpDataList;
            time_from_query = next_from;
        }
        if (badDataList.size() > 0) {
            Dao_dataManager.Instance().Get("ori_flag").InsertDataListGteLte(output.dao_key, time_period, badDataList);
        }
        if (validList.size() == 0) {
            return;
        }
        ArrayList<DoubleTimeObject_fjd_near> outDataList = new ArrayList<DoubleTimeObject_fjd_near>();
        int valid_index = 0;
        EntityValidSpan firstValid = (EntityValidSpan)validList.get(valid_index);
        int data_index = firstValid.index_from;
        while (valid_index < validList.size()) {
            DoubleTimeObject data_next;
            int zero_index = -1;
            for (int i = 0; i < span.zeroList_from.size(); ++i) {
                if (span.zeroList_from.get(i) != data_index) continue;
                zero_index = i;
                break;
            }
            int stay_index = -1;
            for (int i = 0; i < span.stayList_from.size(); ++i) {
                if (span.stayList_from.get(i) != data_index) continue;
                stay_index = i;
                break;
            }
            int bianda_index = -1;
            for (int i = 0; i < span.changeList_bianda.size(); ++i) {
                EntityValidSpan index_fromValid = (EntityValidSpan)validList.get(span.changeList_bianda.get(i));
                if (index_fromValid.index_to != data_index) continue;
                bianda_index = i;
                break;
            }
            int bianxiao_index = -1;
            for (int i = 0; i < span.changeList_bianxiao.size(); ++i) {
                EntityValidSpan index_fromValid = (EntityValidSpan)validList.get(span.changeList_bianxiao.get(i));
                if (index_fromValid.index_to != data_index) continue;
                bianxiao_index = i;
                break;
            }
            DoubleTimeObject data = recordDataList.get(data_index);
            if (zero_index != -1) {
                if (stay_index != -1 || bianda_index != -1 || bianxiao_index != -1) {
                    LogUtil.error((String)(object_sign + "\tfjd_1\t" + compute_round + "\t" + meter + "\t" + funcid + "\t" + sdf.format(data.data_time)));
                    return;
                }
                int index_to = span.zeroList_to.get(zero_index);
                DoubleTimeObject data_next2 = recordDataList.get(index_to);
                Compute_fjd_1.interpolate_history(time_from, building, meter, funcid, time_period, data, data_next2, outDataList, 101L);
                data_index = index_to;
            } else if (stay_index != -1) {
                if (zero_index != -1 || bianda_index != -1 || bianxiao_index != -1) {
                    LogUtil.error((String)(object_sign + "\tfjd_1\t" + compute_round + "\t" + meter + "\t" + funcid + "\t" + sdf.format(data.data_time)));
                    return;
                }
                int index_to = span.stayList_to.get(stay_index);
                DoubleTimeObject data_next3 = recordDataList.get(index_to);
                Compute_fjd_1.interpolate_history(time_from, building, meter, funcid, time_period, data, data_next3, outDataList, 119L);
                data_index = index_to;
            } else if (bianda_index != -1) {
                if (zero_index != -1 || stay_index != -1 || bianxiao_index != -1) {
                    LogUtil.error((String)(object_sign + "\tfjd_1\t" + compute_round + "\t" + meter + "\t" + funcid + "\t" + sdf.format(data.data_time)));
                    return;
                }
                data_next = recordDataList.get(data_index + 1);
                Compute_fjd_1.interpolate_yanxu(time_from, interval, data, data_next, outDataList, 59L);
                DoubleTimeObject_fjd_near outData = new DoubleTimeObject_fjd_near();
                outData.data_time = new Date((data_next.data_time.getTime() - 1L) / interval * interval + interval);
                outData.data_value = data_next.data_value;
                outData.data_flag = 3L;
                if (outData.data_time.getTime() >= time_from.getTime()) {
                    outDataList.add(outData);
                }
                ++data_index;
            } else if (bianxiao_index != -1) {
                if (zero_index != -1 || stay_index != -1 || bianda_index != -1) {
                    LogUtil.error((String)(object_sign + "\tfjd_1\t" + compute_round + "\t" + meter + "\t" + funcid + "\t" + sdf.format(data.data_time)));
                    return;
                }
                data_next = recordDataList.get(data_index + 1);
                Compute_fjd_1.interpolate_yanxu(time_from, interval, data, data_next, outDataList, 51L);
                DoubleTimeObject_fjd_near outData = new DoubleTimeObject_fjd_near();
                outData.data_time = new Date((data_next.data_time.getTime() - 1L) / interval * interval + interval);
                outData.data_value = data_next.data_value;
                outData.data_flag = 3L;
                if (outData.data_time.getTime() >= time_from.getTime()) {
                    outDataList.add(outData);
                }
                ++data_index;
            } else {
                EntityValidSpan belongValid = (EntityValidSpan)validList.get(valid_index);
                if (data_index == belongValid.index_to) {
                    if (valid_index < validList.size() - 1) {
                        EntityValidSpan belongValidNext = (EntityValidSpan)validList.get(valid_index + 1);
                        DoubleTimeObject data_next4 = recordDataList.get(belongValidNext.index_from);
                        double energy = data_next4.data_value - data.data_value;
                        double power = energy / (1.0 * (double)(data_next4.data_time.getTime() - data.data_time.getTime()) / 3600000.0);
                        if (energy >= ConstantCE.fjd_1_monotony_sub && power <= ConstantCE.PowerLimit) {
                            Compute_fjd_1.interpolate_history(time_from, building, meter, funcid, time_period, data, data_next4, outDataList, 102L);
                        }
                        data_index = belongValidNext.index_from;
                    } else {
                        ++data_index;
                    }
                } else {
                    DoubleTimeObject data_next5 = recordDataList.get(data_index + 1);
                    Compute_fjd_1.interpolate(time_from, interval, data, data_next5, outDataList, 0L);
                    ++data_index;
                }
            }
            int find_index = -1;
            for (int i = 0; i < validList.size(); ++i) {
                EntityValidSpan valid = (EntityValidSpan)validList.get(i);
                if (valid.index_from > data_index || data_index > valid.index_to) continue;
                find_index = i;
                break;
            }
            if (find_index != -1) {
                valid_index = find_index;
                continue;
            }
            if (data_index <= ((EntityValidSpan)validList.get((int)(validList.size() - 1))).index_to) {
                DoubleTimeObject data_tmp = recordDataList.get(data_index);
                LogUtil.error((String)(object_sign + "\tfjd_1\t" + compute_round + "\t\t" + meter + "\t" + funcid + "\tlose\t" + sdf.format(data_tmp.data_time)));
                return;
            }
            valid_index = validList.size();
        }
        for (int i = outDataList.size() - 1; i >= 0; --i) {
            DoubleTimeObject_fjd_near outData = (DoubleTimeObject_fjd_near)outDataList.get(i);
            if (outData.data_time.getTime() <= time_to.getTime()) continue;
            outDataList.remove(i);
        }
        if (outDataList.size() == 0) {
            return;
        }
        DoubleTimeObject_fjd_near first_data_out = (DoubleTimeObject_fjd_near)outDataList.get(0);
        DoubleTimeObject_fjd_near final_data_out = (DoubleTimeObject_fjd_near)outDataList.get(outDataList.size() - 1);
        ImplDao_fjd_near dao_fjd_near = (ImplDao_fjd_near)Dao_dataManager.Instance().Get("fjd_near");
        List<DoubleTimeObject_fjd_near> fjdDataList = dao_fjd_near.GetDataListGteLte_fjd_near(input.dao_key, time_period, first_data_out.data_time, final_data_out.data_time, true);
        ArrayList<DoubleTimeObject_fjd_near> equalDataList = new ArrayList<DoubleTimeObject_fjd_near>();
        ArrayList<DoubleTimeObject_fjd_near> unequalDataList = new ArrayList<DoubleTimeObject_fjd_near>();
        ArrayList<DoubleTimeObject_fjd_near> delDataList = new ArrayList<DoubleTimeObject_fjd_near>();
        ArrayList<DoubleTimeObject_fjd_near> addDataList = new ArrayList<DoubleTimeObject_fjd_near>();
        Compute_fjd_1.CompareDataList(fjdDataList, outDataList, equalDataList, unequalDataList, delDataList, addDataList);
        if (unequalDataList.size() > 0) {
            DoubleTimeObject_fjd_near first_data = (DoubleTimeObject_fjd_near)unequalDataList.get(0);
            DoubleTimeObject_fjd_near final_data = (DoubleTimeObject_fjd_near)unequalDataList.get(unequalDataList.size() - 1);
            DoubleTimeObject_fjd_near continue_del = null;
            for (int i = 0; i < delDataList.size(); ++i) {
                DoubleTimeObject_fjd_near tmp_del = (DoubleTimeObject_fjd_near)delDataList.get(i);
                if (continue_del == null) {
                    continue_del = tmp_del;
                }
                if (i == delDataList.size() - 1) {
                    dao_fjd_near.DeleteDataListGteLte_fjd_1(input.dao_key, time_period, continue_del.data_time, tmp_del.data_time);
                    continue;
                }
                DoubleTimeObject_fjd_near tmp_del_next = (DoubleTimeObject_fjd_near)delDataList.get(i + 1);
                if (tmp_del_next.data_time.getTime() - tmp_del.data_time.getTime() <= interval) continue;
                dao_fjd_near.DeleteDataListGteLte_fjd_1(input.dao_key, time_period, continue_del.data_time, tmp_del.data_time);
                continue_del = tmp_del_next;
            }
            ConstantCE.SleepBetweenDeleteAndInsert();
            dao_fjd_near.InsertDataListGteLte_fjd_1(input.dao_key, time_period, addDataList);
            DoubleTimeObject_fjd_near first_data_stat = (DoubleTimeObject_fjd_near)addDataList.get(0);
            DoubleTimeObject_fjd_near final_data_stat = (DoubleTimeObject_fjd_near)addDataList.get(addDataList.size() - 1);
            List<DoubleTimeObject_fjd_near> fjd_dataList_stat = dao_fjd_near.GetDataListGteLte_fjd_near(input.dao_key, time_period, first_data_stat.data_time, final_data_stat.data_time, true);
            ArrayList<DoubleTimeObject> dataList_stat = new ArrayList<DoubleTimeObject>();
            for (DoubleTimeObject_fjd_near fjd_data : fjd_dataList_stat) {
                DoubleTimeObject data = new DoubleTimeObject();
                data.data_time = fjd_data.data_time;
                data.data_value = fjd_data.data_value;
                dataList_stat.add(data);
            }
            ArrayList<TimeSpan> timeSpanList_stat = new ArrayList<TimeSpan>();
            timeSpanList_stat.add(new TimeSpan(first_data_stat.data_time, final_data_stat.data_time));
            CoreComputeUtil.Stat_near("fjd_1", output.dao_key, timeSpanList_stat, time_period, dataList_stat);
            ImplDao_log ImplDao_log2 = (ImplDao_log)dao_log;
            JSONObject Criteria = new JSONObject();
            Criteria.put("building", (Object)object_sign);
            Criteria.put("compute_round", (Object)compute_round);
            Criteria.put("meter", (Object)meter);
            Criteria.put("funcid", (Object)funcid);
            QueryUtil.delete(ImplDao_log2.agent, ImplDao_log2.database_name, "fjd_1_computedetail", Criteria);
            JSONObject InsertObject = new JSONObject();
            InsertObject.put("building", (Object)object_sign);
            InsertObject.put("compute_round", (Object)compute_round);
            InsertObject.put("meter", (Object)meter);
            InsertObject.put("funcid", (Object)funcid);
            InsertObject.put("valid_time_from", (Object)sdf.format(first_data.data_time));
            InsertObject.put("valid_time_to", (Object)sdf.format(final_data.data_time));
            InsertObject.put("operate_time_to", (Object)sdf.format(new Date()));
            QueryUtil.insert(ImplDao_log2.agent, ImplDao_log2.database_name, "fjd_1_computedetail", InsertObject);
        }
    }

    public static void interpolate(Date time_from, long interval, DoubleTimeObject data, DoubleTimeObject data_next, List<DoubleTimeObject_fjd_near> outDataList, long data_flag) {
        Date compute_from = new Date((data.data_time.getTime() - 1L) / interval * interval + interval);
        Date compute_to = new Date((data_next.data_time.getTime() - 1L) / interval * interval);
        if (compute_to.getTime() < time_from.getTime()) {
            return;
        }
        Date date_tmp = compute_from;
        while (date_tmp.getTime() <= compute_to.getTime()) {
            block6: {
                DoubleTimeObject_fjd_near outData;
                block5: {
                    outData = new DoubleTimeObject_fjd_near();
                    outData.data_time = date_tmp;
                    outData.data_value = data.data_value + (data_next.data_value - data.data_value) * (1.0 * (double)(outData.data_time.getTime() - data.data_time.getTime()) / (double)(data_next.data_time.getTime() - data.data_time.getTime()));
                    outData.data_flag = data_flag;
                    if (outDataList.size() <= 0) break block5;
                    DoubleTimeObject_fjd_near lastData = outDataList.get(outDataList.size() - 1);
                    if (lastData.data_time.getTime() >= outData.data_time.getTime()) break block6;
                }
                outDataList.add(outData);
            }
            date_tmp = new Date(date_tmp.getTime() + interval);
        }
    }

    public static void interpolate_yanxu(Date time_from, long interval, DoubleTimeObject data, DoubleTimeObject data_next, List<DoubleTimeObject_fjd_near> outDataList, long data_flag) {
        Date compute_from = new Date((data.data_time.getTime() - 1L) / interval * interval + interval);
        Date compute_to = new Date((data_next.data_time.getTime() - 1L) / interval * interval);
        if (compute_to.getTime() < time_from.getTime()) {
            return;
        }
        Date date_tmp = compute_from;
        while (date_tmp.getTime() <= compute_to.getTime()) {
            block6: {
                DoubleTimeObject_fjd_near outData;
                block5: {
                    outData = new DoubleTimeObject_fjd_near();
                    outData.data_time = date_tmp;
                    outData.data_value = data.data_value;
                    outData.data_flag = data_flag;
                    if (outDataList.size() <= 0) break block5;
                    DoubleTimeObject_fjd_near lastData = outDataList.get(outDataList.size() - 1);
                    if (lastData.data_time.getTime() >= outData.data_time.getTime()) break block6;
                }
                outDataList.add(outData);
            }
            date_tmp = new Date(date_tmp.getTime() + interval);
        }
    }

    public static void interpolate_history(Date time_from, String building, String meter, long funcid, String time_period, DoubleTimeObject data, DoubleTimeObject data_next, List<DoubleTimeObject_fjd_near> outDataList, long data_flag) throws Exception {
        long interval = DateUtil.Instance().get_about(time_period);
        Date compute_from = new Date((data.data_time.getTime() - 1L) / interval * interval + interval);
        Date compute_to = new Date((data_next.data_time.getTime() - 1L) / interval * interval);
        if (compute_to.getTime() < time_from.getTime()) {
            return;
        }
        DoubleTimeObject dataBegin = new DoubleTimeObject();
        dataBegin.data_time = compute_from;
        dataBegin.data_value = data.data_value;
        DoubleTimeObject dataEnd = new DoubleTimeObject();
        dataEnd.data_time = compute_to;
        dataEnd.data_value = data_next.data_value;
        JSONObject dao_key = new JSONObject();
        dao_key.put("building", (Object)building);
        dao_key.put("meter", (Object)meter);
        dao_key.put("funcid", (Object)funcid);
        IDao_data dao = Dao_dataManager.Instance().Get("servicedata");
        List<DoubleTimeObject> serviceDataList = Compute_fjd_1.ComputeRepair(dao, dao_key, time_period, dataBegin, dataEnd);
        long timeSpanCount = (dataEnd.data_time.getTime() - dataBegin.data_time.getTime()) / interval;
        double total_add = 0.0;
        int i = 0;
        while ((long)i < timeSpanCount) {
            DoubleTimeObject servicedata = serviceDataList.get(i);
            DoubleTimeObject_fjd_near data_tmp = new DoubleTimeObject_fjd_near();
            data_tmp.data_time = new Date(compute_from.getTime() + interval * (long)i);
            data_tmp.data_value = data.data_value + total_add;
            data_tmp.data_flag = data_flag;
            outDataList.add(data_tmp);
            total_add += servicedata.data_value.doubleValue();
            ++i;
        }
        DoubleTimeObject_fjd_near data_tmp = new DoubleTimeObject_fjd_near();
        data_tmp.data_time = compute_to;
        data_tmp.data_value = data_next.data_value;
        data_tmp.data_flag = data_flag;
        outDataList.add(data_tmp);
    }

    private static List<DoubleTimeObject> ComputeRepair(IDao_data dao, JSONObject dao_key, String time_period, DoubleTimeObject dataBegin, DoubleTimeObject dataEnd) throws Exception {
        long interval = DateUtil.Instance().get_about(time_period);
        Calendar calendar = Calendar.getInstance();
        ArrayList<DoubleTimeObject> result = new ArrayList<DoubleTimeObject>();
        double energy = dataEnd.data_value - dataBegin.data_value;
        long timeSpanCount = (dataEnd.data_time.getTime() - dataBegin.data_time.getTime()) / interval;
        ArrayList<Double> estimateArray = new ArrayList<Double>();
        ArrayList<Double> uncertaintyArray = new ArrayList<Double>();
        Compute_fjd_1.GetHistory(dao, dao_key, dataBegin.data_time, dataEnd.data_time, estimateArray, uncertaintyArray, time_period);
        ArrayList<Double> estimateValue = new ArrayList<Double>();
        ArrayList<Double> uncertaintyValue = new ArrayList<Double>();
        Date tmpTime = dataBegin.data_time;
        int iii = 0;
        while ((long)iii < timeSpanCount) {
            calendar.setTime(tmpTime);
            int day_of_week = calendar.get(7);
            int hour_of_day = calendar.get(11);
            int index = (day_of_week - 1) * 24 + hour_of_day;
            Double estimate = null;
            Double uncertainty = null;
            for (int index_num = 0; index_num < 7; ++index_num) {
                estimate = (Double)estimateArray.get((index + index_num * 24) % 168);
                uncertainty = (Double)uncertaintyArray.get((index + index_num * 24) % 168);
                if (estimate != null) break;
            }
            estimateValue.add(estimate);
            uncertaintyValue.add(uncertainty);
            result.add(new DoubleTimeObject(new Date(dataBegin.data_time.getTime() + interval * (long)iii), 0.0));
            tmpTime = new Date(tmpTime.getTime() + interval);
            ++iii;
        }
        SplitAlgorithm.Instance().SolveByRatio(estimateValue, energy, result);
        return result;
    }

    private static void GetHistory(IDao_data dao, JSONObject dao_key, Date lostTimeFrom1, Date lostTimeFrom2, List<Double> estimateList, List<Double> uncertaintyList, String time_period) throws Exception {
        long timeSpanWeeks = 2419200000L;
        List<DoubleTimeObject> serviceDataList = dao.GetDataListGteLte(dao_key, time_period, new Date(lostTimeFrom1.getTime() - timeSpanWeeks), new Date(lostTimeFrom2.getTime() + timeSpanWeeks), false);
        ArrayList<DoubleTimeObject> dataList = new ArrayList<DoubleTimeObject>();
        for (int i = 0; i < serviceDataList.size(); ++i) {
            DoubleTimeObject serviceData = serviceDataList.get(i);
            dataList.add(new DoubleTimeObject(serviceData.data_time, serviceData.data_value));
        }
        HistoryUtil.Instance().GetHistory(dataList, estimateList, uncertaintyList);
    }

    private static void CompareDataList(List<DoubleTimeObject_fjd_near> oldDataList, List<DoubleTimeObject_fjd_near> newDataList, List<DoubleTimeObject_fjd_near> equalDataList, List<DoubleTimeObject_fjd_near> unequalDataList, List<DoubleTimeObject_fjd_near> delDataList, List<DoubleTimeObject_fjd_near> addDataList) {
        int index_old = 0;
        int index_new = 0;
        while (index_old < oldDataList.size() && index_new < newDataList.size()) {
            DoubleTimeObject_fjd_near oldData = oldDataList.get(index_old);
            DoubleTimeObject_fjd_near newData = newDataList.get(index_new);
            if (oldData.data_time.getTime() < newData.data_time.getTime()) {
                delDataList.add(oldData);
                DoubleTimeObject_fjd_near data = new DoubleTimeObject_fjd_near();
                data.data_time = oldData.data_time;
                data.data_value = oldData.data_value;
                data.data_flag = 250L;
                addDataList.add(data);
                unequalDataList.add(oldData);
                ++index_old;
                continue;
            }
            if (oldData.data_time.getTime() > newData.data_time.getTime()) {
                addDataList.add(newData);
                unequalDataList.add(oldData);
                ++index_new;
                continue;
            }
            if (oldData.data_flag == newData.data_flag && Math.abs(oldData.data_value - newData.data_value) < 0.001) {
                equalDataList.add(newData);
            } else {
                unequalDataList.add(oldData);
                delDataList.add(oldData);
                addDataList.add(newData);
            }
            ++index_old;
            ++index_new;
        }
    }
}

