/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.core;

import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.core.Dao_dataManager;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DateUtil;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.InsertUtil;
import com.sagacloud.util.compute_engine.util.TimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataCache {
    private Map<String, Map<String, List<TimeSpan>>> TimeSpanListMapMap = new HashMap<String, Map<String, List<TimeSpan>>>();
    private Map<String, Map<String, List<DoubleTimeObject>>> DataListMapMap = new HashMap<String, Map<String, List<DoubleTimeObject>>>();

    public void SetData(String input_sign, Date timefrom, Date timeto, List dataListInner, String time_period) {
        if (!this.TimeSpanListMapMap.containsKey(input_sign)) {
            this.TimeSpanListMapMap.put(input_sign, new HashMap());
            this.DataListMapMap.put(input_sign, new HashMap());
        }
        Map<String, List<TimeSpan>> TimeSpanListMap = this.TimeSpanListMapMap.get(input_sign);
        Map<String, List<DoubleTimeObject>> DataListMap = this.DataListMapMap.get(input_sign);
        if (!TimeSpanListMap.containsKey(time_period)) {
            TimeSpanListMap.put(time_period, new ArrayList());
            DataListMap.put(time_period, new ArrayList());
        }
        List<TimeSpan> TimeSpanList = TimeSpanListMap.get(time_period);
        List<DoubleTimeObject> DataList = DataListMap.get(time_period);
        DateUtil.Instance().Merge(TimeSpanList, timefrom, timeto, time_period);
        this.InsertDataList(DataList, dataListInner);
    }

    public List<DoubleTimeObject> GetData(String input_sign, String dao_type, JSONObject dao_key, String time_period, Date timefrom, Date timeto) throws Exception {
        if (!this.TimeSpanListMapMap.containsKey(input_sign)) {
            this.TimeSpanListMapMap.put(input_sign, new HashMap());
            this.DataListMapMap.put(input_sign, new HashMap());
        }
        Map<String, List<TimeSpan>> TimeSpanListMap = this.TimeSpanListMapMap.get(input_sign);
        Map<String, List<DoubleTimeObject>> DataListMap = this.DataListMapMap.get(input_sign);
        if (!TimeSpanListMap.containsKey(time_period)) {
            TimeSpanListMap.put(time_period, new ArrayList());
            DataListMap.put(time_period, new ArrayList());
        }
        List<TimeSpan> TimeSpanList = TimeSpanListMap.get(time_period);
        List<DoubleTimeObject> DataList = DataListMap.get(time_period);
        List<TimeSpan> intervalList = DateUtil.Instance().Merge(TimeSpanList, timefrom, timeto, time_period);
        for (int i = 0; i < intervalList.size(); ++i) {
            TimeSpan intervalInner = intervalList.get(i);
            long interval_real = DateUtil.Instance().get_about(time_period);
            long interval_15min = DateUtil.Instance().get_about("15min");
            long interval_1h = DateUtil.Instance().get_about("1h");
            String time_period_query = time_period;
            if (ConstantCE.high_density_enable && dao_type.equals("servicedata") && interval_real < interval_15min) {
                time_period_query = "15min";
            }
            List<DoubleTimeObject> dataListInner = Dao_dataManager.Instance().Get(dao_type).GetDataListGteLte(dao_key, time_period_query, intervalInner.timefrom, intervalInner.timeto, true);
            if (ConstantCE.high_density_enable && dao_type.equals("servicedata") && interval_real < interval_15min) {
                dataListInner = this.sub_cycle(dataListInner, interval_15min, interval_real);
            }
            if (ConstantCE.high_density_enable) {
                if (dao_type.equals("servicedata") && interval_real < interval_1h && dataListInner.size() == 0) {
                    dataListInner = Dao_dataManager.Instance().Get(dao_type).GetDataListGteLte(dao_key, "1h", intervalInner.timefrom, intervalInner.timeto, true);
                    dataListInner = this.sub_cycle(dataListInner, interval_1h, interval_real);
                }
                if ((dao_type.equals("energydata") || dao_type.equals("objectdata")) && interval_real < interval_15min && dataListInner.size() == 0) {
                    dataListInner = Dao_dataManager.Instance().Get(dao_type).GetDataListGteLte(dao_key, "15min", intervalInner.timefrom, intervalInner.timeto, true);
                    dataListInner = this.sub_cycle(dataListInner, interval_15min, interval_real);
                }
                if ((dao_type.equals("energydata") || dao_type.equals("objectdata")) && interval_real < interval_1h && dataListInner.size() == 0) {
                    dataListInner = Dao_dataManager.Instance().Get(dao_type).GetDataListGteLte(dao_key, "1h", intervalInner.timefrom, intervalInner.timeto, true);
                    dataListInner = this.sub_cycle(dataListInner, interval_1h, interval_real);
                }
            }
            this.InsertDataList(DataList, dataListInner);
        }
        DoubleTimeObject datafrom = new DoubleTimeObject(timefrom, 0.0);
        DoubleTimeObject datato = new DoubleTimeObject(timeto, 0.0);
        int index_from = InsertUtil.Instance().FindInsertIndex(DataList, datafrom, true, 0);
        int index_to = InsertUtil.Instance().FindInsertIndex(DataList, datato, true, 1);
        ArrayList<DoubleTimeObject> result = new ArrayList<DoubleTimeObject>();
        for (int i = index_from; i < index_to; ++i) {
            result.add(DataList.get(i));
        }
        return result;
    }

    public List<DoubleTimeObject> sub_cycle(List<DoubleTimeObject> dataListInner, long interval_15min, long interval_real) {
        long count = interval_15min / interval_real;
        ArrayList<DoubleTimeObject> inputDataList_arrange = new ArrayList<DoubleTimeObject>();
        for (DoubleTimeObject data_ori : dataListInner) {
            int index_tmp = 0;
            while ((long)index_tmp < count) {
                DoubleTimeObject data_real = new DoubleTimeObject();
                data_real.data_time = new Date(data_ori.data_time.getTime() + interval_real * (long)index_tmp);
                data_real.data_value = data_ori.data_value / (double)count;
                inputDataList_arrange.add(data_real);
                ++index_tmp;
            }
        }
        return inputDataList_arrange;
    }

    public void PutData(String input_sign, String time_period, Date timefrom, Date timeto, List<DoubleTimeObject> dataListTmp) {
        if (!this.TimeSpanListMapMap.containsKey(input_sign)) {
            this.TimeSpanListMapMap.put(input_sign, new HashMap());
            this.DataListMapMap.put(input_sign, new HashMap());
        }
        Map<String, List<TimeSpan>> TimeSpanListMap = this.TimeSpanListMapMap.get(input_sign);
        Map<String, List<DoubleTimeObject>> DataListMap = this.DataListMapMap.get(input_sign);
        if (!TimeSpanListMap.containsKey(time_period)) {
            TimeSpanListMap.put(time_period, new ArrayList());
            DataListMap.put(time_period, new ArrayList());
        }
        List<TimeSpan> TimeSpanList = TimeSpanListMap.get(time_period);
        List<DoubleTimeObject> DataList = DataListMap.get(time_period);
        DateUtil.Instance().Merge(TimeSpanList, timefrom, timeto, time_period);
        this.InsertDataList(DataList, dataListTmp);
    }

    private void InsertDataList(List<DoubleTimeObject> DataList, List dataListInner) {
        for (int i = 0; i < dataListInner.size(); ++i) {
            Object dataObject = dataListInner.get(i);
            if (!(dataObject instanceof DoubleTimeObject)) continue;
            InsertUtil.Instance().InsertIntoDataList(DataList, (DoubleTimeObject)dataObject);
        }
    }
}

