/*
 * Decompiled with CFR 0.152.
 */
package tables;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import utils.CommonUtil;
import utils.ConfigUtil;
import utils.DpUtil;
import utils.QueryType;

public class InfoCode {
    private static final String table_scheme = "infocode_scheme";
    private static final String table_scheme_follower = "infocode_scheme_follower";
    private static final String table_scheme_detail = "infocode_scheme_detail";

    public static void fetch() {
        List<String> schemeIdList = InfoCode.getSchemeId();
        if (schemeIdList.size() == 0) {
            return;
        }
        JSONArray criterias = new JSONArray();
        for (String schemeId : schemeIdList) {
            JSONObject node = new JSONObject();
            node.put("scheme_id", (Object)schemeId);
            criterias.add(node);
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("Criterias", (Object)criterias);
        JSONArray data = DpUtil.query(ConfigUtil.getDataBase(), table_scheme, QueryType.combine_select, queryJson);
        CommonUtil.exportData(table_scheme, data);
        data = DpUtil.query(ConfigUtil.getDataBase(), table_scheme_detail, QueryType.combine_select, queryJson);
        CommonUtil.exportData(table_scheme_detail, data);
    }

    private static List<String> getSchemeId() {
        ArrayList<String> result = new ArrayList<String>();
        JSONArray data = DpUtil.query(ConfigUtil.getDataBase(), table_scheme_follower, QueryType.combine_select, ConfigUtil.getCriterias());
        for (int i = 0; i < data.size(); ++i) {
            JSONObject obj = data.getJSONObject(i);
            String schemeId = obj.getString("scheme_id");
            result.add(schemeId);
        }
        CommonUtil.exportData(table_scheme_follower, data);
        return result;
    }
}

