/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    public static final String UTF8 = "UTF-8";
    private static final AtomicInteger flag = new AtomicInteger(0);

    private static String getFlag() {
        int result = flag.addAndGet(1);
        if (result > 99999999) {
            flag.set(0);
        }
        return 100000000 + result + "";
    }

    @Deprecated
    public static String getJson(String url) {
        HttpResult result = HttpUtil.get(url, 0);
        return result.getContent();
    }

    public static String get(String url, Map<String, Object> param) {
        return HttpUtil.get(url, param, false);
    }

    public static String get(String url, Map<String, Object> param, boolean urlEncode) {
        String path = HttpUtil.parseUrl(url, param, urlEncode);
        HttpResult httpResult = HttpUtil.get(path, 0);
        return httpResult.getContent();
    }

    public static String postJson(String url, Map<String, Object> param, Object requestBody) {
        return HttpUtil.postJson(url, param, requestBody, 0);
    }

    public static String postJson(String url, Map<String, Object> param, Object requestBody, int timeout) {
        String server = HttpUtil.parseUrl(url, param, false);
        String requestBodyStr = requestBody instanceof String ? (String)requestBody : JSONObject.toJSONString(requestBody);
        HttpResult result = HttpUtil.post(server, requestBodyStr, timeout);
        return result.getContent();
    }

    public static HttpResult post(String url, String requestBody, int timeout) {
        String flag = HttpUtil.getFlag();
        long begin = System.currentTimeMillis();
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse resp = null;
        HttpResult result = new HttpResult();
        try {
            logger.info("{} httputils request: {}", (Object)flag, (Object)url);
            logger.info("{} httputils requestbody: {}", (Object)flag, (Object)requestBody);
            HttpPost post = new HttpPost(url);
            post.addHeader("contentType", "application/json;charset=UTF-8");
            post.addHeader("Accept", "application/json");
            if (requestBody != null) {
                StringEntity entity = new StringEntity(requestBody, UTF8);
                entity.setContentType("application/json");
                post.setEntity(entity);
            }
            HttpUtil.setTimeOut(post, timeout);
            resp = client.execute(post);
            int status = resp.getStatusLine().getStatusCode();
            result.setStatus(status);
            HttpEntity r = resp.getEntity();
            String respContent = EntityUtils.toString(r, UTF8);
            result.setContent(respContent);
            logger.info("{} httputils resp : {}", (Object)flag, (Object)HttpUtil.getLogMsg(respContent));
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                logger.error("{} httputils exception : ", (Object)flag, (Object)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpUtil.close(client, resp);
                logger.info("{} httputils timeconsuming : {} {}", flag, System.currentTimeMillis() - begin, url);
                throw throwable;
            }
        }
        HttpUtil.close(client, resp);
        logger.info("{} httputils timeconsuming : {} {}", flag, System.currentTimeMillis() - begin, url);
        return result;
    }

    public static HttpResult get(String url, int timeout) {
        String flag = HttpUtil.getFlag();
        long begin = System.currentTimeMillis();
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse resp = null;
        HttpResult result = new HttpResult();
        try {
            logger.info("{} httputils request: {}", (Object)flag, (Object)url);
            HttpGet get = new HttpGet(url);
            HttpUtil.setTimeOut(get, timeout);
            resp = client.execute(get);
            int status = resp.getStatusLine().getStatusCode();
            result.setStatus(status);
            HttpEntity r = resp.getEntity();
            String respContent = EntityUtils.toString(r, UTF8);
            result.setContent(respContent);
            logger.info("{} httputils resp: {}", (Object)flag, (Object)HttpUtil.getLogMsg(respContent));
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                logger.error("{} httputils exception: ", (Object)flag, (Object)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HttpUtil.close(client, resp);
                logger.info("{} httputils timeconsuming: {} {}", flag, System.currentTimeMillis() - begin, url);
                throw throwable;
            }
        }
        HttpUtil.close(client, resp);
        logger.info("{} httputils timeconsuming: {} {}", flag, System.currentTimeMillis() - begin, url);
        return result;
    }

    public static HttpResult sendGet(String url, Map<?, Object> param, boolean urlEncode, int timeout) {
        String path = HttpUtil.parseUrl(url, param, urlEncode);
        return HttpUtil.get(path, timeout);
    }

    private static String parseUri(Map<?, Object> param) {
        StringBuilder buff = new StringBuilder();
        if (param != null && param.size() > 0) {
            for (Map.Entry<?, Object> entry : param.entrySet()) {
                Object key = entry.getKey();
                String value = entry.getValue().toString();
                buff.append("&").append(key.toString()).append("=").append(value);
            }
            return buff.substring(1);
        }
        return "";
    }

    public static String parseUrl(String url, String uri, boolean needEncode) {
        if (uri == null) {
            return url;
        }
        String result = url.indexOf("?") > -1 ? url + "&" + uri : url + "?" + uri;
        if (needEncode) {
            int idx = result.indexOf("?");
            if (idx == -1) {
                return result;
            }
            try {
                String queryStr = URLEncoder.encode(result.substring(idx), UTF8);
                return result.substring(0, idx) + queryStr;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String parseUrl(String url, Map<?, Object> param, boolean needEncode) {
        return HttpUtil.parseUrl(url, HttpUtil.parseUri(param), needEncode);
    }

    private static void setTimeOut(HttpRequestBase req, int timeout) {
        if (timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(3000).setSocketTimeout(timeout).build();
            req.setConfig(requestConfig);
        }
    }

    private static String getLogMsg(String respContent) {
        if (respContent == null) {
            return "null";
        }
        if (respContent.length() > 200) {
            return respContent.substring(0, 200);
        }
        return respContent;
    }

    private static void close(CloseableHttpClient client, CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class HttpResult {
        private Integer status;
        private String content;

        public boolean success() {
            return this.status == 200;
        }

        public Integer getStatus() {
            return this.status;
        }

        public String getContent() {
            return this.content;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpResult)) {
                return false;
            }
            HttpResult other = (HttpResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.getStatus();
            Integer other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        public String toString() {
            return "HttpUtil.HttpResult(status=" + this.getStatus() + ", content=" + this.getContent() + ")";
        }
    }
}

