/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.marshaller;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.management.MBeanServer;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeLoadBalancer;
import org.apache.ignite.compute.ComputeTaskContinuousMapper;
import org.apache.ignite.compute.ComputeTaskSession;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridLoggerProxy;
import org.apache.ignite.internal.executor.GridExecutorService;
import org.apache.ignite.internal.util.GridBoundedConcurrentLinkedHashMap;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;

public final class MarshallerExclusions {
    private static final Class<?>[] INCL_CLASSES = new Class[]{GridLoggerProxy.class, GridExecutorService.class};
    private static final Map<Class<?>, Boolean> cache = new GridBoundedConcurrentLinkedHashMap(512, 512, 0.75f, 16);
    private static final Class<?>[] EXCL_CLASSES;

    private MarshallerExclusions() {
    }

    private static boolean isExcluded0(Class<?> cls) {
        assert (cls != null);
        Class<?>[] inc = INCL_CLASSES;
        for (int i = 0; i < inc.length; ++i) {
            if (!inc[i].isAssignableFrom(cls)) continue;
            return false;
        }
        Class<?>[] exc = EXCL_CLASSES;
        for (int i = 0; i < exc.length; ++i) {
            if (!exc[i].isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExcluded(Class<?> cls) {
        Boolean res = cache.get(cls);
        if (res == null) {
            res = MarshallerExclusions.isExcluded0(cls);
            cache.put(cls, res);
        }
        return res;
    }

    public static void clearCache() {
        cache.clear();
    }

    static {
        Class<?> springCtxCls = null;
        try {
            springCtxCls = Class.forName("org.springframework.context.ApplicationContext");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList excl = new ArrayList();
        excl.add(MBeanServer.class);
        excl.add(ExecutorService.class);
        excl.add(ClassLoader.class);
        excl.add(Thread.class);
        if (springCtxCls != null) {
            excl.add(springCtxCls);
        }
        excl.add(IgniteLogger.class);
        excl.add(ComputeTaskSession.class);
        excl.add(ComputeLoadBalancer.class);
        excl.add(ComputeJobContext.class);
        excl.add(Marshaller.class);
        excl.add(GridComponent.class);
        excl.add(ComputeTaskContinuousMapper.class);
        EXCL_CLASSES = U.toArray(excl, new Class[excl.size()]);
    }
}

