/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryFetchRequest
extends JdbcRequest {
    private long queryId;
    private int pageSize;

    JdbcQueryFetchRequest() {
        super((byte)3);
    }

    public JdbcQueryFetchRequest(long queryId, int pageSize) {
        super((byte)3);
        this.queryId = queryId;
        this.pageSize = pageSize;
    }

    public long queryId() {
        return this.queryId;
    }

    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer) throws BinaryObjectException {
        super.writeBinary(writer);
        writer.writeLong(this.queryId);
        writer.writeInt(this.pageSize);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader) throws BinaryObjectException {
        super.readBinary(reader);
        this.queryId = reader.readLong();
        this.pageSize = reader.readInt();
    }

    public String toString() {
        return S.toString(JdbcQueryFetchRequest.class, this);
    }
}

