/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheAtomicLongValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;

public final class GridCacheAtomicLongImpl
extends AtomicDataStructureProxy<GridCacheAtomicLongValue>
implements GridCacheAtomicLongEx,
IgniteChangeGlobalStateSupport,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };

    public GridCacheAtomicLongImpl() {
    }

    public GridCacheAtomicLongImpl(String name, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheAtomicLongValue> atomicView) {
        super(name, key, atomicView);
    }

    @Override
    public long get() {
        this.checkRemoved();
        try {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)this.cacheView.get(this.key);
            if (val == null) {
                throw new IgniteException("Failed to find atomic long: " + this.name);
            }
            return val.get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long incrementAndGet() {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, IncrementAndGetProcessor.INSTANCE, new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get();
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndIncrement() {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, GetAndIncrementProcessor.INSTANCE, new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get();
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long addAndGet(long l) {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, new AddAndGetProcessor(l), new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get();
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndAdd(long l) {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, new GetAndAddProcessor(l), new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get();
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long decrementAndGet() {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, DecrementAndGetProcessor.INSTANCE, new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get();
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndDecrement() {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, GetAndDecrementProcessor.INSTANCE, new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get();
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public long getAndSet(long l) {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, new GetAndSetProcessor(l), new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get();
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean compareAndSet(long expVal, long newVal) {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, new CompareAndSetProcessor(expVal, newVal), new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get() == expVal;
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    public long compareAndSetAndGet(long expVal, long newVal) {
        this.checkRemoved();
        try {
            EntryProcessorResult<Long> res = this.cacheView.invoke(this.key, new CompareAndSetProcessor(expVal, newVal), new Object[0]);
            assert (res != null && res.get() != null) : res;
            return (Long)res.get();
        }
        catch (EntryProcessorException e) {
            throw new IgniteException(e.getMessage(), e);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void close() {
        if (this.rmvd) {
            return;
        }
        try {
            this.ctx.kernalContext().dataStructures().removeAtomicLong(this.name, this.ctx.group().name());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteAtomicLong igniteAtomicLong = t.get1().dataStructures().atomicLong(t.get2(), null, 0L, false);
            return igniteAtomicLong;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return S.toString(GridCacheAtomicLongImpl.class, this);
    }

    static class DecrementAndGetProcessor
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicLongValue, Long> {
        private static final long serialVersionUID = 0L;
        private static final DecrementAndGetProcessor INSTANCE = new DecrementAndGetProcessor();

        DecrementAndGetProcessor() {
        }

        public Long process(MutableEntry<GridCacheInternalKey, GridCacheAtomicLongValue> e, Object ... args) {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic long: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            long newVal = val.get() - 1L;
            e.setValue((Object)new GridCacheAtomicLongValue(newVal));
            return newVal;
        }

        public String toString() {
            return S.toString(DecrementAndGetProcessor.class, this);
        }
    }

    static class GetAndDecrementProcessor
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicLongValue, Long> {
        private static final long serialVersionUID = 0L;
        private static final GetAndDecrementProcessor INSTANCE = new GetAndDecrementProcessor();

        GetAndDecrementProcessor() {
        }

        public Long process(MutableEntry<GridCacheInternalKey, GridCacheAtomicLongValue> e, Object ... args) {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic long: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            long ret = val.get();
            e.setValue((Object)new GridCacheAtomicLongValue(ret - 1L));
            return ret;
        }

        public String toString() {
            return S.toString(GetAndDecrementProcessor.class, this);
        }
    }

    static class IncrementAndGetProcessor
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicLongValue, Long> {
        private static final long serialVersionUID = 0L;
        private static final IncrementAndGetProcessor INSTANCE = new IncrementAndGetProcessor();

        IncrementAndGetProcessor() {
        }

        public Long process(MutableEntry<GridCacheInternalKey, GridCacheAtomicLongValue> e, Object ... args) {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic long: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            long newVal = val.get() + 1L;
            e.setValue((Object)new GridCacheAtomicLongValue(newVal));
            return newVal;
        }

        public String toString() {
            return S.toString(IncrementAndGetProcessor.class, this);
        }
    }

    static class GetAndIncrementProcessor
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicLongValue, Long> {
        private static final long serialVersionUID = 0L;
        private static final GetAndIncrementProcessor INSTANCE = new GetAndIncrementProcessor();

        GetAndIncrementProcessor() {
        }

        public Long process(MutableEntry<GridCacheInternalKey, GridCacheAtomicLongValue> e, Object ... args) {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic long: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            long ret = val.get();
            e.setValue((Object)new GridCacheAtomicLongValue(ret + 1L));
            return ret;
        }

        public String toString() {
            return S.toString(GetAndIncrementProcessor.class, this);
        }
    }

    static class CompareAndSetProcessor
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicLongValue, Long> {
        private static final long serialVersionUID = 0L;
        private final long expVal;
        private final long newVal;

        CompareAndSetProcessor(long expVal, long newVal) {
            this.expVal = expVal;
            this.newVal = newVal;
        }

        public Long process(MutableEntry<GridCacheInternalKey, GridCacheAtomicLongValue> e, Object ... args) {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic long: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            long curVal = val.get();
            if (curVal == this.expVal) {
                e.setValue((Object)new GridCacheAtomicLongValue(this.newVal));
            }
            return curVal;
        }

        public String toString() {
            return S.toString(CompareAndSetProcessor.class, this);
        }
    }

    static class AddAndGetProcessor
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicLongValue, Long> {
        private static final long serialVersionUID = 0L;
        private final long delta;

        AddAndGetProcessor(long delta) {
            this.delta = delta;
        }

        public Long process(MutableEntry<GridCacheInternalKey, GridCacheAtomicLongValue> e, Object ... args) {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic long: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            long newVal = val.get() + this.delta;
            e.setValue((Object)new GridCacheAtomicLongValue(newVal));
            return newVal;
        }

        public String toString() {
            return S.toString(AddAndGetProcessor.class, this);
        }
    }

    static class GetAndAddProcessor
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicLongValue, Long> {
        private static final long serialVersionUID = 0L;
        private final long delta;

        GetAndAddProcessor(long delta) {
            this.delta = delta;
        }

        public Long process(MutableEntry<GridCacheInternalKey, GridCacheAtomicLongValue> e, Object ... args) {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic long: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            long curVal = val.get();
            e.setValue((Object)new GridCacheAtomicLongValue(curVal + this.delta));
            return curVal;
        }

        public String toString() {
            return S.toString(GetAndAddProcessor.class, this);
        }
    }

    static class GetAndSetProcessor
    implements CacheEntryProcessor<GridCacheInternalKey, GridCacheAtomicLongValue, Long> {
        private static final long serialVersionUID = 0L;
        private final long newVal;

        GetAndSetProcessor(long newVal) {
            this.newVal = newVal;
        }

        public Long process(MutableEntry<GridCacheInternalKey, GridCacheAtomicLongValue> e, Object ... args) {
            GridCacheAtomicLongValue val = (GridCacheAtomicLongValue)e.getValue();
            if (val == null) {
                throw new EntryProcessorException("Failed to find atomic long: " + ((GridCacheInternalKey)e.getKey()).name());
            }
            long curVal = val.get();
            e.setValue((Object)new GridCacheAtomicLongValue(this.newVal));
            return curVal;
        }

        public String toString() {
            return S.toString(GetAndSetProcessor.class, this);
        }
    }
}

