/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IncompleteCacheObject;
import org.apache.ignite.internal.processors.cache.IncompleteObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPagePayload;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CacheDataRowAdapter
implements CacheDataRow {
    @GridToStringExclude
    protected long link;
    @GridToStringInclude
    protected KeyCacheObject key;
    @GridToStringInclude
    protected CacheObject val;
    protected long expireTime = -1L;
    @GridToStringInclude
    protected GridCacheVersion ver;
    @GridToStringInclude
    protected int cacheId;

    public CacheDataRowAdapter(long link) {
        this.link = link;
    }

    public CacheDataRowAdapter(KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime) {
        this.key = key;
        this.val = val;
        this.ver = ver;
        this.expireTime = expireTime;
    }

    public final void initFromLink(CacheGroupContext grp, RowData rowData) throws IgniteCheckedException {
        this.initFromLink(grp, grp.shared(), grp.dataRegion().pageMemory(), rowData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void initFromLink(@Nullable CacheGroupContext grp, GridCacheSharedContext<?, ?> sharedCtx, PageMemory pageMem, RowData rowData) throws IgniteCheckedException {
        assert (this.link != 0L) : "link";
        assert (this.key == null) : "key";
        CacheObjectContext coctx = grp != null ? grp.cacheObjectContext() : null;
        boolean readCacheId = grp == null || grp.storeCacheIdInDataPage();
        long nextLink = this.link;
        IncompleteObject<?> incomplete = null;
        boolean first = true;
        do {
            long pageId = PageIdUtils.pageId(nextLink);
            assert (grp != null || pageMem instanceof PageMemoryNoStoreImpl);
            int grpId = grp != null ? grp.groupId() : 0;
            long page = pageMem.acquirePage(grpId, pageId);
            try {
                long pageAddr = pageMem.readLock(grpId, pageId, page);
                assert (pageAddr != 0L) : nextLink;
                try {
                    DataPageIO io = DataPageIO.VERSIONS.forPage(pageAddr);
                    DataPagePayload data = io.readPayload(pageAddr, PageIdUtils.itemId(nextLink), pageMem.pageSize());
                    nextLink = data.nextLink();
                    if (first) {
                        if (nextLink == 0L) {
                            this.readFullRow(sharedCtx, coctx, pageAddr + (long)data.offset(), rowData, readCacheId);
                            return;
                        }
                        first = false;
                    }
                    ByteBuffer buf = pageMem.pageBuffer(pageAddr);
                    buf.position(data.offset());
                    buf.limit(data.offset() + data.payloadSize());
                    boolean keyOnly = rowData == RowData.KEY_ONLY;
                    incomplete = this.readFragment(sharedCtx, coctx, buf, keyOnly, readCacheId, incomplete);
                    if (keyOnly && this.key != null) {
                        return;
                    }
                }
                finally {
                    pageMem.readUnlock(grpId, pageId, page);
                }
            }
            finally {
                pageMem.releasePage(grpId, pageId, page);
            }
        } while (nextLink != 0L);
        if ($assertionsDisabled) return;
        if (this.isReady()) return;
        throw new AssertionError((Object)"ready");
    }

    private IncompleteObject<?> readFragment(GridCacheSharedContext<?, ?> sharedCtx, CacheObjectContext coctx, ByteBuffer buf, boolean keyOnly, boolean readCacheId, IncompleteObject<?> incomplete) throws IgniteCheckedException {
        if (readCacheId && this.cacheId == 0) {
            incomplete = this.readIncompleteCacheId(buf, incomplete);
            if (this.cacheId == 0) {
                return incomplete;
            }
            incomplete = null;
        }
        if (coctx == null) {
            assert (this.cacheId != 0);
            coctx = sharedCtx.cacheContext(this.cacheId).cacheObjectContext();
        }
        if (this.key == null) {
            incomplete = this.readIncompleteKey(coctx, buf, (IncompleteCacheObject)incomplete);
            if (this.key == null || keyOnly) {
                return incomplete;
            }
            incomplete = null;
        }
        if (this.expireTime == -1L) {
            incomplete = this.readIncompleteExpireTime(buf, incomplete);
            if (this.expireTime == -1L) {
                return incomplete;
            }
            incomplete = null;
        }
        if (this.val == null) {
            incomplete = this.readIncompleteValue(coctx, buf, (IncompleteCacheObject)incomplete);
            if (this.val == null) {
                return incomplete;
            }
            incomplete = null;
        }
        if (this.ver == null) {
            incomplete = this.readIncompleteVersion(buf, incomplete);
        }
        return incomplete;
    }

    private void readFullRow(GridCacheSharedContext<?, ?> sharedCtx, CacheObjectContext coctx, long addr, RowData rowData, boolean readCacheId) throws IgniteCheckedException {
        byte[] bytes;
        byte type;
        int off = 0;
        if (readCacheId) {
            this.cacheId = PageUtils.getInt(addr, off);
            off += 4;
        }
        if (coctx == null) {
            coctx = sharedCtx.cacheContext(this.cacheId).cacheObjectContext();
        }
        int len = PageUtils.getInt(addr, off);
        off += 4;
        if (rowData != RowData.NO_KEY) {
            type = PageUtils.getByte(addr, off);
            bytes = PageUtils.getBytes(addr, ++off, len);
            off += len;
            this.key = coctx.kernalContext().cacheObjects().toKeyCacheObject(coctx, type, bytes);
            if (rowData == RowData.KEY_ONLY) {
                return;
            }
        } else {
            off += len + 1;
        }
        len = PageUtils.getInt(addr, off);
        type = PageUtils.getByte(addr, off += 4);
        bytes = PageUtils.getBytes(addr, ++off, len);
        this.val = coctx.kernalContext().cacheObjects().toCacheObject(coctx, type, bytes);
        this.ver = CacheVersionIO.read(addr + (long)(off += len), false);
        this.expireTime = PageUtils.getLong(addr, off += CacheVersionIO.size(this.ver, false));
    }

    private IncompleteObject<?> readIncompleteCacheId(ByteBuffer buf, IncompleteObject<?> incomplete) {
        if (incomplete == null) {
            int remaining = buf.remaining();
            if (remaining == 0) {
                return null;
            }
            int size = 4;
            if (remaining >= size) {
                this.cacheId = buf.getInt();
                assert (this.cacheId != 0);
                return null;
            }
            incomplete = new IncompleteObject(new byte[size]);
        }
        incomplete.readData(buf);
        if (incomplete.isReady()) {
            ByteBuffer timeBuf = ByteBuffer.wrap(incomplete.data());
            timeBuf.order(buf.order());
            this.cacheId = timeBuf.getInt();
            assert (this.cacheId != 0);
        }
        return incomplete;
    }

    private IncompleteCacheObject readIncompleteKey(CacheObjectContext coctx, ByteBuffer buf, IncompleteCacheObject incomplete) throws IgniteCheckedException {
        incomplete = coctx.kernalContext().cacheObjects().toKeyCacheObject(coctx, buf, incomplete);
        if (incomplete.isReady()) {
            this.key = (KeyCacheObject)incomplete.object();
            assert (this.key != null);
        } else assert (!buf.hasRemaining());
        return incomplete;
    }

    private IncompleteCacheObject readIncompleteValue(CacheObjectContext coctx, ByteBuffer buf, IncompleteCacheObject incomplete) throws IgniteCheckedException {
        incomplete = coctx.kernalContext().cacheObjects().toCacheObject(coctx, buf, incomplete);
        if (incomplete.isReady()) {
            this.val = (CacheObject)incomplete.object();
            assert (this.val != null);
        } else assert (!buf.hasRemaining());
        return incomplete;
    }

    private IncompleteObject<?> readIncompleteExpireTime(ByteBuffer buf, IncompleteObject<?> incomplete) {
        if (incomplete == null) {
            int remaining = buf.remaining();
            if (remaining == 0) {
                return null;
            }
            int size = 8;
            if (remaining >= size) {
                this.expireTime = buf.getLong();
                assert (this.expireTime >= 0L) : this.expireTime;
                return null;
            }
            incomplete = new IncompleteObject(new byte[size]);
        }
        incomplete.readData(buf);
        if (incomplete.isReady()) {
            ByteBuffer timeBuf = ByteBuffer.wrap(incomplete.data());
            timeBuf.order(buf.order());
            this.expireTime = timeBuf.getLong();
            assert (this.expireTime >= 0L);
        }
        return incomplete;
    }

    private IncompleteObject<?> readIncompleteVersion(ByteBuffer buf, IncompleteObject<?> incomplete) throws IgniteCheckedException {
        if (incomplete == null) {
            int remaining = buf.remaining();
            if (remaining == 0) {
                return null;
            }
            int size = CacheVersionIO.readSize(buf, false);
            if (remaining >= size) {
                this.ver = CacheVersionIO.read(buf, false);
                assert (!buf.hasRemaining()) : buf.remaining();
                assert (this.ver != null);
                return null;
            }
            incomplete = new IncompleteObject(new byte[size]);
        }
        incomplete.readData(buf);
        if (incomplete.isReady()) {
            ByteBuffer verBuf = ByteBuffer.wrap(incomplete.data());
            verBuf.order(buf.order());
            this.ver = CacheVersionIO.read(verBuf, false);
            assert (this.ver != null);
        }
        assert (!buf.hasRemaining());
        return incomplete;
    }

    public boolean isReady() {
        return this.ver != null && this.val != null && this.key != null;
    }

    @Override
    public KeyCacheObject key() {
        assert (this.key != null) : "Key is not ready: " + this;
        return this.key;
    }

    @Override
    public void key(KeyCacheObject key) {
        assert (key != null);
        this.key = key;
    }

    @Override
    public int cacheId() {
        return this.cacheId;
    }

    @Override
    public CacheObject value() {
        assert (this.val != null) : "Value is not ready: " + this;
        return this.val;
    }

    @Override
    public GridCacheVersion version() {
        assert (this.ver != null) : "Version is not ready: " + this;
        return this.ver;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public int partition() {
        return PageIdUtils.partId(PageIdUtils.pageId(this.link));
    }

    @Override
    public long link() {
        return this.link;
    }

    @Override
    public void link(long link) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hash() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(CacheDataRowAdapter.class, this, "link", U.hexLong(this.link));
    }

    public static enum RowData {
        FULL,
        KEY_ONLY,
        NO_KEY;

    }
}

