/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class PagesListAddPageRecord
extends PageDeltaRecord {
    @GridToStringExclude
    private final long dataPageId;

    public PagesListAddPageRecord(int grpId, long pageId, long dataPageId) {
        super(grpId, pageId);
        this.dataPageId = dataPageId;
    }

    public long dataPageId() {
        return this.dataPageId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(pageAddr);
        int cnt = io.addPage(pageAddr, this.dataPageId, pageMem.pageSize());
        assert (cnt >= 0) : cnt;
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PAGES_LIST_ADD_PAGE;
    }

    @Override
    public String toString() {
        return S.toString(PagesListAddPageRecord.class, this, "dataPageId", U.hexLong(this.dataPageId), "super", super.toString());
    }
}

