/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.logger.platform;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformNativeException;
import org.apache.ignite.internal.processors.platform.callback.PlatformCallbackGateway;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class PlatformLogger
implements IgniteLogger {
    public static final int LVL_TRACE = 0;
    public static final int LVL_DEBUG = 1;
    public static final int LVL_INFO = 2;
    public static final int LVL_WARN = 3;
    public static final int LVL_ERROR = 4;
    @GridToStringExclude
    private volatile PlatformCallbackGateway gate;
    @GridToStringExclude
    private volatile PlatformContext ctx;
    @GridToStringExclude
    private final String category;
    @GridToStringInclude
    private volatile boolean traceEnabled;
    @GridToStringInclude
    private volatile boolean debugEnabled;
    @GridToStringInclude
    private volatile boolean infoEnabled;
    @GridToStringInclude
    private static final boolean isQuiet = Boolean.valueOf(System.getProperty("IGNITE_QUIET", "true"));

    public PlatformLogger() {
        this.category = null;
    }

    private PlatformLogger(PlatformCallbackGateway gate, PlatformContext ctx, String category, boolean traceEnabled, boolean debugEnabled, boolean infoEnabled) {
        this.gate = gate;
        this.ctx = ctx;
        this.category = category;
        this.traceEnabled = traceEnabled;
        this.debugEnabled = debugEnabled;
        this.infoEnabled = infoEnabled;
    }

    @Override
    public IgniteLogger getLogger(Object ctgr) {
        return new PlatformLogger(this.gate, this.ctx, PlatformLogger.getCategoryString(ctgr), this.traceEnabled, this.debugEnabled, this.infoEnabled);
    }

    @Override
    public void trace(String msg) {
        this.log(0, msg, null);
    }

    @Override
    public void debug(String msg) {
        this.log(1, msg, null);
    }

    @Override
    public void info(String msg) {
        this.log(2, msg, null);
    }

    @Override
    public void warning(String msg) {
        this.log(3, msg, null);
    }

    @Override
    public void warning(String msg, @Nullable Throwable e) {
        this.log(3, msg, e);
    }

    @Override
    public void error(String msg) {
        this.log(4, msg, null);
    }

    @Override
    public void error(String msg, @Nullable Throwable e) {
        this.log(4, msg, e);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    @Override
    public boolean isQuiet() {
        return isQuiet;
    }

    @Override
    public String fileName() {
        return null;
    }

    public void setGateway(PlatformCallbackGateway gate) {
        assert (gate != null);
        this.gate = gate;
        this.traceEnabled = gate.loggerIsLevelEnabled(0);
        this.debugEnabled = gate.loggerIsLevelEnabled(1);
        this.infoEnabled = gate.loggerIsLevelEnabled(2);
    }

    public void setContext(PlatformContext ctx) {
        assert (ctx != null);
        this.ctx = ctx;
    }

    private void log(int level, String msg, @Nullable Throwable e) {
        String errorInfo = null;
        if (e != null) {
            errorInfo = X.getFullStackTrace(e);
        }
        PlatformNativeException e0 = X.cause(e, PlatformNativeException.class);
        if (this.ctx != null && e0 != null) {
            try (PlatformMemory mem = this.ctx.memory().allocate();){
                PlatformOutputStream out = mem.output();
                BinaryRawWriterEx writer = this.ctx.writer(out);
                writer.writeObject(e0.cause());
                out.synchronize();
                this.gate.loggerLog(level, msg, this.category, errorInfo, mem.pointer());
            }
        } else {
            this.gate.loggerLog(level, msg, this.category, errorInfo, 0L);
        }
    }

    private static String getCategoryString(Object ctgr) {
        return ctgr instanceof Class ? ((Class)ctgr).getName() : (ctgr == null ? null : String.valueOf(ctgr));
    }

    public String toString() {
        return S.toString(PlatformLogger.class, this);
    }
}

