/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router.impl;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientData;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.GridClientTopologyListener;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.GridClientFutureAdapter;
import org.apache.ignite.internal.client.impl.GridClientImpl;
import org.apache.ignite.internal.client.impl.GridClientNodeImpl;
import org.apache.ignite.internal.client.impl.connection.GridClientConnection;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionManager;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.impl.connection.GridClientTopology;
import org.apache.ignite.internal.client.router.GridTcpRouterConfiguration;
import org.apache.ignite.internal.client.util.GridClientUtils;
import org.jetbrains.annotations.Nullable;

public class GridRouterClientImpl
implements GridClient {
    private final GridClientImpl clientImpl;
    private final GridClientConfiguration cliCfg;
    private final ConcurrentMap<Byte, GridClientConnectionManager> connMgrMap = new ConcurrentHashMap<Byte, GridClientConnectionManager>();

    GridRouterClientImpl(UUID id, GridTcpRouterConfiguration routerCfg) throws GridClientException {
        GridClientConfiguration cliCfg = new GridClientConfiguration();
        cliCfg.setServers(routerCfg.getServers());
        cliCfg.setSslContextFactory(routerCfg.getSslContextFactory());
        cliCfg.setSecurityCredentialsProvider(routerCfg.getSecurityCredentialsProvider());
        this.cliCfg = cliCfg;
        this.clientImpl = new GridClientImpl(id, cliCfg, true);
        if (cliCfg.getProtocol() != GridClientProtocol.TCP) {
            throw new AssertionError((Object)("Unknown protocol: " + (Object)((Object)cliCfg.getProtocol())));
        }
    }

    GridClientFutureAdapter<?> forwardMessage(Object msg, @Nullable UUID destId, byte marshId) throws GridClientException, InterruptedException {
        GridClientException cause;
        GridClientNode dest;
        GridClientTopology top = this.clientImpl.topology();
        GridClientNode gridClientNode = dest = destId != null ? top.node(destId) : this.cliCfg.getBalancer().balancedNode(GridClientUtils.applyFilter(top.nodes(), new GridClientPredicate<GridClientNodeImpl>(){

            @Override
            public boolean apply(GridClientNodeImpl e) {
                return GridClientUtils.restAvailable(e, GridRouterClientImpl.this.cliCfg.getProtocol());
            }
        }));
        if (dest == null) {
            throw new GridServerUnreachableException("Failed to resolve node for specified destination ID: " + destId);
        }
        GridClientConnectionManager connMgr = this.connectionManager(marshId);
        GridClientConnection conn = null;
        try {
            conn = connMgr.connection(dest);
            return conn.forwardMessage(msg);
        }
        catch (GridClientConnectionResetException e) {
            if (destId != null) {
                connMgr.terminateConnection(conn, top.node(destId), e);
            } else {
                connMgr.terminateConnection(conn, null, e);
            }
            cause = e;
        }
        catch (GridClientException e) {
            cause = e;
        }
        GridClientFutureAdapter fail = new GridClientFutureAdapter();
        fail.onDone(cause);
        return fail;
    }

    private GridClientConnectionManager connectionManager(byte marshId) throws GridClientException {
        GridClientConnectionManager mgr = (GridClientConnectionManager)this.connMgrMap.get(marshId);
        if (mgr == null) {
            mgr = this.clientImpl.newConnectionManager(marshId, true);
            GridClientConnectionManager old = this.connMgrMap.putIfAbsent(marshId, mgr);
            if (old != null) {
                mgr = old;
            }
        }
        return mgr;
    }

    public void stop(boolean wait) {
        this.clientImpl.stop(wait);
    }

    @Override
    public UUID id() {
        return this.clientImpl.id();
    }

    @Override
    public GridClientData data() throws GridClientException {
        return this.clientImpl.data();
    }

    @Override
    public GridClientData data(String cacheName) throws GridClientException {
        return this.clientImpl.data(cacheName);
    }

    @Override
    public GridClientCompute compute() {
        return this.clientImpl.compute();
    }

    @Override
    public GridClientClusterState state() {
        return this.clientImpl.state();
    }

    @Override
    public void addTopologyListener(GridClientTopologyListener lsnr) {
        this.clientImpl.addTopologyListener(lsnr);
    }

    @Override
    public void removeTopologyListener(GridClientTopologyListener lsnr) {
        this.clientImpl.removeTopologyListener(lsnr);
    }

    @Override
    public Collection<GridClientTopologyListener> topologyListeners() {
        return this.clientImpl.topologyListeners();
    }

    @Override
    public boolean connected() {
        return this.clientImpl.connected();
    }

    @Override
    public void close() {
        this.clientImpl.close();
    }
}

