/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.MarshallerContext;

final class MarshallerMappingFileStore {
    private static final GridStripedLock fileLock = new GridStripedLock(32);
    private final IgniteLogger log;
    private final File workDir;
    private final String FILE_EXTENSION = ".classname";

    MarshallerMappingFileStore(String igniteWorkDir, IgniteLogger log) throws IgniteCheckedException {
        this.workDir = U.resolveWorkDirectory(igniteWorkDir, "marshaller", false);
        this.log = log;
    }

    MarshallerMappingFileStore(IgniteLogger log, File marshallerMappingFileStoreDir) {
        this.workDir = marshallerMappingFileStoreDir;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMapping(byte platformId, int typeId, String typeName) {
        String fileName = this.getFileName(platformId, typeId);
        Lock lock = MarshallerMappingFileStore.fileLock(fileName);
        lock.lock();
        try {
            File file = new File(this.workDir, fileName);
            try (FileOutputStream out = new FileOutputStream(file);){
                FileLock fileLock = MarshallerMappingFileStore.fileLock(out.getChannel(), false);
                assert (fileLock != null) : fileName;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                    writer.write(typeName);
                    ((Writer)writer).flush();
                }
            }
            catch (IOException e) {
                U.error(this.log, "Failed to write class name to file [platformId=" + platformId + "id=" + typeId + ", clsName=" + typeName + ", file=" + file.getAbsolutePath() + ']', e);
            }
            catch (OverlappingFileLockException ignored) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("File already locked (will ignore): " + file.getAbsolutePath());
                }
            }
            catch (IgniteInterruptedCheckedException e) {
                U.error(this.log, "Interrupted while waiting for acquiring file lock: " + file, e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    String readMapping(byte platformId, int typeId) throws IgniteCheckedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void restoreMappings(MarshallerContext marshCtx) throws IgniteCheckedException {
        for (File file : this.workDir.listFiles()) {
            String name = file.getName();
            byte platformId = this.getPlatformId(name);
            int typeId = this.getTypeId(name);
            try (FileInputStream in = new FileInputStream(file);
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));){
                String clsName = reader.readLine();
                if (clsName == null) {
                    throw new IgniteCheckedException("Class name is null for [platformId=" + platformId + ", typeId=" + typeId + "], marshaller mappings storage is broken. " + "Clean up marshaller directory (<work_dir>/marshaller) and restart the node.");
                }
                marshCtx.registerClassNameLocally(platformId, typeId, clsName);
            }
            catch (IOException e) {
                throw new IgniteCheckedException("Reading marshaller mapping from file " + name + " failed.", e);
            }
        }
    }

    void mergeAndWriteMapping(byte platformId, int typeId, String typeName) throws IgniteCheckedException {
        String existingTypeName = this.readMapping(platformId, typeId);
        if (existingTypeName != null) {
            if (!existingTypeName.equals(typeName)) {
                throw new IgniteCheckedException("Failed to merge new and existing marshaller mappings. For [platformId=" + platformId + ", typeId=" + typeId + "]" + " new typeName=" + typeName + ", existing typeName=" + existingTypeName + "." + " Consider cleaning up persisted mappings from <workDir>/marshaller directory.");
            }
        } else {
            this.writeMapping(platformId, typeId, typeName);
        }
    }

    private byte getPlatformId(String fileName) throws IgniteCheckedException {
        byte platformId;
        String lastSymbol = fileName.substring(fileName.length() - 1);
        try {
            platformId = Byte.parseByte(lastSymbol);
        }
        catch (NumberFormatException e) {
            throw new IgniteCheckedException("Reading marshaller mapping from file " + fileName + " failed; last symbol of file name is expected to be numeric.", e);
        }
        return platformId;
    }

    private int getTypeId(String fileName) throws IgniteCheckedException {
        int typeId;
        try {
            typeId = Integer.parseInt(fileName.substring(0, fileName.indexOf(".classname")));
        }
        catch (NumberFormatException e) {
            throw new IgniteCheckedException("Reading marshaller mapping from file " + fileName + " failed; type ID is expected to be numeric.", e);
        }
        return typeId;
    }

    private String getFileName(byte platformId, int typeId) {
        return typeId + ".classname" + platformId;
    }

    private static Lock fileLock(String fileName) {
        return fileLock.getLock(fileName.hashCode());
    }

    private static FileLock fileLock(FileChannel ch, boolean shared) throws IOException, IgniteInterruptedCheckedException {
        FileLock fileLock;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        while ((fileLock = ch.tryLock(0L, Long.MAX_VALUE, shared)) == null) {
            U.sleep(rnd.nextLong(50L));
        }
        return fileLock;
    }
}

