/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.coprocessor;

import com.zillion.util.common.ByteToObject;
import com.zillion.util.common.HashObjectWrapper;
import com.zillion.util.common.HashUtil;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.coprocessor.ObserverTool;
import com.zillion.util.coprocessor.StatObject;
import com.zillion.util.coprocessor.StatObjectWrapper;
import com.zillion.util.coprocessor.StatTableWrapper;
import com.zillion.util.table.HTableUtil;
import com.zillion.util.table.SchemaRepository;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.zillion.util.common.HexToByte;
import org.zillion.util.log.LogUtil;

public class RegionObserver
extends BaseRegionObserver {
    public void start(CoprocessorEnvironment e) throws IOException {
        ObserverTool.Start(e.getConfiguration());
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
    }

    /*
     * Unable to fully structure code
     */
    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
        rce = (RegionCoprocessorEnvironment)e.getEnvironment();
        desc = rce.getRegion().getTableDesc();
        namespace = desc.getTableName().getNamespaceAsString();
        if (ZillionConstant.ReservedNamespaceMap.containsKey(namespace)) {
            return;
        }
        tableName_tmp = desc.getTableName().getNameAsString().substring(namespace.length() + 1);
        if (tableName_tmp.startsWith("zillion_data_") || tableName_tmp.startsWith("zillion_index_")) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
lbl14:
            // 3 sources

            ** while (!ObserverTool.container.initialized)
        }
lbl15:
        // 1 sources

        try {
            sowInner = new StatObject();
            cellList = results;
            this.StatReadRow(get.getRow(), cellList, sowInner);
            HRegionInfo = rce.getRegionInfo();
            region_name = String.valueOf(HRegionInfo.getTable().getNameAsString()) + "," + HRegionInfo.getEncodedName() + "," + Bytes.toStringBinary((byte[])HRegionInfo.getStartKey()) + "," + Bytes.toStringBinary((byte[])HRegionInfo.getEndKey());
            if (!ObserverTool.statMap.containsKey(region_name)) {
                ObserverTool.statMap.putIfAbsent(region_name, new StatTableWrapper());
            }
            milliseconds = new Date().getTime() / ObserverTool.stat_interval;
            sow = ((StatTableWrapper)ObserverTool.statMap.get(region_name)).get(milliseconds);
            sow.read_lines.addAndGet(sowInner.read_lines);
            sow.read_rowkey_bytes.addAndGet(sowInner.read_rowkey_bytes);
            sow.read_column_bytes.addAndGet(sowInner.read_column_bytes);
        }
        catch (Exception e1) {
            LogUtil.error(" ********************************** " + namespace + ":" + tableName_tmp + "\n");
            LogUtil.error(e1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        rce = (RegionCoprocessorEnvironment)e.getEnvironment();
        desc = rce.getRegion().getTableDesc();
        namespace = desc.getTableName().getNamespaceAsString();
        if (ZillionConstant.ReservedNamespaceMap.containsKey(namespace)) {
            return hasMore;
        }
        tableName_tmp = desc.getTableName().getNameAsString().substring(namespace.length() + 1);
        if (tableName_tmp.startsWith("zillion_data_") || tableName_tmp.startsWith("zillion_index_")) ** GOTO lbl14
        return hasMore;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
lbl14:
            // 3 sources

            ** while (!ObserverTool.container.initialized)
        }
lbl15:
        // 1 sources

        try {
            sowInner = new StatObject();
            for (Result result : results) {
                cellList = result.listCells();
                this.StatReadRow(result.getRow(), cellList, sowInner);
            }
            HRegionInfo = rce.getRegionInfo();
            region_name = String.valueOf(HRegionInfo.getTable().getNameAsString()) + "," + HRegionInfo.getEncodedName() + "," + Bytes.toStringBinary((byte[])HRegionInfo.getStartKey()) + "," + Bytes.toStringBinary((byte[])HRegionInfo.getEndKey());
            if (!ObserverTool.statMap.containsKey(region_name)) {
                ObserverTool.statMap.putIfAbsent(region_name, new StatTableWrapper());
            }
            milliseconds = new Date().getTime() / ObserverTool.stat_interval;
            sow = ((StatTableWrapper)ObserverTool.statMap.get(region_name)).get(milliseconds);
            sow.read_lines.addAndGet(sowInner.read_lines);
            sow.read_rowkey_bytes.addAndGet(sowInner.read_rowkey_bytes);
            sow.read_column_bytes.addAndGet(sowInner.read_column_bytes);
        }
        catch (Exception e1) {
            LogUtil.error(" ********************************** " + namespace + ":" + tableName_tmp + "\n");
            LogUtil.error(e1);
        }
        return hasMore;
    }

    private void StatReadRow(byte[] rowkey, List<Cell> cellList, StatObject sowInner) {
        int rowkey_length = rowkey.length;
        int total_value_length = 0;
        for (Cell cell : cellList) {
            total_value_length += cell.getValueLength();
        }
        ++sowInner.read_lines;
        sowInner.read_rowkey_bytes += (long)rowkey_length;
        sowInner.read_column_bytes += (long)total_value_length;
    }

    /*
     * Unable to fully structure code
     */
    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (!ZillionConstant.batch) {
            return;
        }
        size = miniBatchOp.size();
        if (size == 0) {
            return;
        }
        rce = (RegionCoprocessorEnvironment)c.getEnvironment();
        desc = rce.getRegion().getTableDesc();
        namespace = desc.getTableName().getNamespaceAsString();
        if (ZillionConstant.ReservedNamespaceMap.containsKey(namespace)) {
            return;
        }
        tableName_tmp = desc.getTableName().getNameAsString().substring(namespace.length() + 1);
        if (tableName_tmp.startsWith("zillion_data_") || tableName_tmp.startsWith("zillion_index_")) ** GOTO lbl19
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
lbl19:
            // 3 sources

            ** while (!ObserverTool.container.initialized)
        }
lbl20:
        // 1 sources

        LogUtil.debug(" ********************************** postBatchMutate");
        HRegionInfo = rce.getRegionInfo();
        region_name = String.valueOf(HRegionInfo.getTable().getNameAsString()) + "," + HRegionInfo.getEncodedName() + "," + Bytes.toStringBinary((byte[])HRegionInfo.getStartKey()) + "," + Bytes.toStringBinary((byte[])HRegionInfo.getEndKey());
        this.Do(namespace, tableName_tmp, miniBatchOp, null, region_name);
    }

    /*
     * Unable to fully structure code
     */
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
        if (ZillionConstant.batch) {
            return;
        }
        rce = (RegionCoprocessorEnvironment)e.getEnvironment();
        desc = rce.getRegion().getTableDesc();
        namespace = desc.getTableName().getNamespaceAsString();
        if (ZillionConstant.ReservedNamespaceMap.containsKey(namespace)) {
            return;
        }
        tableName_tmp = desc.getTableName().getNameAsString().substring(namespace.length() + 1);
        if (tableName_tmp.startsWith("zillion_data_") || tableName_tmp.startsWith("zillion_index_")) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
lbl16:
            // 3 sources

            ** while (!ObserverTool.container.initialized)
        }
lbl17:
        // 1 sources

        LogUtil.debug(" ********************************** postPut");
        HRegionInfo = rce.getRegionInfo();
        region_name = String.valueOf(HRegionInfo.getTable().getNameAsString()) + "," + HRegionInfo.getEncodedName() + "," + Bytes.toStringBinary((byte[])HRegionInfo.getStartKey()) + "," + Bytes.toStringBinary((byte[])HRegionInfo.getEndKey());
        this.Do(namespace, tableName_tmp, null, (Row)put, region_name);
    }

    /*
     * Unable to fully structure code
     */
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (ZillionConstant.batch) {
            return;
        }
        rce = (RegionCoprocessorEnvironment)e.getEnvironment();
        desc = rce.getRegion().getTableDesc();
        namespace = desc.getTableName().getNamespaceAsString();
        if (ZillionConstant.ReservedNamespaceMap.containsKey(namespace)) {
            return;
        }
        tableName_tmp = desc.getTableName().getNameAsString().substring(namespace.length() + 1);
        if (tableName_tmp.startsWith("zillion_data_") || tableName_tmp.startsWith("zillion_index_")) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
lbl16:
            // 3 sources

            ** while (!ObserverTool.container.initialized)
        }
lbl17:
        // 1 sources

        LogUtil.debug(" ********************************** postDelete");
        HRegionInfo = rce.getRegionInfo();
        region_name = String.valueOf(HRegionInfo.getTable().getNameAsString()) + "," + HRegionInfo.getEncodedName() + "," + Bytes.toStringBinary((byte[])HRegionInfo.getStartKey()) + "," + Bytes.toStringBinary((byte[])HRegionInfo.getEndKey());
        this.Do(namespace, tableName_tmp, null, (Row)delete, region_name);
    }

    private void Do(String namespace, String tableName_tmp, MiniBatchOperationInProgress<Mutation> miniBatchOp, Row row, String region_name) {
        try {
            this.Process(namespace, tableName_tmp, miniBatchOp, row);
            this.StatWrite(region_name, miniBatchOp, row);
        }
        catch (Exception e) {
            LogUtil.error(" ********************************** " + namespace + ":" + tableName_tmp + "\n");
            LogUtil.error(e);
        }
    }

    private void StatWrite(String region_name, MiniBatchOperationInProgress<Mutation> miniBatchOp, Row row) throws Exception {
        StatObject sowInner = new StatObject();
        if (miniBatchOp != null) {
            int size = miniBatchOp.size();
            int i = 0;
            while (i < size) {
                Mutation Mutation2 = (Mutation)miniBatchOp.getOperation(i);
                this.StatWriteRow((Row)Mutation2, sowInner);
                ++i;
            }
        } else {
            this.StatWriteRow(row, sowInner);
        }
        if (!ObserverTool.statMap.containsKey(region_name)) {
            ObserverTool.statMap.putIfAbsent(region_name, new StatTableWrapper());
        }
        long milliseconds = new Date().getTime() / ObserverTool.stat_interval;
        StatObjectWrapper sow = ((StatTableWrapper)ObserverTool.statMap.get(region_name)).get(milliseconds);
        sow.read_lines.addAndGet(sowInner.read_lines);
        sow.read_rowkey_bytes.addAndGet(sowInner.read_rowkey_bytes);
        sow.read_column_bytes.addAndGet(sowInner.read_column_bytes);
        sow.insert_lines.addAndGet(sowInner.insert_lines);
        sow.insert_rowkey_bytes.addAndGet(sowInner.insert_rowkey_bytes);
        sow.insert_column_bytes.addAndGet(sowInner.insert_column_bytes);
        sow.update_lines.addAndGet(sowInner.update_lines);
        sow.update_rowkey_bytes.addAndGet(sowInner.update_rowkey_bytes);
        sow.update_column_bytes.addAndGet(sowInner.update_column_bytes);
        sow.delete_lines.addAndGet(sowInner.delete_lines);
        sow.delete_rowkey_bytes.addAndGet(sowInner.delete_rowkey_bytes);
    }

    private void StatWriteRow(Row row, StatObject sowInner) throws Exception {
        int rowkey_length = row.getRow().length;
        if (row instanceof Put) {
            Put put = (Put)row;
            int total_value_length = 0;
            boolean is_update = false;
            List cellList = (List)put.getFamilyCellMap().get(ByteToObject.toBytes("f"));
            for (Cell cell : cellList) {
                byte[] cell_bytes;
                String q;
                byte[] column_name_bytes = CellUtil.cloneQualifier((Cell)cell);
                String column_name = ByteToObject.toString(column_name_bytes);
                if (column_name.equals("u") && (q = ByteToObject.toString(cell_bytes = CellUtil.cloneValue((Cell)cell))).equals("1")) {
                    is_update = true;
                }
                total_value_length += cell.getValueLength();
            }
            if (is_update) {
                ++sowInner.update_lines;
                sowInner.update_rowkey_bytes += (long)rowkey_length;
                sowInner.update_column_bytes += (long)total_value_length;
            } else {
                ++sowInner.insert_lines;
                sowInner.insert_rowkey_bytes += (long)rowkey_length;
                sowInner.insert_column_bytes += (long)total_value_length;
            }
        } else if (row instanceof Delete) {
            ++sowInner.delete_lines;
            sowInner.delete_rowkey_bytes += (long)rowkey_length;
        }
    }

    private void Process(String namespace, String tableName_tmp, MiniBatchOperationInProgress<Mutation> miniBatchOp, Row row) throws Exception {
        HashObjectWrapper HashObjectWrapper2;
        String tableName_inner;
        String child_name;
        SchemaRepository repository = ObserverTool.container.repositoryMap.get(namespace);
        if (tableName_tmp.startsWith("zillion_data_")) {
            child_name = null;
            tableName_inner = tableName_tmp.substring("zillion_data_".length());
            ZillionTableSchema schema = repository.GetTable(tableName_inner);
            if (schema == null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                int index_ = tableName_inner.lastIndexOf("_");
                if (index_ != -1) {
                    String prefix = tableName_inner.substring(0, index_);
                    String suffix = tableName_inner.substring(index_ + 1);
                    try {
                        ZillionTableSchema schemaInner;
                        if (suffix.length() == 10) {
                            sdf.parse(String.valueOf(suffix) + "0000");
                            tableName_inner = prefix;
                            child_name = suffix;
                            schemaInner = repository.GetTable(tableName_inner);
                            if (schemaInner != null && schemaInner.table_type != null && schemaInner.table_type.equals("split_hour")) {
                                schema = schemaInner;
                            }
                        } else if (suffix.length() == 8) {
                            sdf.parse(String.valueOf(suffix) + "000000");
                            tableName_inner = prefix;
                            child_name = suffix;
                            schemaInner = repository.GetTable(tableName_inner);
                            if (schemaInner != null && schemaInner.table_type != null && schemaInner.table_type.equals("split_day")) {
                                schema = schemaInner;
                            }
                        } else if (suffix.length() == 6) {
                            sdf.parse(String.valueOf(suffix) + "01000000");
                            tableName_inner = prefix;
                            child_name = suffix;
                            schemaInner = repository.GetTable(tableName_inner);
                            if (schemaInner != null && schemaInner.table_type != null && schemaInner.table_type.equals("split_month")) {
                                schema = schemaInner;
                            }
                        } else if (suffix.length() == 4) {
                            sdf.parse(String.valueOf(suffix) + "0101000000");
                            tableName_inner = prefix;
                            child_name = suffix;
                            schemaInner = repository.GetTable(tableName_inner);
                            if (schemaInner != null && schemaInner.table_type != null && schemaInner.table_type.equals("split_year")) {
                                schema = schemaInner;
                            }
                        }
                    }
                    catch (ParseException schemaInner) {
                        // empty catch block
                    }
                }
            }
            if (schema != null) {
                HashObjectWrapper2 = child_name != null ? new HashObjectWrapper(child_name) : new HashObjectWrapper();
                if (miniBatchOp != null) {
                    int size = miniBatchOp.size();
                    int i = 0;
                    while (i < size) {
                        Mutation Mutation2 = (Mutation)miniBatchOp.getOperation(i);
                        if (Mutation2 instanceof Put) {
                            Put put = (Put)Mutation2;
                            if (!this.is_update(put)) {
                                if (HTableUtil.valid(schema, (List)put.getFamilyCellMap().get(ByteToObject.toBytes("f")))) {
                                    ++HashObjectWrapper2.hashObject.insert_count;
                                } else {
                                    ++HashObjectWrapper2.hashObject.delete_count;
                                }
                                HashObjectWrapper2.hashObject.hash_code = HashUtil.merge_hash_code(HashObjectWrapper2.hashObject.hash_code, put.getRow());
                            }
                        } else if (Mutation2 instanceof Delete) {
                            Delete delete = (Delete)Mutation2;
                            ++HashObjectWrapper2.hashObject.delete_count;
                            HashObjectWrapper2.hashObject.hash_code = HashUtil.merge_hash_code(HashObjectWrapper2.hashObject.hash_code, delete.getRow());
                        }
                        ++i;
                    }
                } else if (row instanceof Put) {
                    Put put = (Put)row;
                    if (!this.is_update(put)) {
                        if (HTableUtil.valid(schema, (List)put.getFamilyCellMap().get(ByteToObject.toBytes("f")))) {
                            ++HashObjectWrapper2.hashObject.insert_count;
                        } else {
                            ++HashObjectWrapper2.hashObject.delete_count;
                        }
                        HashObjectWrapper2.hashObject.hash_code = HashUtil.merge_hash_code(HashObjectWrapper2.hashObject.hash_code, put.getRow());
                    }
                } else if (row instanceof Delete) {
                    Delete delete = (Delete)row;
                    ++HashObjectWrapper2.hashObject.delete_count;
                    HashObjectWrapper2.hashObject.hash_code = HashUtil.merge_hash_code(HashObjectWrapper2.hashObject.hash_code, delete.getRow());
                }
            } else {
                HashObjectWrapper2 = null;
            }
        } else {
            child_name = null;
            tableName_inner = tableName_tmp.substring("zillion_index_".length());
            int index = tableName_inner.indexOf(46);
            String tableName = tableName_inner.substring(0, index);
            ZillionTableSchema schema = repository.GetTable(tableName);
            String indexName = tableName_inner.substring(index + 1);
            ZillionTableIndex schema_index = repository.GetIndex(tableName, indexName);
            if (schema.table_type != null && schema.table_type.startsWith("split_")) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                int index_ = tableName_inner.lastIndexOf("_");
                if (index_ != -1) {
                    String prefix = tableName_inner.substring(0, index_);
                    String suffix = tableName_inner.substring(index_ + 1);
                    try {
                        if (schema.table_type.equals("split_hour")) {
                            sdf.parse(String.valueOf(suffix) + "0000");
                            tableName_inner = prefix;
                            child_name = suffix;
                            indexName = indexName.substring(0, indexName.length() - suffix.length() - 1);
                            schema_index = repository.GetIndex(tableName, indexName);
                        } else if (schema.table_type.equals("split_day")) {
                            sdf.parse(String.valueOf(suffix) + "000000");
                            tableName_inner = prefix;
                            child_name = suffix;
                            indexName = indexName.substring(0, indexName.length() - suffix.length() - 1);
                            schema_index = repository.GetIndex(tableName, indexName);
                        } else if (schema.table_type.equals("split_month")) {
                            sdf.parse(String.valueOf(suffix) + "01000000");
                            tableName_inner = prefix;
                            child_name = suffix;
                            indexName = indexName.substring(0, indexName.length() - suffix.length() - 1);
                            schema_index = repository.GetIndex(tableName, indexName);
                        } else if (schema.table_type.equals("split_year")) {
                            sdf.parse(String.valueOf(suffix) + "0101000000");
                            tableName_inner = prefix;
                            child_name = suffix;
                            indexName = indexName.substring(0, indexName.length() - suffix.length() - 1);
                            schema_index = repository.GetIndex(tableName, indexName);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if (schema != null && schema_index != null) {
                HashObjectWrapper2 = child_name != null ? new HashObjectWrapper(child_name) : new HashObjectWrapper();
                if (miniBatchOp != null) {
                    int size = miniBatchOp.size();
                    int i = 0;
                    while (i < size) {
                        Mutation Mutation3 = (Mutation)miniBatchOp.getOperation(i);
                        this.ProcessIndex(schema, schema_index.Key, (Row)Mutation3, HashObjectWrapper2);
                        ++i;
                    }
                } else {
                    this.ProcessIndex(schema, schema_index.Key, row, HashObjectWrapper2);
                }
            } else {
                HashObjectWrapper2 = null;
            }
        }
        if (HashObjectWrapper2 != null && (HashObjectWrapper2.hashObject.insert_count > 0L || HashObjectWrapper2.hashObject.delete_count > 0L)) {
            String tablename_real = String.valueOf(namespace) + ":" + tableName_inner;
            LogUtil.debug(" **********************************  hash step 1 \t" + tablename_real + "/" + HashObjectWrapper2.child_name + "\t" + HashObjectWrapper2.hashObject.insert_count + "\t" + HashObjectWrapper2.hashObject.delete_count + "\t" + HexToByte.byteToHex(HashObjectWrapper2.hashObject.hash_code));
            if (!ObserverTool.hash_tmpMap.containsKey(tablename_real)) {
                ObserverTool.hash_tmpMap.putIfAbsent(tablename_real, new ConcurrentLinkedQueue());
            }
            ((ConcurrentLinkedQueue)ObserverTool.hash_tmpMap.get(tablename_real)).offer(HashObjectWrapper2);
        }
    }

    private void ProcessIndex(ZillionTableSchema schema, String[] schema_index_Key, Row row, HashObjectWrapper HashObjectWrapper2) {
        byte[] row_bytes;
        byte[] row_bytes_index = row.getRow();
        if (schema.table_type == null) {
            int offset = 0;
            String[] stringArray = schema_index_Key;
            int n = schema_index_Key.length;
            int n2 = 0;
            while (n2 < n) {
                String column = stringArray[n2];
                ZillionTableColumn ZillionTableColumn2 = schema.ColumnMap.get(column);
                if (row_bytes_index[offset] == 0) {
                    ++offset;
                } else if (ZillionTableColumn2.Type == ZillionTableColumnEnum.STRING) {
                    ++offset;
                    while (row_bytes_index[offset] != 0) {
                        ++offset;
                    }
                    ++offset;
                } else {
                    ++offset;
                    offset += ByteToObject.lengthOfColumnEnum(ZillionTableColumn2.Type);
                }
                ++n2;
            }
            row_bytes = new byte[row_bytes_index.length - offset];
            System.arraycopy(row_bytes_index, offset, row_bytes, 0, row_bytes.length);
        } else {
            HashMap<String, byte[]> key_bytesMap = new HashMap<String, byte[]>();
            int key_bytes_length = 0;
            int offset = 0;
            String[] stringArray = schema_index_Key;
            int n = schema_index_Key.length;
            int n3 = 0;
            while (n3 < n) {
                String column = stringArray[n3];
                ZillionTableColumn ZillionTableColumn3 = schema.ColumnMap.get(column);
                int column_offset = offset;
                if (row_bytes_index[offset] != 0) {
                    if (ZillionTableColumn3.Type == ZillionTableColumnEnum.STRING) {
                        ++offset;
                        while (row_bytes_index[offset] != 0) {
                            ++offset;
                        }
                        ++offset;
                    } else {
                        ++offset;
                        offset += ByteToObject.lengthOfColumnEnum(ZillionTableColumn3.Type);
                    }
                }
                int column_offset_next = ++offset;
                if (schema.KeyMap.containsKey(column)) {
                    byte[] value = new byte[column_offset_next - column_offset];
                    System.arraycopy(row_bytes_index, column_offset, value, 0, value.length);
                    key_bytesMap.put(column, value);
                    key_bytes_length += value.length;
                }
                ++n3;
            }
            row_bytes = new byte[key_bytes_length];
            int copy_length = 0;
            String[] stringArray2 = schema.Key;
            int n4 = schema.Key.length;
            n = 0;
            while (n < n4) {
                String keyInner = stringArray2[n];
                byte[] column_bytes = (byte[])key_bytesMap.get(keyInner);
                System.arraycopy(column_bytes, 0, row_bytes, copy_length, column_bytes.length);
                copy_length += column_bytes.length;
                ++n;
            }
        }
        if (row instanceof Put) {
            Put put = (Put)row;
            if (!this.is_update(put)) {
                if (HTableUtil.valid(schema, (List)put.getFamilyCellMap().get(ByteToObject.toBytes("f")))) {
                    ++HashObjectWrapper2.hashObject.insert_count;
                } else {
                    ++HashObjectWrapper2.hashObject.delete_count;
                }
                HashObjectWrapper2.hashObject.hash_code = HashUtil.merge_hash_code(HashObjectWrapper2.hashObject.hash_code, row_bytes);
            }
        } else if (row instanceof Delete) {
            ++HashObjectWrapper2.hashObject.delete_count;
            HashObjectWrapper2.hashObject.hash_code = HashUtil.merge_hash_code(HashObjectWrapper2.hashObject.hash_code, row_bytes);
        }
    }

    private boolean is_update(Put put) {
        List cellList = (List)put.getFamilyCellMap().get(ByteToObject.toBytes("f"));
        String q = null;
        for (Cell cell : cellList) {
            byte[] column_name_bytes = CellUtil.cloneQualifier((Cell)cell);
            byte[] cell_bytes = CellUtil.cloneValue((Cell)cell);
            String column_name = ByteToObject.toString(column_name_bytes);
            if (!column_name.equals("u")) continue;
            q = ByteToObject.toString(cell_bytes);
            break;
        }
        return q != null && q.equals("1");
    }
}

