/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntArrayDocIdSet;
import org.apache.lucene.util.LSBRadixSorter;

public final class DocIdSetBuilder {
    private final int maxDoc;
    private final int threshold;
    private int[] buffer;
    private int bufferSize;
    private BitSet bitSet;

    public DocIdSetBuilder(int maxDoc) {
        this.maxDoc = maxDoc;
        this.threshold = maxDoc >>> 7;
        this.buffer = new int[0];
        this.bufferSize = 0;
        this.bitSet = null;
    }

    private void upgradeToBitSet() {
        assert (this.bitSet == null);
        this.bitSet = new FixedBitSet(this.maxDoc);
        for (int i = 0; i < this.bufferSize; ++i) {
            this.bitSet.set(this.buffer[i]);
        }
        this.buffer = null;
        this.bufferSize = 0;
    }

    private void growBuffer(int minSize) {
        assert (minSize < this.threshold);
        if (this.buffer.length < minSize) {
            int nextSize = Math.min(this.threshold, ArrayUtil.oversize(minSize, 4));
            int[] newBuffer = new int[nextSize];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }

    public void add(DocIdSetIterator iter) throws IOException {
        this.grow((int)Math.min(Integer.MAX_VALUE, iter.cost()));
        if (this.bitSet != null) {
            this.bitSet.or(iter);
        } else {
            while (true) {
                assert (this.buffer.length <= this.threshold);
                int end = this.buffer.length;
                for (int i = this.bufferSize; i < end; ++i) {
                    int doc = iter.nextDoc();
                    if (doc == Integer.MAX_VALUE) {
                        this.bufferSize = i;
                        return;
                    }
                    this.buffer[this.bufferSize++] = doc;
                }
                this.bufferSize = end;
                if (this.bufferSize + 1 >= this.threshold) break;
                this.growBuffer(this.bufferSize + 1);
            }
            this.upgradeToBitSet();
            int doc = iter.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                this.bitSet.set(doc);
                doc = iter.nextDoc();
            }
        }
    }

    public void grow(int numDocs) {
        if (this.bitSet == null) {
            long newLength = this.bufferSize + numDocs;
            if (newLength < (long)this.threshold) {
                this.growBuffer((int)newLength);
            } else {
                this.upgradeToBitSet();
            }
        }
    }

    public void add(int doc) {
        if (this.bitSet != null) {
            this.bitSet.set(doc);
        } else {
            if (this.bufferSize + 1 > this.buffer.length) {
                if (this.bufferSize + 1 >= this.threshold) {
                    this.upgradeToBitSet();
                    this.bitSet.set(doc);
                    return;
                }
                this.growBuffer(this.bufferSize + 1);
            }
            this.buffer[this.bufferSize++] = doc;
        }
    }

    private static int dedup(int[] arr, int length) {
        if (length == 0) {
            return 0;
        }
        int l = 1;
        int previous = arr[0];
        for (int i = 1; i < length; ++i) {
            int value = arr[i];
            assert (value >= previous);
            if (value == previous) continue;
            arr[l++] = value;
            previous = value;
        }
        return l;
    }

    public DocIdSet build() {
        return this.build(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet build(long costHint) {
        try {
            if (this.bitSet != null) {
                if (costHint == -1L) {
                    BitDocIdSet bitDocIdSet = new BitDocIdSet(this.bitSet);
                    return bitDocIdSet;
                }
                BitDocIdSet bitDocIdSet = new BitDocIdSet(this.bitSet, costHint);
                return bitDocIdSet;
            }
            LSBRadixSorter sorter = new LSBRadixSorter();
            sorter.sort(this.buffer, 0, this.bufferSize);
            int l = DocIdSetBuilder.dedup(this.buffer, this.bufferSize);
            assert (l <= this.bufferSize);
            this.buffer = ArrayUtil.grow(this.buffer, l + 1);
            this.buffer[l] = Integer.MAX_VALUE;
            IntArrayDocIdSet intArrayDocIdSet = new IntArrayDocIdSet(this.buffer, l);
            return intArrayDocIdSet;
        }
        finally {
            this.buffer = null;
            this.bufferSize = 0;
            this.bitSet = null;
        }
    }
}

