/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.server.api.ApplicationContext;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AppAttemptBlock
extends HtmlBlock {
    private static final Log LOG = LogFactory.getLog(AppAttemptBlock.class);
    private final ApplicationContext appContext;

    @Inject
    public AppAttemptBlock(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    protected void render(HtmlBlock.Block html) {
        Collection<ContainerReport> containers;
        ApplicationAttemptReport appAttemptReport;
        String attemptid = this.$("appattempt.id");
        if (attemptid.isEmpty()) {
            this.puts(new Object[]{"Bad request: requires application attempt ID"});
            return;
        }
        ApplicationAttemptId appAttemptId = null;
        try {
            appAttemptId = ConverterUtils.toApplicationAttemptId((String)attemptid);
        }
        catch (IllegalArgumentException e) {
            this.puts(new Object[]{"Invalid application attempt ID: " + attemptid});
            return;
        }
        try {
            appAttemptReport = this.appContext.getApplicationAttempt(appAttemptId);
        }
        catch (IOException e) {
            String message = "Failed to read the application attempt " + appAttemptId + ".";
            LOG.error((Object)message, (Throwable)e);
            html.p()._(new Object[]{message})._();
            return;
        }
        if (appAttemptReport == null) {
            this.puts(new Object[]{"Application Attempt not found: " + attemptid});
            return;
        }
        AppAttemptInfo appAttempt = new AppAttemptInfo(appAttemptReport);
        this.setTitle(StringHelper.join((Object[])new Object[]{"Application Attempt ", attemptid}));
        String node = "N/A";
        if (appAttempt.getHost() != null && appAttempt.getRpcPort() >= 0 && appAttempt.getRpcPort() < 65536) {
            node = appAttempt.getHost() + ":" + appAttempt.getRpcPort();
        }
        this.info("Application Attempt Overview")._("State", (Object)appAttempt.getAppAttemptState())._("Master Container", appAttempt.getAmContainerId() == null ? "#" : this.root_url(new String[]{"container", appAttempt.getAmContainerId()}), (Object)String.valueOf(appAttempt.getAmContainerId()))._("Node:", (Object)node)._("Tracking URL:", appAttempt.getTrackingUrl() == null ? "#" : this.root_url(new String[]{appAttempt.getTrackingUrl()}), (Object)"History")._("Diagnostics Info:", (Object)appAttempt.getDiagnosticsInfo());
        html._(InfoBlock.class);
        try {
            containers = this.appContext.getContainers(appAttemptId).values();
        }
        catch (IOException e) {
            html.p()._(new Object[]{"Sorry, Failed to get containers for application attempt" + attemptid + "."})._();
            return;
        }
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#containers").thead().tr().th(".id", "Container ID").th(".node", "Node").th(".exitstatus", "Container Exit Status").th(".logs", "Logs")._())._()).tbody();
        StringBuilder containersTableData = new StringBuilder("[\n");
        for (ContainerReport containerReport : containers) {
            ContainerInfo container = new ContainerInfo(containerReport);
            containersTableData.append("[\"<a href='").append(this.url(new String[]{"container", container.getContainerId()})).append("'>").append(container.getContainerId()).append("</a>\",\"<a href='").append(container.getAssignedNodeId()).append("'>").append(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)container.getAssignedNodeId()))).append("</a>\",\"").append(container.getContainerExitStatus()).append("\",\"<a href='").append(container.getLogUrl() == null ? "#" : container.getLogUrl()).append("'>").append(container.getLogUrl() == null ? "N/A" : "Logs").append("</a>\"],\n");
        }
        if (containersTableData.charAt(containersTableData.length() - 2) == ',') {
            containersTableData.delete(containersTableData.length() - 2, containersTableData.length() - 1);
        }
        containersTableData.append("]");
        html.script().$type("text/javascript")._(new Object[]{"var containersTableData=" + containersTableData})._();
        ((Hamlet.TABLE)tbody._())._();
    }
}

