/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.core.CoreComputeUtil;
import com.sagacloud.util.compute_engine.core.CoreInput;
import com.sagacloud.util.compute_engine.core.CoreInstance;
import com.sagacloud.util.compute_engine.core.CoreOutput;
import com.sagacloud.util.compute_engine.core.IDao_log;
import com.sagacloud.util.compute_engine.entity.Entity_ci_instance;
import com.sagacloud.util.compute_engine.entity.Entity_ci_instanceinput;
import com.sagacloud.util.compute_engine.entity.Entity_ci_instanceoutput;
import com.sagacloud.util.compute_engine.entity.Entity_point;
import com.sagacloud.util.compute_engine.fjd.ComputeEngineUtil;
import com.sagacloud.util.compute_engine.fjd.InstanceComparator;
import com.sagacloud.util.compute_engine.fjd.TenantUtil;
import com.sagacloud.util.compute_engine.util.Constant;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.InstanceUtil;
import com.sagacloud.util.compute_engine.util.Parser_time_period;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.sagacloud.util.compute_engine.util.SurveyUtil;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.agent.ZillionAgent;
import com.zillion.util.common.ByteToObject;
import com.zillion.util.zk.ZKLockRW;
import com.zillion.util.zk.ZKWrapper;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.zillion.util.json.FastJsonUtil;
import org.zillion.util.log.LogUtil;

public class ThreadCompute
extends Thread {
    ZillionAgent agent;
    String database_name;
    IDao_log dao_log;
    List<String> children = new ArrayList<String>();
    private volatile boolean stop = false;
    Random rand = new Random();

    public ThreadCompute(ZillionAgent agent, String database_name, IDao_log dao_log) {
        this.agent = agent;
        this.database_name = database_name;
        this.dao_log = dao_log;
    }

    public void requestStop() {
        this.stop = true;
    }

    private String Name() {
        try {
            return InetAddress.getLocalHost().getHostAddress() + ":" + this.getName();
        }
        catch (Exception exception) {
            return this.getName();
        }
    }

    @Override
    public void run() {
        List children_tmp;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        ZKWrapper ZK = this.agent.container.ZK;
        int computed_count = 0;
        int child_index = 0;
        String child_name = null;
        try {
            if (ConstantCE.config_mode.equalsIgnoreCase("include")) {
                this.children.addAll(ConstantCE.config_instanceList);
            } else {
                if (ConstantCE.config_mode.equalsIgnoreCase("exclude")) {
                    this.children = new ArrayList<String>();
                    children_tmp = ZK.getChildren(ConstantCE.zk_instance, false);
                    for (String child : children_tmp) {
                        boolean exclude = false;
                        for (String config_instance : ConstantCE.config_instanceList) {
                            if (!config_instance.equals(child)) continue;
                            exclude = true;
                            break;
                        }
                        if (exclude) continue;
                        this.children.add(child);
                    }
                } else {
                    this.children = ZK.getChildren(ConstantCE.zk_instance, false);
                }
                Collections.sort(this.children, new InstanceComparator());
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.children.size(); ++i) {
                    String child;
                    child = this.children.get(i);
                    sb.append("\n\t" + i + "\t" + child);
                }
                Constant.info("ThreadCompute instance initial:" + this.children.size() + sb.toString());
            }
            if (this.children.size() > 0) {
                child_index = this.rand.nextInt(this.children.size());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        while (!this.stop) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            try {
                if (!ConstantCE.config_mode.equalsIgnoreCase("include")) {
                    if (ConstantCE.config_mode.equalsIgnoreCase("exclude")) {
                        this.children = new ArrayList<String>();
                        children_tmp = ZK.getChildren(ConstantCE.zk_instance, false);
                        for (String child : children_tmp) {
                            boolean exclude = false;
                            for (String config_instance : ConstantCE.config_instanceList) {
                                if (!config_instance.equals(child)) continue;
                                exclude = true;
                                break;
                            }
                            if (exclude) continue;
                            this.children.add(child);
                        }
                    } else {
                        this.children = ZK.getChildren(ConstantCE.zk_instance, false);
                    }
                    Collections.sort(this.children, new InstanceComparator());
                }
                if (this.children.size() == 0) continue;
                if (child_name != null) {
                    for (int i = 0; i < this.children.size(); ++i) {
                        String childInner = this.children.get(i);
                        if (!childInner.equals(child_name)) continue;
                        child_index = i;
                        break;
                    }
                }
                ++child_index;
                String name = child_name = this.children.get(child_index %= this.children.size());
                Stat stat = ZK.exists(ConstantCE.zk_compute_time_last + "/" + name, false);
                if (stat != null) {
                    stat = new Stat();
                    byte[] dataBytes = ZK.getData(ConstantCE.zk_compute_interval + "/" + name, false, stat);
                    String dataString = ByteToObject.toString((byte[])dataBytes);
                    long compute_interval_seconds = Long.parseLong(dataString);
                    stat = new Stat();
                    byte[] dataBytes2 = ZK.getData(ConstantCE.zk_compute_time_last + "/" + name, false, stat);
                    String dataString2 = ByteToObject.toString((byte[])dataBytes2);
                    Date compute_time_last = sdf.parse(dataString2);
                    Date currentDate = new Date();
                    if (currentDate.getTime() - compute_time_last.getTime() < 1000L * compute_interval_seconds) continue;
                }
                String lock_name = name.startsWith("Pj") || name.startsWith("Bd") ? name.substring(2, 12) : (name.startsWith("VOBd") ? name.substring(4, 14) : name.substring(0, 10));
                String parent_path_meta = ConstantCE.zk_lock + "/" + lock_name;
                stat = ZK.exists(parent_path_meta, false);
                if (stat == null) {
                    try {
                        ZK.create(parent_path_meta, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                    }
                    catch (Exception compute_time_last) {
                        // empty catch block
                    }
                }
                String lock_type_meta = "w";
                String node_path_meta = ZKLockRW.Create((ZKWrapper)ZK, (String)parent_path_meta, (String)lock_type_meta, (String)this.Name());
                try {
                    boolean wait_success = ZKLockRW.WaitOnce((ZKWrapper)ZK, (String)parent_path_meta, (String)node_path_meta);
                    Constant.debug("ThreadCompute instance wait lock " + child_name + " " + node_path_meta + " " + wait_success);
                    if (!wait_success) continue;
                    Date currentDate = new Date();
                    boolean computed = this.Compute(name);
                    if (!computed) continue;
                    ++computed_count;
                    stat = ZK.exists(ConstantCE.zk_compute_time_last + "/" + name, false);
                    if (stat != null) {
                        ZK.setData(ConstantCE.zk_compute_time_last + "/" + name, sdf.format(currentDate).getBytes(), -1);
                        continue;
                    }
                    ZK.create(ConstantCE.zk_compute_time_last + "/" + name, sdf.format(currentDate).getBytes(), CreateMode.PERSISTENT);
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    ZKLockRW.Finish((ZKWrapper)ZK, (String)node_path_meta);
                    Constant.debug("ThreadCompute instance finish lock " + child_name + " " + node_path_meta);
                }
            }
            catch (Exception e) {
                Constant.warn(e);
            }
        }
        Constant.warn(this.Name() + "\tcomputed_count:" + computed_count + "\tfinish");
        computed_count = 0;
    }

    private boolean Compute(String name) throws Exception {
        JSONArray content;
        JSONObject Criteria;
        JSONObject Criteria2;
        Object data_typeList;
        String instance_name_tmp;
        Stat stat;
        ZKWrapper ZK = this.agent.container.ZK;
        String parent_path_meta = ConstantCE.zk_status_request + "/" + name;
        byte[] data_bytes = ZK.getData(parent_path_meta, false, stat = new Stat());
        String request = new String(data_bytes, "UTF-8");
        if (request.equals("stop")) {
            return false;
        }
        int index_ = name.indexOf("_");
        String object_sign = name.substring(0, index_);
        String instance_name = name.substring(index_ + 1);
        Entity_ci_instance ci_instance = InstanceUtil.Get((IZillionAgent)this.agent, ConstantCE.database_name, object_sign, instance_name);
        if (instance_name.equals("servicedata_stat") || instance_name.equals("servicedataoftenant_stat") || instance_name.equals("EMS_stat") || instance_name.equals("tenant_stat") || instance_name.equals("stat_Inst_stat")) {
            ci_instance = InstanceUtil.Get((IZillionAgent)this.agent, ConstantCE.database_name, object_sign, instance_name.substring(0, instance_name.length() - "_stat".length()));
            ci_instance.setInstance_name(instance_name);
        } else if (instance_name.startsWith("fjd_1")) {
            ci_instance = InstanceUtil.Get((IZillionAgent)this.agent, ConstantCE.database_name, object_sign, "fjd_0" + instance_name.substring("fjd_0".length()));
            ci_instance.setInstance_name(instance_name);
        }
        if (ci_instance == null) {
            LogUtil.error((String)(name + " not exist in db!"));
            throw new Exception(name + " not exist in db!");
        }
        if (ci_instance.getFlag_valid() == 0L) {
            return false;
        }
        if (ConstantCE.Stat_enable && (instance_name.equals("servicedata") || instance_name.equals("servicedataoftenant") || instance_name.equals("EMS") || instance_name.equals("tenant") || instance_name.equals("stat_Inst"))) {
            instance_name_tmp = instance_name + "_stat";
            InstanceUtil.Add_tmp(this.children, object_sign, instance_name, instance_name_tmp, ZK, this.agent, this.database_name);
        }
        if (ConstantCE.fjd_1_enable && instance_name.startsWith("fjd_0")) {
            instance_name_tmp = "fjd_1" + instance_name.substring("fjd_0".length());
            InstanceUtil.Add_tmp(this.children, object_sign, instance_name, instance_name_tmp, ZK, this.agent, this.database_name);
        }
        CoreInstance instance = CoreInstance.Convert(ci_instance);
        String building = instance.object_sign;
        if (instance.instance_name.startsWith("fjd_0") || instance.instance_name.startsWith("fjd_1")) {
            instance.inputList.clear();
            instance.outputList.clear();
            data_typeList = new ArrayList<String>();
            if (instance.instance_name.contains("_Acc")) {
                data_typeList.add("Acc");
                data_typeList.add("InAc");
            }
            if (instance.instance_name.contains("_Inst")) {
                data_typeList.add("Inst");
            }
            if (instance.instance_name.contains("_EnumV")) {
                data_typeList.add("Boolv");
                data_typeList.add("Enumv");
                data_typeList.add("Step");
                data_typeList.add("Set_Inst");
                data_typeList.add("Set_Boolv");
                data_typeList.add("Set_Enumv");
            }
            if (!QueryUtil.table_exist((IZillionAgent)this.agent, this.database_name, "dy_pointlist")) {
                return false;
            }
            Criteria2 = new JSONObject();
            Criteria2.put("building", (Object)building);
            JSONArray content2 = new JSONArray();
            JSONArray contentInner = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "dy_pointlist", Criteria2);
            for (int i = 0; i < contentInner.size(); ++i) {
                JSONObject contentItem = (JSONObject)contentInner.get(i);
                contentItem.put("point_class", (Object)"ori");
                content2.add((Object)contentItem);
            }
            for (int i = 0; i < content2.size(); ++i) {
                JSONObject json = (JSONObject)content2.get(i);
                Entity_point detail = (Entity_point)FastJsonUtil.To_JavaObject((Object)json, Entity_point.class);
                boolean match = false;
                Iterator iterator = data_typeList.iterator();
                while (iterator.hasNext()) {
                    String data_type = (String)iterator.next();
                    if (!detail.data_type.equalsIgnoreCase(data_type)) continue;
                    match = true;
                    break;
                }
                if (!match || ConstantCE.funcid_IncludesMap.size() > 0 && !ConstantCE.funcid_IncludesMap.containsKey(detail.funcid) || ConstantCE.funcid_ExcludesMap.containsKey(detail.funcid)) continue;
                Entity_ci_instanceinput input = new Entity_ci_instanceinput();
                input.setObject_sign(object_sign);
                input.setInstance_name(instance_name);
                input.setInput_sign("ori_" + detail.meter + "_" + detail.funcid);
                input.setTime_period(detail.collect_cycle);
                input.setData_class("near");
                input.setDao_type(detail.point_class);
                JSONObject dao_key = new JSONObject();
                dao_key.put("building", (Object)building);
                dao_key.put("meter", (Object)detail.meter);
                dao_key.put("funcid", (Object)detail.funcid);
                input.setDao_key(dao_key.toJSONString());
                input.setSource_object_sign(building);
                input.setSource_instance_name("ori");
                input.setSource_output_sign(detail.data_type + "_ori_" + detail.meter + "_" + detail.funcid);
                CoreInput CoreInput2 = CoreInstance.Convert_input(input);
                instance.inputList.add(CoreInput2);
                Entity_ci_instanceoutput output = new Entity_ci_instanceoutput();
                output.setObject_sign(object_sign);
                output.setInstance_name(instance_name);
                output.setOutput_sign("fjd_0_" + detail.meter + "_" + detail.funcid);
                output.setTime_begin("19700101000000");
                output.setTime_end("99990101000000");
                output.setData_class("near");
                output.setDao_type("fjd_0");
                dao_key = new JSONObject();
                dao_key.put("building", (Object)building);
                dao_key.put("meter", (Object)detail.meter);
                dao_key.put("funcid", (Object)detail.funcid);
                output.setDao_key(dao_key.toJSONString());
                output.setNeed_all_var_data(true);
                output.setTime_period_intialized(true);
                output.setTime_period(detail.collect_cycle);
                output.setMode("expression");
                output.setExpression("ori_" + detail.meter + "_" + detail.funcid);
                CoreOutput CoreOutput2 = CoreInstance.Convert_output(output);
                instance.outputList.add(CoreOutput2);
            }
        } else if (instance.instance_name.startsWith("stat_Inst")) {
            instance.inputList.clear();
            instance.outputList.clear();
            if (!QueryUtil.table_exist((IZillionAgent)this.agent, this.database_name, "dy_pointlist")) {
                return false;
            }
            Criteria = new JSONObject();
            Criteria.put("building", (Object)building);
            content = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "dy_pointlist", Criteria);
            for (int i = 0; i < content.size(); ++i) {
                JSONObject json = (JSONObject)content.get(i);
                Entity_point detail = (Entity_point)FastJsonUtil.To_JavaObject((Object)json, Entity_point.class);
                if (!detail.data_type.equals("Inst") || ConstantCE.funcid_IncludesMap.size() > 0 && !ConstantCE.funcid_IncludesMap.containsKey(detail.funcid) || ConstantCE.funcid_ExcludesMap.containsKey(detail.funcid)) continue;
                Entity_ci_instanceinput input = new Entity_ci_instanceinput();
                input.setObject_sign(object_sign);
                input.setInstance_name(instance_name);
                input.setInput_sign("meterdata_" + detail.meter + "_" + detail.funcid);
                input.setTime_period(detail.collect_cycle);
                input.setData_class("near");
                input.setDao_type("fjd_near");
                JSONObject dao_key = new JSONObject();
                dao_key.put("building", (Object)building);
                dao_key.put("meter", (Object)detail.meter);
                dao_key.put("funcid", (Object)detail.funcid);
                input.setDao_key(dao_key.toJSONString());
                input.setSource_object_sign(building);
                input.setSource_instance_name("fjd");
                input.setSource_output_sign(detail.meter + "_" + detail.funcid);
                CoreInput CoreInput3 = CoreInstance.Convert_input(input);
                instance.inputList.add(CoreInput3);
                Entity_ci_instanceoutput output = new Entity_ci_instanceoutput();
                output.setObject_sign(object_sign);
                output.setInstance_name(instance_name);
                output.setOutput_sign("inststat_" + detail.meter + "_" + detail.funcid);
                output.setTime_begin("19700101000000");
                output.setTime_end("99990101000000");
                output.setData_class("inststat");
                output.setDao_type("inststat");
                dao_key = new JSONObject();
                dao_key.put("building", (Object)building);
                dao_key.put("meter", (Object)detail.meter);
                dao_key.put("funcid", (Object)detail.funcid);
                output.setDao_key(dao_key.toJSONString());
                output.setNeed_all_var_data(true);
                output.setTime_period_intialized(true);
                output.setTime_period(detail.collect_cycle);
                output.setMode("expression");
                output.setExpression("meterdata_" + detail.meter + "_" + detail.funcid);
                CoreOutput CoreOutput3 = CoreInstance.Convert_output(output);
                instance.outputList.add(CoreOutput3);
            }
        } else if (instance.instance_name.startsWith("servicedata")) {
            int i;
            if (ConstantCE.servicedata_use_survey) {
                Criteria = new JSONObject();
                Criteria.put("building", (Object)building);
                content = new JSONArray();
                JSONArray contentInner = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "dy_reportpointlist", Criteria);
                for (int i2 = 0; i2 < contentInner.size(); ++i2) {
                    JSONObject contentItem = (JSONObject)contentInner.get(i2);
                    contentItem.put("point_class", (Object)"report");
                    content.add((Object)contentItem);
                }
                for (CoreInput CoreInput4 : instance.inputList) {
                    boolean is_report = false;
                    for (int i3 = 0; i3 < content.size(); ++i3) {
                        JSONObject contentItem = (JSONObject)content.get(i3);
                        String meter = (String)contentItem.get((Object)"meter");
                        long funcid = (Long)contentItem.get((Object)"funcid");
                        String source_output_sign = meter + "_" + funcid;
                        if (!source_output_sign.equals(CoreInput4.source_output_sign)) continue;
                        is_report = true;
                        break;
                    }
                    if (!is_report) continue;
                    CoreInput4.data_class = "report";
                    CoreInput4.dao_type = "report";
                    CoreInput4.source_instance_name = "report";
                }
            } else {
                JSONObject contentItem;
                int i4;
                instance.inputList.clear();
                instance.outputList.clear();
                if (!QueryUtil.table_exist((IZillionAgent)this.agent, this.database_name, "dy_pointlist")) {
                    return false;
                }
                Criteria = new JSONObject();
                Criteria.put("building", (Object)building);
                content = new JSONArray();
                JSONArray contentInner = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "dy_pointlist", Criteria);
                for (i4 = 0; i4 < contentInner.size(); ++i4) {
                    contentItem = (JSONObject)contentInner.get(i4);
                    contentItem.put("point_class", (Object)"fjd_near");
                    content.add((Object)contentItem);
                }
                contentInner = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "dy_reportpointlist", Criteria);
                for (i4 = 0; i4 < contentInner.size(); ++i4) {
                    contentItem = (JSONObject)contentInner.get(i4);
                    contentItem.put("point_class", (Object)"report");
                    content.add((Object)contentItem);
                }
                for (int i5 = 0; i5 < content.size(); ++i5) {
                    JSONObject json = (JSONObject)content.get(i5);
                    Entity_point detail = (Entity_point)FastJsonUtil.To_JavaObject((Object)json, Entity_point.class);
                    if (!detail.data_type.equals("Acc") && !detail.data_type.equals("InAc") || ConstantCE.funcid_IncludesMap.size() > 0 && !ConstantCE.funcid_IncludesMap.containsKey(detail.funcid) || ConstantCE.funcid_ExcludesMap.containsKey(detail.funcid)) continue;
                    Entity_ci_instanceinput input = new Entity_ci_instanceinput();
                    input.setObject_sign(object_sign);
                    input.setInstance_name(instance_name);
                    input.setInput_sign("meterdata_" + detail.meter + "_" + detail.funcid);
                    input.setTime_period(detail.collect_cycle);
                    if (detail.point_class.equals("report")) {
                        input.setData_class("report");
                        input.setDao_type("report");
                        input.setSource_instance_name("report");
                    } else {
                        input.setData_class("near");
                        input.setDao_type("fjd_near");
                        input.setSource_instance_name("fjd");
                    }
                    input.setSource_object_sign(building);
                    input.setSource_output_sign(detail.meter + "_" + detail.funcid);
                    JSONObject dao_key = new JSONObject();
                    dao_key.put("building", (Object)building);
                    dao_key.put("meter", (Object)detail.meter);
                    dao_key.put("funcid", (Object)detail.funcid);
                    input.setDao_key(dao_key.toJSONString());
                    CoreInput CoreInput5 = CoreInstance.Convert_input(input);
                    instance.inputList.add(CoreInput5);
                    Entity_ci_instanceoutput output = new Entity_ci_instanceoutput();
                    output.setObject_sign(object_sign);
                    output.setInstance_name(instance_name);
                    output.setOutput_sign("servicedata_" + detail.meter + "_" + detail.funcid);
                    output.setTime_begin("19700101000000");
                    output.setTime_end("99990101000000");
                    output.setData_class("consumption");
                    output.setDao_type("servicedata");
                    dao_key = new JSONObject();
                    dao_key.put("building", (Object)building);
                    dao_key.put("meter", (Object)detail.meter);
                    dao_key.put("funcid", (Object)detail.funcid);
                    output.setDao_key(dao_key.toJSONString());
                    output.setNeed_all_var_data(true);
                    output.setTime_period_intialized(true);
                    output.setTime_period(detail.collect_cycle);
                    output.setMode("expression");
                    output.setExpression("meterdata_" + detail.meter + "_" + detail.funcid + "'+1-meterdata_" + detail.meter + "_" + detail.funcid);
                    CoreOutput CoreOutput4 = CoreInstance.Convert_output(output);
                    instance.outputList.add(CoreOutput4);
                }
            }
            Criteria = new JSONObject();
            Criteria.put("building", (Object)building);
            content = new JSONArray();
            JSONArray contentInner = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "dy_pointlist", Criteria);
            for (i = 0; i < contentInner.size(); ++i) {
                JSONObject contentItem = (JSONObject)contentInner.get(i);
                contentItem.put("point_class", (Object)"fjd_near");
                content.add((Object)contentItem);
            }
            contentInner = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "dy_reportpointlist", Criteria);
            for (i = 0; i < contentInner.size(); ++i) {
                JSONObject contentItem = (JSONObject)contentInner.get(i);
                contentItem.put("point_class", (Object)"report");
                content.add((Object)contentItem);
            }
            block12: for (int i6 = 0; i6 < content.size(); ++i6) {
                JSONObject json = (JSONObject)content.get(i6);
                Entity_point detail = (Entity_point)FastJsonUtil.To_JavaObject((Object)json, Entity_point.class);
                if (!detail.data_type.equals("Acc") && !detail.data_type.equals("InAc") || ConstantCE.funcid_IncludesMap.size() > 0 && !ConstantCE.funcid_IncludesMap.containsKey(detail.funcid) || ConstantCE.funcid_ExcludesMap.containsKey(detail.funcid)) continue;
                for (CoreInput CoreInput6 : instance.inputList) {
                    if (!CoreInput6.input_sign.equals("meterdata_" + detail.meter + "_" + detail.funcid)) continue;
                    CoreInput6.data_type = detail.data_type;
                    continue block12;
                }
            }
        } else if (instance.instance_name.startsWith("tenant")) {
            instance.inputList.clear();
            instance.outputList.clear();
            data_typeList = new ArrayList();
            data_typeList.add("Acc");
            if (!QueryUtil.table_exist((IZillionAgent)this.agent, this.database_name, "dy_pointlist")) {
                return false;
            }
            Criteria2 = new JSONObject();
            Criteria2.put("building", (Object)building);
            JSONArray content3 = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "dy_pointlist", Criteria2);
            HashMap<String, Entity_point> pointMap = new HashMap<String, Entity_point>();
            for (int i = 0; i < content3.size(); ++i) {
                JSONObject json = (JSONObject)content3.get(i);
                Entity_point detail = (Entity_point)FastJsonUtil.To_JavaObject((Object)json, Entity_point.class);
                boolean match = false;
                Iterator iterator = data_typeList.iterator();
                while (iterator.hasNext()) {
                    String data_type = (String)iterator.next();
                    if (!detail.data_type.equalsIgnoreCase(data_type)) continue;
                    match = true;
                    break;
                }
                if (!match || ConstantCE.funcid_IncludesMap.size() > 0 && !ConstantCE.funcid_IncludesMap.containsKey(detail.funcid) || ConstantCE.funcid_ExcludesMap.containsKey(detail.funcid)) continue;
                pointMap.put(detail.meter + "_" + detail.funcid, detail);
            }
            TenantUtil.buildInstance(this.agent, this.database_name, Criteria2, instance, pointMap);
            if (instance.instance_name.equals("tenant_max")) {
                instance = SurveyUtil.Convert_max(instance);
            }
        }
        if (instance.instance_name.endsWith("_stat")) {
            instance.inputList.clear();
            for (CoreOutput output : instance.outputList) {
                Entity_ci_instanceinput input = new Entity_ci_instanceinput();
                input.setObject_sign(object_sign);
                input.setInstance_name(instance_name);
                input.setInput_sign(output.output_sign);
                if (instance.instance_name.equals("stat_Inst_stat")) {
                    List<String> biggerList = Parser_time_period.getBigger("1y", output.time_period);
                    input.setTime_period(biggerList.get(1));
                } else {
                    input.setTime_period("1d");
                }
                input.setData_class(output.data_class);
                input.setDao_type(output.dao_type);
                input.setSource_object_sign(object_sign);
                input.setSource_instance_name(instance_name.substring(0, instance_name.length() - "_stat".length()));
                input.setSource_output_sign(output.output_sign);
                input.setDao_key(output.dao_key.toJSONString());
                CoreInput CoreInput7 = CoreInstance.Convert_input(input);
                instance.inputList.add(CoreInput7);
                output.expression = output.output_sign;
                output.dao_type = output.dao_type + "_stat";
            }
        }
        CoreComputeUtil.Refresh(instance);
        boolean computed = ComputeEngineUtil.ComputeAndSave(this.agent, this.database_name, instance, this.dao_log);
        return computed;
    }
}

