/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.sagacloud.util.compute_engine.fjd.ComputeJob;
import com.sagacloud.util.compute_engine.fjd.ComputeJobItem;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComputeJobRepository {
    private static ComputeJobRepository instance = new ComputeJobRepository();
    private List<String> JobList = new ArrayList<String>();
    private Map<String, ComputeJob> JobMap = new HashMap<String, ComputeJob>();

    public static ComputeJobRepository Instance() {
        return instance;
    }

    private ComputeJobRepository() {
    }

    public synchronized boolean AddComputeJob(ComputeJob ComputeJob2) {
        String real_sign = "[" + ComputeJob2.object_sign + "]_[" + ComputeJob2.instance_name + "]";
        if (this.JobMap.containsKey(real_sign)) {
            return false;
        }
        this.JobList.add(real_sign);
        this.JobMap.put(real_sign, ComputeJob2);
        return true;
    }

    public synchronized boolean RemoveComputeJob(ComputeJob ComputeJob2) {
        String real_sign = "[" + ComputeJob2.object_sign + "]_[" + ComputeJob2.instance_name + "]";
        if (!this.JobMap.containsKey(real_sign)) {
            return false;
        }
        int index = -1;
        for (int i = 0; i < this.JobList.size(); ++i) {
            String real_signInner = this.JobList.get(i);
            if (!real_signInner.equals(real_sign)) continue;
            index = i;
            break;
        }
        this.JobList.remove(index);
        this.JobMap.remove(real_sign);
        return true;
    }

    public synchronized ComputeJobItem Pop() {
        ComputeJobItem result = null;
        ComputeJob ComputeJob2 = null;
        for (int i = 0; i < this.JobList.size(); ++i) {
            String real_signInner = this.JobList.get(i);
            ComputeJob ComputeJobInner = this.JobMap.get(real_signInner);
            if (ComputeJobInner.pop_count >= ComputeJobInner.inputList.size()) continue;
            ComputeJob2 = ComputeJobInner;
            break;
        }
        if (ComputeJob2 != null) {
            int pop_count;
            result = new ComputeJobItem();
            result.object_sign = ComputeJob2.object_sign;
            result.instance_name = ComputeJob2.instance_name;
            result.inputList = new ArrayList();
            result.outputList = new ArrayList();
            result.compute_round = ComputeJob2.compute_round;
            result.inputdetailListMap = ComputeJob2.inputdetailListMap;
            result.outputdetailListMap = ComputeJob2.outputdetailListMap;
            result.dao_log = ComputeJob2.dao_log;
            result.outputTimeSpanMap = ComputeJob2.outputTimeSpanMap;
            for (int i = pop_count = ComputeJob2.pop_count; i < ComputeJob2.inputList.size() && i < pop_count + ConstantCE.job_batch_count; ++i) {
                result.inputList.add(ComputeJob2.inputList.get(i));
                result.outputList.add(ComputeJob2.outputList.get(i));
                ++ComputeJob2.pop_count;
            }
        }
        return result;
    }

    public synchronized void Finish(ComputeJobItem ComputeJobItem2) {
        String real_sign = "[" + ComputeJobItem2.object_sign + "]_[" + ComputeJobItem2.instance_name + "]";
        if (!this.JobMap.containsKey(real_sign)) {
            return;
        }
        ComputeJob ComputeJob2 = this.JobMap.get(real_sign);
        ComputeJob2.finish_count += ComputeJobItem2.inputList.size();
    }

    public synchronized void FinishWithError(ComputeJobItem ComputeJobItem2) {
        this.Finish(ComputeJobItem2);
        ComputeJobItem2.finish_error = true;
    }
}

